/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.config.hive.meta;

import com.qlangtech.tis.config.hive.meta.IHiveTableParams;
import com.qlangtech.tis.config.hive.meta.PartitionFilter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public abstract class HiveTable
implements IHiveTableParams {
    public static final String KEY_PT_LATEST = "latest";
    private final String name;
    private final Map<String, String> tabParameters;

    public abstract String getStorageLocation();

    public abstract <CONFIG> StoredAs getStoredAs(CONFIG var1, ClassLoader var2);

    public abstract List<String> getPartitionKeys();

    public abstract List<HiveTabColType> getCols();

    @Override
    public String getTabParameter(String paramKey) {
        return this.tabParameters.get(paramKey);
    }

    public abstract List<String> listPaths(PartitionFilter var1);

    public String getTableName() {
        return this.name;
    }

    public HiveTable(String name, Map<String, String> tabParameters) {
        this.name = name;
        this.tabParameters = Objects.requireNonNull(tabParameters, "tabParameters can not be null");
    }

    public static abstract class StoredAs {
        public abstract Properties getSerdeProperties(HiveTable var1);

        public abstract String getSerializationLib();
    }

    public static class HiveTabColType {
        private final String colName;
        private final String type;

        public HiveTabColType(String colName, String type) {
            this.colName = colName;
            this.type = type;
        }

        public String getColName() {
            return this.colName;
        }

        public String getType() {
            return this.type;
        }
    }
}

