/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.config.aliyun;

import com.qlangtech.tis.config.ParamsConfig;
import com.qlangtech.tis.plugin.IdentityName;
import java.util.Objects;

public interface IHttpToken
extends IdentityName {
    public static final String KEY_FIELD_ALIYUN_TOKEN = "aliyunToken";
    public static final String KEY_DISPLAY_NAME = "httpToken";

    public static <T extends IHttpToken> T getToken(String endpoint) {
        return (T)IHttpToken.getToken(endpoint, KEY_DISPLAY_NAME);
    }

    public static <T extends IHttpToken> T getAliyunEndpoint(String endpoint) {
        return (T)IHttpToken.getToken(endpoint, KEY_FIELD_ALIYUN_TOKEN);
    }

    public static IHttpToken getToken(String endpoint, String type) {
        IHttpToken aliyunToken = (IHttpToken)ParamsConfig.getItem(endpoint, type);
        Objects.requireNonNull(aliyunToken, "aliyunToekn can not be null");
        return aliyunToken;
    }

    public String getEndpoint();
}

