/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.config;

import com.alibaba.fastjson.annotation.JSONField;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.annotation.Public;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.credentials.ParamsConfigPluginStore;
import com.qlangtech.tis.util.HeteroEnum;
import com.qlangtech.tis.util.UploadPluginMeta;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

@Public
public abstract class ParamsConfig
implements Describable<ParamsConfig>,
IdentityName,
Predicate<UploadPluginMeta> {
    public static final String CONTEXT_PARAMS_CFG = "params-cfg";

    public static <T extends ParamsConfig> List<T> getItems(String pluginDesc) {
        return ParamsConfig.getItems(pluginDesc, Optional.empty(), p -> true);
    }

    public Option map2SelectOption() {
        return new Option(this.identityValue());
    }

    public static <T extends ParamsConfig> List<T> getItems(String pluginDesc, Optional<String> subpath) {
        return ParamsConfig.getItems(pluginDesc, subpath, p -> true);
    }

    public static <T extends ParamsConfig> List<T> getItems(String pluginDesc, Optional<String> subpath, Predicate<T> filter) {
        IPluginStore<T> paramsCfgStore = ParamsConfig.getTargetPluginStore(CONTEXT_PARAMS_CFG, pluginDesc, subpath);
        return paramsCfgStore.getPlugins().stream().map(p -> p).filter(filter).collect(Collectors.toList());
    }

    @Override
    public boolean test(UploadPluginMeta uploadPluginMeta) {
        return true;
    }

    public static <T extends ParamsConfig> IPluginStore<T> getTargetPluginStore(String targetItemDesc) {
        if (StringUtils.isEmpty((String)targetItemDesc)) {
            throw new IllegalArgumentException("param targetItemDesc can not be empty");
        }
        UploadPluginMeta pluginMeta = ParamsConfigPluginStore.createParamsConfig(targetItemDesc);
        return ParamsConfig.getTargetPluginStore(UploadPluginMeta.TargetDesc.create(pluginMeta));
    }

    public static <T extends ParamsConfig> IPluginStore<T> getTargetPluginStore(UploadPluginMeta.TargetDesc desc) {
        return ParamsConfig.getTargetPluginStore(CONTEXT_PARAMS_CFG, desc);
    }

    public static <T extends ParamsConfig> IPluginStore<T> getTargetPluginStore(String childContextDir, UploadPluginMeta.TargetDesc desc) {
        if (desc == null || StringUtils.isEmpty((String)desc.matchTargetPluginDescName)) {
            throw new IllegalStateException("desc param is not illegal, desc:" + (desc == null ? "null" : desc.toString()));
        }
        return ParamsConfig.getTargetPluginStore(childContextDir, desc.matchTargetPluginDescName, Optional.empty());
    }

    public static <T extends ParamsConfig> IPluginStore<T> getTargetPluginStore(String childContextDir, String targetPluginDesc, Optional<String> subpath) {
        return ParamsConfig.getTargetPluginStore(childContextDir, targetPluginDesc, subpath, true);
    }

    public static <T extends ParamsConfig> IPluginStore<T> getTargetPluginStore(String childContextDir, String targetPluginDesc, Optional<String> subpath, boolean validateExist) {
        if (StringUtils.isEmpty((String)targetPluginDesc)) {
            throw new IllegalStateException("param targetPluginDesc can not be null");
        }
        IPluginStore<T> childPluginStore = ParamsConfig.getChildPluginStore(childContextDir, targetPluginDesc, subpath);
        if (validateExist && childPluginStore == null) {
            throw new IllegalStateException("targetPluginDesc:" + targetPluginDesc + " relevant childPluginStore can not be null");
        }
        return childPluginStore;
    }

    public static IPluginStore<ParamsConfig> getChildPluginStore(String childContextDir, String childFile) {
        return ParamsConfig.getChildPluginStore(childContextDir, childFile, Optional.empty());
    }

    public static <T extends ParamsConfig> IPluginStore<T> getChildPluginStore(String childContextDir, String childFile, Optional<String> subpath) {
        if (StringUtils.isEmpty((String)childFile)) {
            throw new IllegalArgumentException("param childFile can not be empty");
        }
        return TIS.getPluginStore(new KeyedPluginStore.Key<ParamsConfig>(childContextDir, new KeyedPluginStore.KeyVal(childFile, subpath), ParamsConfig.class));
    }

    public abstract <INSTANCE> INSTANCE createConfigInstance();

    public static <T extends ParamsConfig> T getItem(String identityName, String targetPluginDesc) {
        return ParamsConfig.getItem(identityName, targetPluginDesc, Optional.empty(), true);
    }

    public static <T extends ParamsConfig> T getItem(String identityName, String targetPluginDesc, Optional<String> subpath, boolean valiateNull) {
        if (StringUtils.isEmpty((String)identityName)) {
            throw new IllegalArgumentException("param identityName can not be empty");
        }
        List<ParamsConfig> items = ParamsConfig.getItems(targetPluginDesc, subpath, p -> true);
        for (ParamsConfig i : items) {
            if (!StringUtils.equals((String)i.identityValue(), (String)identityName)) continue;
            return (T)i;
        }
        if (valiateNull) {
            throw new IllegalStateException("Name:" + identityName + ",type:" + targetPluginDesc + " can not find relevant config in[" + items.stream().map(r -> r.identityValue()).collect(Collectors.joining(",")) + "]");
        }
        return null;
    }

    @JSONField(serialize=false)
    public final BasicParamsConfigDescriptor getDescriptor() {
        Descriptor desc = TIS.get().getDescriptor(this.getClass());
        if (desc == null) {
            throw new IllegalStateException("describle class:" + this.getClass() + " relevant desc can not be null");
        }
        Class<? extends BasicParamsConfigDescriptor> basicDescriptorClass = this.getBasicParamsConfigDescriptorClass();
        if (!basicDescriptorClass.isAssignableFrom(desc.getClass())) {
            throw new IllegalStateException(desc.getClass().getSimpleName() + " must be child of " + basicDescriptorClass.getName());
        }
        return (BasicParamsConfigDescriptor)desc;
    }

    protected Class<? extends BasicParamsConfigDescriptor> getBasicParamsConfigDescriptorClass() {
        return BasicParamsConfigDescriptor.class;
    }

    public static List<Descriptor<ParamsConfig>> all(Class<?> type) {
        List<Descriptor<ParamsConfig>> desc = HeteroEnum.PARAMS_CONFIG.descriptors();
        return desc.stream().filter(r -> type.isAssignableFrom(r.getT())).collect(Collectors.toList());
    }

    public String getStoreGroup() {
        return this.getDescriptor().paramsConfigType();
    }

    public static abstract class BasicParamsConfigDescriptor
    extends Descriptor<ParamsConfig> {
        private final String paramsConfigType;

        public BasicParamsConfigDescriptor(String paramsConfigType) {
            this.paramsConfigType = paramsConfigType;
        }

        public final String paramsConfigType() {
            return this.paramsConfigType;
        }

        @Override
        public String getDisplayName() {
            return this.paramsConfigType;
        }
    }
}

