/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.async.message.client.consumer.impl;

import com.alibaba.citrus.turbine.Context;
import com.google.common.collect.Lists;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.annotation.Public;
import com.qlangtech.tis.async.message.client.consumer.IFlinkColCreator;
import com.qlangtech.tis.async.message.client.consumer.IMQListenerFactory;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.datax.SelectedTabExtend;
import com.qlangtech.tis.plugin.ds.DataSourceMeta;
import com.qlangtech.tis.plugin.incr.ISelectedTabExtendFactory;
import com.qlangtech.tis.plugin.timezone.TISTimeZone;
import com.qlangtech.tis.realtime.transfer.DTO;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.util.HeteroEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;

@Public
public abstract class MQListenerFactory
implements IMQListenerFactory,
Describable<MQListenerFactory> {
    private static final String KEY_filterRowKind = "filterRowKind";
    @FormField(ordinal=10, advance=true, type=FormFieldType.ENUM, validate={})
    public List<String> filterRowKind;

    public static String dftZoneId() {
        return TISTimeZone.dftZoneId();
    }

    public static List<Option> availableZoneIds() {
        return TISTimeZone.availableZoneIds();
    }

    public List<DTO.EventType> getFilterRowKinds() {
        if (CollectionUtils.isEmpty(this.filterRowKind)) {
            return Collections.emptyList();
        }
        ArrayList kinds = Lists.newArrayList();
        for (String filter : this.filterRowKind) {
            kinds.add(DTO.EventType.parse((String)filter));
        }
        return kinds;
    }

    public static List<Option> availableRowKinds() {
        ArrayList<Option> opts = new ArrayList<Option>();
        for (DTO.EventType rk : DTO.EventType.values()) {
            opts.add(new Option(rk.getTypeName(), (Object)rk.getTypeName()));
        }
        return opts;
    }

    public abstract <FlinkColType> IFlinkColCreator<FlinkColType> createFlinkColCreator(DataSourceMeta var1);

    public static Optional<Descriptor<SelectedTabExtend>> getIncrSourceSelectedTabExtendDescriptor(DataXName dataXName) {
        MQListenerFactory incrSourceFactory = HeteroEnum.getIncrSourceListenerFactory(dataXName);
        Descriptor<MQListenerFactory> descriptor = incrSourceFactory.getDescriptor();
        if (!(descriptor instanceof ISelectedTabExtendFactory)) {
            return Optional.empty();
        }
        Descriptor<SelectedTabExtend> selectedTableExtendDesc = ((ISelectedTabExtendFactory)((Object)descriptor)).getSelectedTableExtendDescriptor();
        return Optional.ofNullable(selectedTableExtendDesc);
    }

    @Override
    public Descriptor<MQListenerFactory> getDescriptor() {
        Descriptor descriptor = TIS.get().getDescriptor(this.getClass());
        if (descriptor == null) {
            throw new IllegalStateException("class:" + this.getClass() + " relevant descriptor can not be null");
        }
        Class expectClass = this.getExpectDescClass();
        if (!expectClass.isAssignableFrom(descriptor.getClass())) {
            throw new IllegalStateException(descriptor.getClass() + " must implement the Descriptor of " + expectClass.getName());
        }
        return descriptor;
    }

    protected <TT extends BaseDescriptor> Class<TT> getExpectDescClass() {
        return BaseDescriptor.class;
    }

    public static abstract class BaseDescriptor
    extends Descriptor<MQListenerFactory>
    implements IEndTypeGetter {
        @Override
        protected final boolean validateAll(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            MQListenerFactory sourceFactory = (MQListenerFactory)postFormVals.newInstance();
            if (sourceFactory.getFilterRowKinds().size() == DTO.EventType.values().length) {
                msgHandler.addFieldError(context, MQListenerFactory.KEY_filterRowKind, "\u4e0d\u80fd\u9009\u62e9\u5168\u90e8\u7c7b\u578b\uff0c\u5982\u6b64\u4f1a\u8fc7\u6ee4\u6389\u6240\u6709\u7684\u4e8b\u4ef6", new Object[0]);
                return false;
            }
            return this.validateMQListenerForm(msgHandler, context, sourceFactory);
        }

        protected boolean validateMQListenerForm(IControlMsgHandler msgHandler, Context context, MQListenerFactory sourceFactory) {
            return true;
        }

        @Override
        public final Map<String, Object> getExtractProps() {
            Map<String, Object> eprops = super.getExtractProps();
            Optional<IEndTypeGetter.EndType> targetType = this.getTargetType();
            eprops.put("targetType", targetType.isPresent() ? targetType.get().getVal() : "all");
            eprops.put("extendSelectedTabProp", this instanceof ISelectedTabExtendFactory && ((ISelectedTabExtendFactory)((Object)this)).getSelectedTableExtendDescriptor() != null);
            return eprops;
        }

        public Optional<IEndTypeGetter.EndType> getTargetType() {
            return Optional.of(this.getEndType());
        }
    }
}

