/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.async.message.client.consumer;

import com.qlangtech.tis.datax.TableAlias;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Tab2OutputTag<DTOStream>
implements Serializable {
    private final Map<TableAlias, DTOStream> mapper;
    private transient Map<String, DTOStream> sinkMapper;
    private transient Map<String, DTOStream> sourceMapper;

    public Tab2OutputTag(Map<TableAlias, DTOStream> mapper) {
        this.mapper = mapper;
    }

    public DTOStream get(ISelectedTab tab) {
        return this.getSourceMapper().get(tab.getName());
    }

    public Set<Map.Entry<TableAlias, DTOStream>> entrySet() {
        return this.mapper.entrySet();
    }

    public <TAG> Map<String, TAG> createTab2OutputTag(Function<DTOStream, TAG> tagCreator) {
        return this.entrySet().stream().collect(Collectors.toMap(e -> {
            EntityName entity = EntityName.parse((String)((TableAlias)e.getKey()).getFrom());
            return entity.getTabName();
        }, e -> tagCreator.apply(e.getValue())));
    }

    public Map<String, DTOStream> getSinkMapper() {
        if (this.sinkMapper == null) {
            this.sinkMapper = this.getMapper(false);
        }
        return this.sinkMapper;
    }

    private Map<String, DTOStream> getMapper(boolean from) {
        Set<Map.Entry<TableAlias, DTOStream>> entries = this.mapper.entrySet();
        return entries.stream().collect(Collectors.toMap(e -> from ? ((TableAlias)e.getKey()).getFrom() : ((TableAlias)e.getKey()).getTo(), e -> e.getValue()));
    }

    public Map<String, DTOStream> getSourceMapper() {
        if (this.sourceMapper == null) {
            this.sourceMapper = this.getMapper(true);
        }
        return this.sourceMapper;
    }
}

