/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.aiagent.plan;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.async.message.client.consumer.impl.MQListenerFactory;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.incr.TISSinkFactory;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class DescribableImpl {
    private final Class<? extends Describable> extendPoint;
    private List<String> impls = Lists.newArrayList();
    private Descriptor _descriptor;
    private final Optional<IEndTypeGetter.EndType> endType;
    private static final Set<Class> incrExtendPoints = Sets.newHashSet((Object[])new Class[]{TISSinkFactory.class, MQListenerFactory.class});
    private final boolean incr;

    public DescribableImpl(Class<? extends Describable> extendPoint, Optional<IEndTypeGetter.EndType> endType) {
        this.extendPoint = extendPoint;
        this.endType = endType;
        this.incr = incrExtendPoints.contains(extendPoint);
    }

    public boolean isIncrStreamEndType() {
        return this.incr;
    }

    public Optional<IEndTypeGetter.EndType> getEndType() {
        return this.endType;
    }

    public Class<? extends Describable> getExtendPoint() {
        return this.extendPoint;
    }

    public String getExtendPointClassName() {
        return this.extendPoint.getName();
    }

    public Descriptor getImplDesc() {
        if (CollectionUtils.isEmpty(this.impls)) {
            throw new IllegalStateException("prop impls can not be empty");
        }
        if (this._descriptor == null) {
            for (String impl : this.impls) {
                Descriptor d = TIS.get().getDescriptor(impl);
                if (this.endType.isPresent()) {
                    if (!(d instanceof IEndTypeGetter) || ((IEndTypeGetter)((Object)d)).getEndType() != this.endType.get()) continue;
                    this._descriptor = d;
                    return d;
                }
                this._descriptor = d;
                return d;
            }
        }
        return this._descriptor;
    }

    public DescribableImpl addImpl(String impl) {
        this.impls.add(impl);
        return this;
    }

    public DescribableImpl setDescriptor(Descriptor desc) {
        this._descriptor = Objects.requireNonNull(desc, "desc can not be null");
        this.impls = Collections.singletonList(desc.getId());
        return this;
    }

    public List<String> getImpls() {
        return this.impls;
    }
}

