/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.aiagent.llm;

import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.aiagent.core.IAgentContext;
import com.qlangtech.tis.aiagent.llm.UserPrompt;
import com.qlangtech.tis.config.ParamsConfig;
import com.qlangtech.tis.manage.common.ILoginUser;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.credentials.ParamsConfigPluginStore;
import com.qlangtech.tis.plugin.llm.log.ExecuteLog;
import com.qlangtech.tis.util.HeteroEnum;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.UploadPluginMeta;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public abstract class LLMProvider
extends ParamsConfig {
    protected static final String KEY_DISPLAY_NAME = "LLM";
    @FormField(type=FormFieldType.DURATION_OF_SECOND, advance=true, ordinal=7, validate={Validator.require, Validator.integer})
    public Duration readTimeout;
    @FormField(type=FormFieldType.INT_NUMBER, advance=true, ordinal=8, validate={Validator.require, Validator.integer})
    public Integer maxRetry;

    public static List<ParamsConfig> getExistProviders() {
        IPluginContext context = IPluginContext.getThreadLocalInstance();
        List<ParamsConfig> llmProviders = LLMProvider.loadAllProvidersBindWithUser(context);
        return llmProviders;
    }

    private static List<ParamsConfig> loadAllProvidersBindWithUser(IPluginContext context) {
        UploadPluginMeta pluginMeta = ParamsConfigPluginStore.createParamsConfigUserIsolation(KEY_DISPLAY_NAME);
        List<ParamsConfig> llmProviders = HeteroEnum.PARAMS_CONFIG_USER_ISOLATION.getPlugins(context, pluginMeta);
        return llmProviders;
    }

    public static LLMProvider load(IPluginContext pluginContext, String identityName) {
        if (StringUtils.isEmpty((CharSequence)identityName)) {
            throw new IllegalArgumentException("param identityName can not be null");
        }
        List<ParamsConfig> providers = LLMProvider.loadAllProvidersBindWithUser(pluginContext);
        for (ParamsConfig config : providers) {
            if (!StringUtils.equals((CharSequence)config.identityValue(), (CharSequence)identityName)) continue;
            return (LLMProvider)config;
        }
        throw new IllegalStateException("can not find llmProvider with name:" + identityName);
    }

    public static List<LLMProvider> loadAll(ILoginUser user) {
        return LLMProvider.getItems(KEY_DISPLAY_NAME, Optional.of(user.getName()));
    }

    public abstract LLMResponse chat(IAgentContext var1, UserPrompt var2, List<String> var3);

    public abstract LLMResponse chatJson(IAgentContext var1, UserPrompt var2, List<String> var3, String var4);

    public abstract String getProviderName();

    public abstract boolean isAvailable();

    public static class LLMResponse {
        private String content;
        private JSONObject jsonContent;
        private long promptTokens;
        private long completionTokens;
        private String model;
        private boolean success;
        private String errorMessage;
        public final ExecuteLog executeLog;

        public LLMResponse(ExecuteLog executeLog) {
            this.executeLog = executeLog;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public JSONObject getJsonContent() {
            return this.jsonContent;
        }

        public void setJsonContent(JSONObject jsonContent) {
            this.jsonContent = jsonContent;
        }

        public long getPromptTokens() {
            return this.promptTokens;
        }

        public void setPromptTokens(long promptTokens) {
            this.promptTokens = promptTokens;
        }

        public long getCompletionTokens() {
            return this.completionTokens;
        }

        public void setCompletionTokens(long completionTokens) {
            this.completionTokens = completionTokens;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    public static enum LLMChatPhase {
        Start,
        ERROR,
        Complete;

    }
}

