/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis;

import com.google.common.collect.Lists;
import com.qlangtech.tis.component.GlobalComponent;
import com.qlangtech.tis.config.ParamsConfig;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.impl.DataxReader;
import com.qlangtech.tis.datax.impl.DataxWriter;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.DescriptorExtensionList;
import com.qlangtech.tis.extension.ExtensionComponentSet;
import com.qlangtech.tis.extension.ExtensionFinder;
import com.qlangtech.tis.extension.ExtensionList;
import com.qlangtech.tis.extension.PluginManager;
import com.qlangtech.tis.extension.impl.ClassicPluginStrategy;
import com.qlangtech.tis.extension.impl.ExtensionRefreshException;
import com.qlangtech.tis.extension.impl.XmlFile;
import com.qlangtech.tis.extension.init.InitMilestone;
import com.qlangtech.tis.extension.init.InitReactorRunner;
import com.qlangtech.tis.extension.init.InitStrategy;
import com.qlangtech.tis.extension.model.UpdateCenter;
import com.qlangtech.tis.extension.util.VersionNumber;
import com.qlangtech.tis.install.InstallState;
import com.qlangtech.tis.manage.IAppSource;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.offline.DbScope;
import com.qlangtech.tis.plugin.ComponentMeta;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.IRepositoryResource;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.PluginStore;
import com.qlangtech.tis.plugin.ds.DBIdentity;
import com.qlangtech.tis.plugin.ds.DSKey;
import com.qlangtech.tis.plugin.ds.DataSourceFactory;
import com.qlangtech.tis.plugin.ds.DataSourceFactoryPluginStore;
import com.qlangtech.tis.plugin.ds.PostedDSProp;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.Memoizer;
import com.qlangtech.tis.util.PluginMeta;
import com.qlangtech.tis.util.RobustReflectionConverter2;
import com.qlangtech.tis.util.XStream2PluginInfoReader;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Modifier;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jvnet.hudson.reactor.Reactor;
import org.jvnet.hudson.reactor.ReactorException;
import org.jvnet.hudson.reactor.Task;
import org.jvnet.hudson.reactor.TaskBuilder;
import org.jvnet.hudson.reactor.TaskGraphBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TIS {
    public static final String UNCOMPUTED_VERSION = "?";
    public static String VERSION = "?";
    private static final Logger logger = LoggerFactory.getLogger(TIS.class);
    public static final String KEY_ALT_SYSTEM_PROP_TIS_PLUGIN_ROOT = "plugin_dir_root";
    public static final String KEY_TIE_GLOBAL_COMPONENT_CONFIG_FILE = "global_config.xml";
    private final transient UpdateCenter updateCenter = UpdateCenter.createUpdateCenter(null);
    private transient String installStateName;
    private InstallState installState;
    private static final transient Memoizer<Class<? extends Describable>, IPluginStore> globalPluginStore = new Memoizer<Class<? extends Describable>, IPluginStore>(){

        @Override
        public PluginStore compute(Class<? extends Describable> key) {
            return new PluginStore<Describable>(key, new PluginStore.IPluginProcessCallback[0]);
        }
    };
    public static final transient Memoizer<KeyedPluginStore.Key, KeyedPluginStore> collectionPluginStore = new Memoizer<KeyedPluginStore.Key, KeyedPluginStore>(){

        @Override
        public KeyedPluginStore compute(KeyedPluginStore.Key key) {
            return new KeyedPluginStore(key, new PluginStore.IPluginProcessCallback[0]);
        }
    };
    public static final transient Memoizer<KeyedPluginStore.AppKey, KeyedPluginStore<IAppSource>> appSourcePluginStore = new Memoizer<KeyedPluginStore.AppKey, KeyedPluginStore<IAppSource>>(){

        @Override
        public KeyedPluginStore<IAppSource> compute(KeyedPluginStore.AppKey key) {
            return new KeyedPluginStore<IAppSource>(key, new PluginStore.IPluginProcessCallback<IAppSource>(){

                @Override
                public void afterDeserialize(PluginStore<IAppSource> pluginStore, IAppSource appSource) {
                    appSource.setPluginStore(pluginStore);
                }
            });
        }
    };
    public static final transient Memoizer<DataXReaderAppKey, KeyedPluginStore<DataxReader>> dataXReaderPluginStore = new Memoizer<DataXReaderAppKey, KeyedPluginStore<DataxReader>>(){

        @Override
        public KeyedPluginStore<DataxReader> compute(DataXReaderAppKey key) {
            return new KeyedPluginStore<DataxReader>(key, key.pluginCreateCallback);
        }
    };
    public static final transient Memoizer<KeyedPluginStore.AppKey, KeyedPluginStore<DataxWriter>> dataXWriterPluginStore = new Memoizer<KeyedPluginStore.AppKey, KeyedPluginStore<DataxWriter>>(){

        @Override
        public KeyedPluginStore<DataxWriter> compute(KeyedPluginStore.AppKey key) {
            return new KeyedPluginStore<DataxWriter>(key, new PluginStore.IPluginProcessCallback[0]);
        }
    };
    public static final transient Memoizer<DataxReader.SubFieldFormAppKey<? extends Describable>, KeyedPluginStore<? extends Describable>> dataXReaderSubFormPluginStore = new Memoizer<DataxReader.SubFieldFormAppKey<? extends Describable>, KeyedPluginStore<? extends Describable>>(){

        @Override
        public KeyedPluginStore<? extends Describable> compute(DataxReader.SubFieldFormAppKey<? extends Describable> key) {
            return new KeyedPluginStore(key, new PluginStore.IPluginProcessCallback[0]);
        }
    };
    private static final transient Memoizer<DSKey, DataSourceFactoryPluginStore> databasePluginStore = new Memoizer<DSKey, DataSourceFactoryPluginStore>(){

        @Override
        public DataSourceFactoryPluginStore compute(DSKey key) {
            if (key.isFacadeType()) {
                return new DataSourceFactoryPluginStore((KeyedPluginStore.Key)key, false);
            }
            return new DataSourceFactoryPluginStore((KeyedPluginStore.Key)key, true);
        }
    };
    public static IDataSourceFactoryPluginStoreGetter dsFactoryPluginStoreGetter;
    public final transient Memoizer<Class, ExtensionList> extensionLists = new Memoizer<Class, ExtensionList>(){

        @Override
        public ExtensionList compute(Class key) {
            return ExtensionList.create(TIS.this, key);
        }
    };
    public final transient Memoizer<Class, DescriptorExtensionList> descriptorLists = new Memoizer<Class, DescriptorExtensionList>(){

        @Override
        public DescriptorExtensionList compute(Class key) {
            return DescriptorExtensionList.createDescriptorList(TIS.this, key);
        }
    };
    public final transient PluginManager pluginManager;
    public static final File pluginCfgRoot;
    public static final File pluginDirRoot;
    private static TIS tis;
    public static boolean initialized;
    public static boolean permitInitialize;
    public static Consumer<TIS> afterTISCreate;
    private GlobalComponent globalComponent;

    public static VersionNumber getVersion() {
        return TIS.toVersion(VERSION);
    }

    public UpdateCenter getUpdateCenter() {
        return this.updateCenter;
    }

    private static VersionNumber toVersion(String versionString) {
        if (versionString == null) {
            return null;
        }
        try {
            return new VersionNumber(versionString);
        }
        catch (NumberFormatException e) {
            try {
                int idx = versionString.indexOf(32);
                if (idx > 0) {
                    return new VersionNumber(versionString.substring(0, idx));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void refreshExtensions() throws ExtensionRefreshException {
        List<ExtensionFinder> finders = ClassicPluginStrategy.finders;
        ArrayList<ExtensionComponentSet> fragments = new ArrayList<ExtensionComponentSet>();
        for (ExtensionFinder ef : finders) {
            fragments.add(ef.refresh());
        }
        ExtensionComponentSet delta = ExtensionComponentSet.union(fragments).filtered();
        for (ExtensionList extensionList : this.extensionLists.values()) {
            extensionList.refresh(delta);
        }
        for (ExtensionList extensionList : this.descriptorLists.values()) {
            extensionList.refresh(delta);
        }
    }

    public static <DS extends DataSourceFactory> DS getDataBasePlugin(PostedDSProp dsProp) {
        return TIS.getDataBasePlugin(dsProp, true);
    }

    public static <DS extends DataSourceFactory> DS getDataBasePlugin(PostedDSProp dsProp, boolean validateNull) {
        DataSourceFactoryPluginStore pluginStore = TIS.getDataSourceFactoryPluginStore(dsProp);
        DataSourceFactory ds = pluginStore.getPlugin();
        if (validateNull) {
            Objects.requireNonNull(ds, dsProp.toString() + " relevant plugin can not be null\uff0cstore file:" + pluginStore.getTargetFile().getFile());
        }
        return (DS)ds;
    }

    public static DataSourceFactoryPluginStore getDataSourceFactoryPluginStore(PostedDSProp dsProp) {
        DataSourceFactoryPluginStore pluginStore = null;
        if (dsFactoryPluginStoreGetter != null) {
            pluginStore = dsFactoryPluginStoreGetter.getPluginStore(dsProp);
        } else {
            DSKey key = new DSKey("db", dsProp, DataSourceFactory.class);
            pluginStore = databasePluginStore.get(key);
        }
        return pluginStore;
    }

    public static void deleteDB(String dbName, DbScope dbScope) {
        try {
            DataSourceFactoryPluginStore dsPluginStore = TIS.getDataSourceFactoryPluginStore(new PostedDSProp(DBIdentity.parseId((String)dbName), dbScope));
            dsPluginStore.deleteDB();
            databasePluginStore.clear(dsPluginStore.getDSKey());
        }
        catch (Exception e) {
            throw new RuntimeException(dbName, e);
        }
    }

    public static <T extends Describable> IPluginStore<T> getPluginStore(DataXName dataXName, Class<T> key) {
        return TIS.getPluginStore(dataXName.getType().getType(), dataXName.getPipelineName(), key);
    }

    public static <T extends Describable> IPluginStore<T> getPluginStore(String collection, Class<T> key) {
        return TIS.getPluginStore("ap", collection, key);
    }

    public static <T extends Describable> IPluginStore<T> getPluginStore(String groupName, String collection, Class<T> key) {
        return TIS.getPluginStore(new KeyedPluginStore.Key<T>(groupName, collection, key));
    }

    public static <T extends Describable> IPluginStore<T> getPluginStore(KeyedPluginStore.Key key) {
        IPluginStore pluginStore = collectionPluginStore.get(key);
        if (pluginStore == null) {
            return TIS.getPluginStore(key);
        }
        return pluginStore;
    }

    public static <T extends Describable> IPluginStore<T> getPluginStore(Class<T> key) {
        return globalPluginStore.get(key);
    }

    public static void clean() {
        TIS.clean(true);
    }

    public static void clean(boolean removeTIS) {
        if (tis != null) {
            tis.cleanExtensionCache();
            if (removeTIS) {
                tis = null;
            }
        }
        TIS.cleanPluginStore();
        if (removeTIS) {
            initialized = false;
        }
    }

    public void cleanExtensionCache() {
        this.extensionLists.clear();
        this.descriptorLists.clear();
    }

    public static void cleanPluginStore() {
        globalPluginStore.clear();
        collectionPluginStore.clear();
        databasePluginStore.clear();
        appSourcePluginStore.clear();
        dataXReaderPluginStore.clear();
        dataXWriterPluginStore.clear();
        dataXReaderSubFormPluginStore.clear();
    }

    public static int cleanPluginStore(Class<? extends Describable> descClass) {
        MemoizerStoreProc[] stores = new MemoizerStoreProc[]{new MemoizerStoreProc((Memoizer)globalPluginStore){

            @Override
            protected Class<Describable> getPluginClass(Map.Entry<?, ?> next) {
                return (Class)next.getKey();
            }
        }, new MemoizerStoreProc(collectionPluginStore), new MemoizerStoreProc(databasePluginStore), new MemoizerStoreProc(appSourcePluginStore), new MemoizerStoreProc(dataXReaderPluginStore), new MemoizerStoreProc(dataXWriterPluginStore), new MemoizerStoreProc(dataXReaderSubFormPluginStore)};
        int removeCount = 0;
        for (MemoizerStoreProc store : stores) {
            removeCount += store.clean(descClass);
        }
        return removeCount;
    }

    private TIS() {
        long start = System.currentTimeMillis();
        try {
            this.pluginManager = new PluginManager(pluginDirRoot);
            File initialingToken = new File(pluginDirRoot, "tis_loading");
            FileUtils.touch((File)initialingToken);
            try (RandomAccessFile raf = new RandomAccessFile(initialingToken, "rw");){
                FileChannel channel = raf.getChannel();
                try (FileLock fileLock = channel.lock();){
                    InitStrategy is = InitStrategy.get(Thread.currentThread().getContextClassLoader());
                    this.executeReactor(is, this.pluginManager.initTasks(is, this), this.loadTasks(), InitMilestone.ordering());
                    logger.info("tis plugin have been initialized,consume:{}ms.", (Object)(System.currentTimeMillis() - start));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            initialized = true;
        }
    }

    private synchronized TaskBuilder loadTasks() {
        TaskGraphBuilder g = new TaskGraphBuilder();
        return g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TIS get() {
        if (!permitInitialize || tis != null) return tis;
        Class<TIS> clazz = TIS.class;
        synchronized (TIS.class) {
            if (!permitInitialize || tis != null) return tis;
            tis = new TIS();
            if (afterTISCreate == null) return tis;
            afterTISCreate.accept(tis);
            // ** MonitorExit[var0] (shouldn't be in output)
            return tis;
        }
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public Descriptor getDescriptorOrDir(Class<? extends Describable> type) {
        Descriptor d = this.getDescriptor(type);
        if (d == null) {
            throw new AssertionError((Object)(type + " is missing its descriptor"));
        }
        return d;
    }

    private void executeReactor(final InitStrategy is, TaskBuilder ... builders) throws IOException, InterruptedException, ReactorException {
        Reactor reactor = new Reactor(builders){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runTask(Task task) throws Exception {
                if (is != null && is.skipInitTask(task)) {
                    return;
                }
                String taskName = task.getDisplayName();
                Thread t = Thread.currentThread();
                String name = t.getName();
                if (taskName != null) {
                    t.setName(taskName);
                }
                try {
                    super.runTask(task);
                }
                finally {
                    t.setName(name);
                }
            }
        };
        new InitReactorRunner(){

            @Override
            protected void onInitMilestoneAttained(InitMilestone milestone) {
                if (milestone == InitMilestone.PLUGINS_PREPARED) {
                    // empty if block
                }
            }
        }.run(reactor);
    }

    public Descriptor getDescriptor(String id) {
        ExtensionList<Descriptor> descriptors = this.getExtensionList(Descriptor.class);
        for (Descriptor d : descriptors) {
            if (!d.getId().equals(id)) continue;
            return d;
        }
        Descriptor candidate = null;
        for (Descriptor d : descriptors) {
            String name = d.getId();
            if (!name.substring(name.lastIndexOf(46) + 1).equals(id)) continue;
            if (candidate == null) {
                candidate = d;
                continue;
            }
            throw new IllegalArgumentException(id + " is ambiguous; matches both " + name + " and " + candidate.getId());
        }
        return candidate;
    }

    public Descriptor getDescriptor(Class<? extends Describable> type) {
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new IllegalArgumentException("class can not be abstract:" + type.getName());
        }
        for (Descriptor d : this.getExtensionList(Descriptor.class)) {
            if (d.clazz != type) continue;
            return d;
        }
        return null;
    }

    public <T extends Descriptor> T getDescriptorByType(Class<T> type) {
        for (Descriptor d : this.getExtensionList(Descriptor.class)) {
            if (d.getClass() != type) continue;
            return (T)((Descriptor)type.cast(d));
        }
        return null;
    }

    public <T> ExtensionList<T> getExtensionList(Class<T> extensionType) {
        return this.extensionLists.get(extensionType);
    }

    public <T extends Describable<T>, D extends Descriptor<T>> DescriptorExtensionList<T, D> getDescriptorList(Class<T> type) {
        return this.descriptorLists.get(type);
    }

    public GlobalComponent loadGlobalComponent() {
        if (this.globalComponent == null) {
            try {
                File globalConfig = this.getGlobalConfigFile();
                if (!globalConfig.exists()) {
                    return new GlobalComponent();
                }
                this.globalComponent = (GlobalComponent)new XmlFile(globalConfig).read();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.globalComponent;
    }

    public void saveComponent(GlobalComponent gloablComponent) {
        try {
            File gloabl = this.getGlobalConfigFile();
            new XmlFile(gloabl).write(gloablComponent, Collections.emptySet());
            this.globalComponent = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<PluginMeta> loadIncrComponentUsedPlugin(String collection, List<File> incrPluginConfigSet, boolean clearThreadholder) {
        try {
            ThreadLocal<RobustReflectionConverter2.PluginMetas> threadLocal = RobustReflectionConverter2.usedPluginInfo;
            synchronized (threadLocal) {
                if (clearThreadholder) {
                    RobustReflectionConverter2.usedPluginInfo.remove();
                }
                for (File incrConfig : incrPluginConfigSet) {
                    if (!incrConfig.exists()) {
                        throw new IllegalStateException("file not exist,path:" + incrConfig.getAbsolutePath());
                    }
                    XmlFile xmlFile = new XmlFile(new XStream2PluginInfoReader(XmlFile.DEFAULT_DRIVER), incrConfig);
                    xmlFile.read();
                }
                return RobustReflectionConverter2.usedPluginInfo.get().getMetas();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("collection:" + collection + " relevant configs:" + incrPluginConfigSet.stream().map(f -> f.getAbsolutePath()).collect(Collectors.joining(",")), e);
        }
    }

    public static ComponentMeta getDumpAndIndexBuilderComponent(List<IRepositoryResource> resources) {
        TIS.checkNotInitialized();
        permitInitialize = false;
        resources.add(TIS.getPluginStore(ParamsConfig.class));
        return new ComponentMeta(resources);
    }

    public static ComponentMeta getCoreComponent(List<IRepositoryResource> resources) {
        TIS.checkNotInitialized();
        permitInitialize = false;
        return new ComponentMeta(resources);
    }

    public static ComponentMeta getDumpAndIndexBuilderComponent(IRepositoryResource ... extractRes) {
        ArrayList resources = Lists.newArrayList();
        for (IRepositoryResource r : extractRes) {
            resources.add(r);
        }
        return TIS.getDumpAndIndexBuilderComponent(resources);
    }

    private static void checkNotInitialized() {
        if (initialized) {
            throw new IllegalStateException("TIS plugins has initialized");
        }
    }

    public static ComponentMeta getAssembleComponent() {
        TIS.checkNotInitialized();
        permitInitialize = false;
        ArrayList resources = Lists.newArrayList();
        resources.add(TIS.getPluginStore(ParamsConfig.class));
        return new ComponentMeta(resources);
    }

    private File getGlobalConfigFile() {
        return new File(pluginCfgRoot, "global" + File.separator + KEY_TIE_GLOBAL_COMPONENT_CONFIG_FILE);
    }

    public void setInstallState(InstallState newState) {
        String prior = this.installStateName;
        this.installStateName = newState.name();
        logger.info("Install state transitioning from: {} to : {}", (Object)prior, (Object)this.installStateName);
        if (!this.installStateName.equals(prior)) {
            newState.initializeState();
        }
    }

    public InstallState getInstallState() {
        if (this.installState != null) {
            this.installStateName = this.installState.name();
            this.installState = null;
        }
        InstallState is = this.installStateName != null ? InstallState.valueOf(this.installStateName) : InstallState.UNKNOWN;
        return is != null ? is : InstallState.UNKNOWN;
    }

    static {
        pluginCfgRoot = new File(Config.getMetaCfgDir(), "tis_plugin_config");
        String pluginRootDir = System.getProperty(KEY_ALT_SYSTEM_PROP_TIS_PLUGIN_ROOT);
        pluginDirRoot = StringUtils.isEmpty((String)pluginRootDir) ? new File(Config.getLibDir(), "plugins") : new File(pluginRootDir);
        initialized = false;
        permitInitialize = true;
    }

    static class MemoizerStoreProc {
        final Memoizer<?, ?> store;

        public MemoizerStoreProc(Memoizer<?, ?> store) {
            this.store = store;
        }

        public final int clean(Class<? extends Describable> pluginClass) {
            Set<Map.Entry<?, ?>> entries = this.store.getEntries();
            Iterator<Map.Entry<?, ?>> iterator = entries.iterator();
            int removeCount = 0;
            while (iterator.hasNext()) {
                Class<Describable> key = this.getPluginClass(iterator.next());
                if (pluginClass != key) continue;
                iterator.remove();
                ++removeCount;
            }
            return removeCount;
        }

        protected Class<Describable> getPluginClass(Map.Entry<?, ?> next) {
            KeyedPluginStore.Key key = (KeyedPluginStore.Key)next.getKey();
            return key.pluginClass.getClazz();
        }
    }

    public static interface IDataSourceFactoryPluginStoreGetter {
        public DataSourceFactoryPluginStore getPluginStore(PostedDSProp var1);
    }

    public static class DataXReaderAppKey
    extends KeyedPluginStore.AppKey<DataxReader> {
        public final PluginStore.IPluginProcessCallback<DataxReader> pluginCreateCallback;
        private final String appname;
        private final boolean isDB;

        public DataXReaderAppKey(IPluginContext pluginContext, StoreResourceType resType, String appname, PluginStore.IPluginProcessCallback<DataxReader> pluginCreateCallback) {
            super(pluginContext, resType, appname, DataxReader.class);
            if (pluginCreateCallback == null) {
                throw new IllegalStateException("param pluginCreateCallback can not be null");
            }
            this.pluginCreateCallback = pluginCreateCallback;
            this.appname = appname;
            this.isDB = StoreResourceType.DataBase == resType;
        }

        public DataXReaderAppKey(IPluginContext pluginContext, boolean isDB, String appname, PluginStore.IPluginProcessCallback<DataxReader> pluginCreateCallback) {
            this(pluginContext, StoreResourceType.parse((boolean)isDB), appname, pluginCreateCallback);
        }

        public boolean isSameAppName(String appname, boolean isDB) {
            return this.appname.equals(appname) && this.isDB == isDB;
        }

        public String toString() {
            return this.keyVal.toString() + ", isDB=" + this.isDB;
        }
    }
}

