/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.ConfigFileReader;
import com.qlangtech.tis.manage.common.PropteryGetter;
import com.qlangtech.tis.manage.common.RepositoryException;
import com.qlangtech.tis.manage.common.SnapshotDomain;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConfigFileReader
extends ConfigFileReader {
    private static final Logger logger = LoggerFactory.getLogger(HttpConfigFileReader.class);
    private final File localRepos;
    public static final String unmergeglobalparams = "unmergeglobalparams";
    public static final XStream xstream = new XStream();
    private final Application application;

    public HttpConfigFileReader(SnapshotDomain snapshot, URL appDomainDir, File localRepos, Application application) {
        super(snapshot, appDomainDir);
        this.localRepos = localRepos;
        this.application = application;
    }

    public File getLocalSolrHome() {
        return ConfigFileReader.getAppDomainDir(this.localRepos, this.application.getDptId(), this.application.getAppId());
    }

    @Override
    public String getPath(PropteryGetter pGetter) {
        return this.getSpecificUrl(pGetter).toString();
    }

    @Override
    public byte[] getContent(PropteryGetter getter) {
        URL apply = this.getSpecificUrl(getter);
        return (byte[])ConfigFileContext.processContent((URL)apply, (ConfigFileContext.StreamProcess)new ConfigFileContext.StreamProcess<byte[]>(){

            public byte[] p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                try {
                    return IOUtils.toByteArray((InputStream)stream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private URL getSpecificUrl(PropteryGetter getter) {
        try {
            URL apply = new URL(this.getAppDomainDir(), "/download/bypid/" + this.getSnapshot().getSnapshot().getSnId() + "/snid/" + this.getSnapshot().getSnapshot().getSnId() + "/" + getter.getFileName());
            return apply;
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public File getNewFile(PropteryGetter pGetter, Long fileSufix) {
        if (fileSufix == null) {
            throw new IllegalArgumentException("fileSufix can not be null");
        }
        File localFile = this.getNewFile(ConfigFileReader.getAppDomainDir(this.localRepos, this.application.getDptId(), this.application.getAppId()).toURI(), pGetter, fileSufix);
        if (localFile.exists()) {
            return localFile;
        }
        byte[] content = this.getContent(pGetter);
        try {
            FileUtils.writeByteArrayToFile((File)localFile, (byte[])content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return localFile;
    }

    public static SnapshotDomain getResource(String appName, RunEnvironment runtime, PropteryGetter ... fileGetter) throws RepositoryException {
        return HttpConfigFileReader.getResource(appName, -1L, runtime, false, fileGetter);
    }

    public static SnapshotDomain getResource(String appName, long targetSnapshotid, RunEnvironment runtime, PropteryGetter ... fileGetter) throws RepositoryException {
        return HttpConfigFileReader.getResource(appName, targetSnapshotid, runtime, false, fileGetter);
    }

    public static SnapshotDomain getResource(String appName, long targetSnapshotid, RunEnvironment runtime, boolean unmergeglobalparams, PropteryGetter ... fileGetter) throws RepositoryException {
        return HttpConfigFileReader.getResource(appName, targetSnapshotid, runtime, unmergeglobalparams, true, fileGetter);
    }

    public static SnapshotDomain getResource(String appName, long targetSnapshotid, RunEnvironment runtime, boolean unmergeglobalparams, boolean reThrowNewException, PropteryGetter ... fileGetter) throws RepositoryException {
        String tisUrl = Config.getConfigRepositoryHost();
        if (StringUtils.isEmpty((String)tisUrl)) {
            throw new IllegalArgumentException("parameter terminatorUrl can not be null");
        }
        if (StringUtils.isEmpty((String)appName)) {
            throw new IllegalArgumentException("parameter appName can not be null");
        }
        if (fileGetter == null || fileGetter.length < 1) {
            throw new IllegalArgumentException("parameter fileGetter can not be null or length < 1");
        }
        if (runtime == null) {
            throw new IllegalArgumentException("parameter runtime can not be null or length < 1");
        }
        try {
            StringBuffer url = new StringBuffer(tisUrl + "/download/appconfig/" + appName);
            url.append("/").append(0);
            url.append("/").append(runtime.getKeyName());
            for (int i = 0; i < fileGetter.length; ++i) {
                url.append("/").append(fileGetter[i].getFileName());
            }
            url.append("?snapshotid=").append(targetSnapshotid);
            if (unmergeglobalparams) {
                url.append("&").append(unmergeglobalparams).append("=true");
            }
            URL requestUrl = new URL(url.toString());
            return (SnapshotDomain)ConfigFileContext.processContent((URL)requestUrl, (ConfigFileContext.StreamProcess)new ConfigFileContext.StreamProcess<SnapshotDomain>(){

                public SnapshotDomain p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                    return (SnapshotDomain)xstream.fromXML(stream);
                }
            });
        }
        catch (Throwable e) {
            if (reThrowNewException) {
                throw new RepositoryException("config resource is not exist,appname:" + appName + " groupIndex:0 runtime:" + runtime, e);
            }
            logger.warn("can not find resource:" + ExceptionUtils.getMessage((Throwable)e));
            return null;
        }
    }

    public static SnapshotDomain getResource(String terminatorUrl, Integer snid) throws RepositoryException {
        try {
            StringBuffer url = new StringBuffer(terminatorUrl + "/download/appconfigbysnid/" + snid);
            URL requestUrl = new URL(url.toString());
            return (SnapshotDomain)ConfigFileContext.processContent((URL)requestUrl, (ConfigFileContext.StreamProcess)new ConfigFileContext.StreamProcess<SnapshotDomain>(){

                public SnapshotDomain p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                    return (SnapshotDomain)xstream.fromXML(stream);
                }
            });
        }
        catch (Throwable e) {
            throw new RepositoryException("config resource is not exist,snid:" + snid, e);
        }
    }

    public static void main(String[] arg) throws Exception {
    }

    static {
        xstream.alias("sdomain", SnapshotDomain.class);
    }
}

