/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.qlangtech.tis.exec.IIndexMetaData;
import com.qlangtech.tis.manage.biz.dal.pojo.Snapshot;
import com.qlangtech.tis.manage.biz.dal.pojo.UploadResource;
import com.qlangtech.tis.manage.common.ConfigFileValidateResult;
import com.qlangtech.tis.manage.common.PropteryGetter;
import com.qlangtech.tis.manage.common.SnapshotDomain;
import com.qlangtech.tis.solrdao.IFieldTypeFactory;
import com.qlangtech.tis.solrdao.ISchemaFieldTypeContext;
import com.qlangtech.tis.solrdao.ISchemaPluginContext;
import com.qlangtech.tis.solrdao.SolrFieldsParser;
import com.qlangtech.tis.solrdao.impl.ParseResult;
import com.qlangtech.tis.utils.MD5Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class ConfigFileReader {
    private final SnapshotDomain snapshot;
    private final URL appDomainDir;
    public static final BasicPropteryGetter FILE_SCHEMA = new SchemaFile();
    public static final PropteryGetter FILE_SOLR = new BasicPropteryGetter(){

        public String getFileName() {
            return "solrconfig.xml";
        }

        @Override
        public Snapshot setSolrCoreResourceId(long newUploadResourceId, Snapshot colon) {
            colon.setResSolrId(Long.valueOf(newUploadResourceId));
            return colon;
        }

        public UploadResource getUploadResource(SnapshotDomain snapshotDomain) {
            return snapshotDomain.getSolrConfig();
        }
    };
    public static final PropteryGetter[] getAry = new PropteryGetter[]{FILE_SCHEMA, FILE_SOLR};

    public static void main(String[] arg) throws Exception {
    }

    protected URL getAppDomainDir() {
        return this.appDomainDir;
    }

    public SnapshotDomain getSnapshot() {
        return this.snapshot;
    }

    public ConfigFileReader(SnapshotDomain snapshot, File appDomainDir) {
        this(snapshot, ConfigFileReader.convert2URL(appDomainDir));
    }

    public ConfigFileReader(SnapshotDomain snapshot, URL appDomainDir) {
        if (snapshot == null) {
            throw new IllegalArgumentException("snapshot can not be null");
        }
        if (appDomainDir == null) {
            throw new IllegalArgumentException("appDomainDir can not be null");
        }
        this.snapshot = snapshot;
        this.appDomainDir = appDomainDir;
    }

    public InputStream read(PropteryGetter pGetter) throws Exception {
        byte[] content = this.getContent(pGetter);
        if (!StringUtils.equalsIgnoreCase((String)MD5Utils.md5file((byte[])content), (String)pGetter.getMd5CodeValue(this.snapshot))) {
            throw new IllegalArgumentException("path\uff1a" + this.getPath(pGetter) + "has been modify");
        }
        return new ByteArrayInputStream(content);
    }

    public String getPath(PropteryGetter pGetter) {
        return this.getFile(pGetter).getAbsolutePath();
    }

    public byte[] getContent(PropteryGetter getter) {
        InputStream reader = null;
        try {
            reader = new FileInputStream(this.getFile(getter));
            byte[] byArray = IOUtils.toByteArray((InputStream)reader);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public final File getFile(PropteryGetter pGetter) {
        return this.getNewFile(pGetter, pGetter.getFileSufix(this.snapshot));
    }

    public File getNewFile(PropteryGetter pGetter, Long fileSufix) {
        try {
            return this.getNewFile(this.getAppDomainDir().toURI(), pGetter, fileSufix);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected File getNewFile(URI appDomainDir, PropteryGetter pGetter, Long fileSufix) {
        if (pGetter == null) {
            throw new IllegalArgumentException("pGetter can not be null");
        }
        File dir = new File(appDomainDir);
        return new File(dir, pGetter.getFileName() + (fileSufix == null ? "" : String.valueOf(fileSufix)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveFile(InputStream reader, PropteryGetter getter, Long fileSufix) throws IOException {
        FileOutputStream writer = null;
        File saveFile = this.getNewFile(getter, fileSufix);
        try {
            writer = new FileOutputStream(saveFile);
            IOUtils.copy((InputStream)reader, (OutputStream)writer);
        }
        finally {
            try {
                ((OutputStream)writer).close();
            }
            catch (Throwable throwable) {}
            try {
                reader.close();
            }
            catch (Throwable throwable) {}
        }
        return MD5Utils.md5file((File)saveFile);
    }

    public static File getAppDomainDir(File localRepository, Integer bizid, Integer appid) {
        Objects.requireNonNull(bizid, "bizid can not be null");
        Objects.requireNonNull(appid, "appid can not be null");
        File saveDir = new File(localRepository, String.valueOf(bizid) + File.separatorChar + appid);
        if (!saveDir.exists() && !saveDir.mkdirs()) {
            throw new IllegalStateException("dir:" + saveDir.getAbsolutePath() + " can not be create");
        }
        return saveDir;
    }

    private static URL convert2URL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorContent(Throwable e) {
        String string;
        StringWriter reader = new StringWriter();
        PrintWriter errprint = null;
        try {
            errprint = new PrintWriter(reader);
            e.printStackTrace(errprint);
            string = StringUtils.trimToEmpty((String)reader.toString()).replaceAll("(\r|\n|\t)+", "<br/>");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(errprint);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)errprint);
        return string;
    }

    public static PropteryGetter createPropertyGetter(String resName) {
        for (PropteryGetter geter : getAry) {
            if (!StringUtils.equals((String)geter.getFileName(), (String)resName)) continue;
            return geter;
        }
        throw new IllegalStateException("res name:" + resName + " is illegal");
    }

    public static List<PropteryGetter> getConfigList() {
        return Arrays.asList(getAry);
    }

    public static abstract class BasicPropteryGetter
    implements PropteryGetter {
        public Long getFileSufix(SnapshotDomain snapshot) {
            return (long)snapshot.getSnapshot().getSnId();
        }

        public ConfigFileValidateResult validate(ISchemaPluginContext schemaFieldTypeContext, UploadResource domain) {
            return this.validate(schemaFieldTypeContext, domain.getContent());
        }

        public ConfigFileValidateResult validate(ISchemaPluginContext schemaFieldTypeContext, byte[] resource) {
            return new ConfigFileValidateResult();
        }

        public final String getMd5CodeValue(SnapshotDomain snapshot) {
            UploadResource resource = this.getUploadResource(snapshot);
            if (resource == null) {
                return "";
            }
            return resource.getMd5Code();
        }

        public final byte[] getContent(SnapshotDomain snapshot) {
            UploadResource resource = this.getUploadResource(snapshot);
            if (resource == null) {
                return null;
            }
            byte[] content = resource.getContent();
            if (content == null) {
                return null;
            }
            if (!StringUtils.equalsIgnoreCase((String)MD5Utils.md5file((byte[])content), (String)this.getMd5CodeValue(snapshot))) {
                throw new IllegalArgumentException("snapshot\uff1a" + snapshot.getSnapshot().getSnId() + " file:" + this.getFileName() + "has been modify");
            }
            return content;
        }

        public final Snapshot createNewSnapshot(Integer newUploadResourceId, Snapshot snapshot) {
            Snapshot colon = new Snapshot();
            if (snapshot != null) {
                colon.setMemo(snapshot.getMemo());
                colon.setSnId(snapshot.getSnId());
                colon.setAppId(snapshot.getAppId());
                colon.setCreateTime(new Date());
                colon.setCreateUserId(snapshot.getCreateUserId());
                colon.setCreateUserName(snapshot.getCreateUserName());
                colon.setPreSnId(snapshot.getSnId());
                colon.setResApplicationId(snapshot.getResApplicationId());
                colon.setResCorePropId(snapshot.getResCorePropId());
                colon.setResDsId(snapshot.getResDsId());
                colon.setResJarId(snapshot.getResJarId());
                Long schemaId = snapshot.getResSchemaId();
                colon.setResSchemaId(schemaId);
                colon.setResSolrId(snapshot.getResSolrId());
            }
            return this.setSolrCoreResourceId(newUploadResourceId.intValue(), colon);
        }

        public abstract Snapshot setSolrCoreResourceId(long var1, Snapshot var3);
    }

    private static class SchemaFile
    extends BasicPropteryGetter {
        private SchemaFile() {
        }

        public String getFileName() {
            return "schema.xml";
        }

        @Override
        public ConfigFileValidateResult validate(ISchemaPluginContext schemaPlugin, UploadResource resource) {
            Objects.requireNonNull(resource, "resource can not be null");
            IFieldTypeFactory ftFactory = null;
            byte[] content = resource.getContent();
            ConfigFileValidateResult result = new ConfigFileValidateResult();
            try {
                IIndexMetaData meta = SolrFieldsParser.parse(() -> content, (ISchemaFieldTypeContext)schemaPlugin, (boolean)true);
                ParseResult parseResult = meta.getSchemaParseResult();
                for (SolrFieldsParser.SolrType ftype : parseResult.getFieldTypes()) {
                    if (!ftype.plugin || (ftFactory = schemaPlugin.findFieldTypeFactory(ftype.getPluginName())) != null) continue;
                    parseResult.errlist.add("fieldType:" + ftype.getSType().getName() + " relevant fieldType plugin has not find plugin in plugin define collection");
                }
                if (!parseResult.isValid()) {
                    result.setValid(false);
                    for (Object error : parseResult.errlist) {
                        result.appendResult(error.toString());
                    }
                }
            }
            catch (Exception e) {
                result.setValid(false);
                result.appendResult(ConfigFileReader.getErrorContent(e));
            }
            return result;
        }

        @Override
        public Snapshot setSolrCoreResourceId(long newUploadResourceId, Snapshot colon) {
            colon.setResSchemaId(Long.valueOf(newUploadResourceId));
            return colon;
        }

        public UploadResource getUploadResource(SnapshotDomain snapshotDomain) {
            return snapshotDomain.getSolrSchema();
        }
    }
}

