/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.git;

import com.google.common.collect.Lists;
import com.qlangtech.tis.common.utils.Assert;
import com.qlangtech.tis.manage.common.CenterResource;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.manage.common.PostFormStreamProcess;
import com.qlangtech.tis.manage.common.Secret;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.offline.DbScope;
import com.qlangtech.tis.offline.pojo.GitCommitVersionDiff;
import com.qlangtech.tis.offline.pojo.GitFileDiff;
import com.qlangtech.tis.offline.pojo.GitRepositoryCommitPojo;
import com.qlangtech.tis.offline.pojo.GitRepositoryTreeNode;
import com.qlangtech.tis.offline.pojo.TISDb;
import com.qlangtech.tis.offline.pojo.WorkflowPojo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitUtils {
    private static final ConfigFileContext.Header PRIVATE_TOKEN = new ConfigFileContext.Header("PRIVATE-TOKEN", "XqxWfcskmh9TskxGpEac");
    private static final ConfigFileContext.Header DELETE_METHOD = new ConfigFileContext.Header("method", "DELETE");
    public static final int WORKFLOW_GIT_PROJECT_ID = 1372;
    public static final int DATASOURCE_PROJECT_ID = 1375;
    public static final String TAB_CONFIG_ROOT_DIR = "table_cfg/";
    public static final String GIT_HOST = "http://git.qlangtech.net";
    private static final String WF_FILE_NAME = "joinRule";
    private static final Logger logger = LoggerFactory.getLogger(GitUtils.class);
    public static final String cryptKey = "32&*^%%$$`!h";
    private static final GitPostStreamProcess<String> gitPostStreamProcess = new GitPostStreamProcess<String>(){

        public PostFormStreamProcess.ContentType getContentType() {
            return PostFormStreamProcess.ContentType.JSON;
        }

        public String p(int status, InputStream stream, Map<String, List<String>> headerFields) {
            try {
                return IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void error(int status, InputStream errstream, IOException e) throws Exception {
            String error = IOUtils.toString((InputStream)errstream, (Charset)StandardCharsets.UTF_8);
            JSONTokener tokener = new JSONTokener(error);
            JSONObject result = new JSONObject(tokener);
            throw new Exception(result.getString("message"), e);
        }
    };
    private final String DB_SUB_DIR = "db";
    public final File dbRootDir = new File(Config.getMetaCfgDir(), "db");
    private final boolean fetchFromCenterRepository;
    private static GitUtils SINGLEN;
    public static final String DB_CONFIG_META_NAME = "db_config";
    public static int ExecuteGetTableConfigCount;

    private GitUtils(boolean fetchFromCenterRepository) {
        this.fetchFromCenterRepository = fetchFromCenterRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GitUtils $() {
        if (SINGLEN != null) return SINGLEN;
        Class<GitUtils> clazz = GitUtils.class;
        synchronized (GitUtils.class) {
            if (SINGLEN != null) return SINGLEN;
            boolean fetchFromCenterRepository = !CenterResource.notFetchFromCenterRepository();
            logger.info("fetchFromCenterRepository:{}", (Object)fetchFromCenterRepository);
            SINGLEN = new GitUtils(fetchFromCenterRepository);
            // ** MonitorExit[var0] (shouldn't be in output)
            return SINGLEN;
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println(Secret.encrypt((String)"order@552208", (String)cryptKey));
    }

    private static void createFile() {
    }

    public void createDatabase(TISDb db, String commitLog) {
        this.processDBConfig(db, commitLog, true, db.isFacade());
    }

    public void updateDatabase(TISDb db, String commitLog) {
        this.processDBConfig(db, commitLog, false, db.isFacade());
    }

    public void processDBConfig(TISDb db, String commitLog, boolean isNew, boolean facade) {
        String path = this.getDBConfigPath(db.getDbName(), db.isFacade() ? DbScope.FACADE : DbScope.DETAILED);
        this.processDBConfig(db, path, commitLog, isNew, facade);
    }

    public void processDBConfig(TISDb db, String path, String commitLog, boolean isNew, boolean facade) {
        if (StringUtils.isEmpty((String)db.getDbName())) {
            throw new IllegalArgumentException("param dbName can not be null");
        }
        this.processFile(path, GitBranchInfo.$(GitBranch.DEVELOP), db.createDBConfigDesc(), commitLog, 1375, isNew ? ConfigFileContext.HTTPMethod.POST : ConfigFileContext.HTTPMethod.PUT);
    }

    public String getDBConfigPath(String dbname, DbScope dbscope) {
        return this.getDBConfigParentPath(dbname) + "/db_config" + dbscope.getDBType();
    }

    private String getDBConfigParentPath(String dbname) {
        return "db/" + dbname;
    }

    public void createDatasourceFileOnline(TISDb db, String commitLog) {
        String dbName = db.getDbName();
        if (StringUtils.isEmpty((String)dbName)) {
            throw new IllegalArgumentException("param dbName can not be null");
        }
        this.createFile(this.getDBConfigPath(dbName, DbScope.DETAILED), GitBranchInfo.$(GitBranch.MASTER), db.createDBConfigDesc(), commitLog, 1375, true);
    }

    public WorkflowPojo getWorkflow(String wfName, GitBranchInfo branch) {
        Assert.assertNotNull((Object)wfName);
        Assert.assertNotNull((Object)branch);
        WorkflowPojo workflow = new WorkflowPojo();
        workflow.setName(wfName);
        FileContent target = this.getFileContent(1372, wfName + "/joinRule", branch);
        if (!target.exist()) {
            throw new IllegalStateException("target file not exist:" + target.getFile());
        }
        workflow.setTask(new JoinRule(target.getContent()));
        return workflow;
    }

    public void updateWorkflowFile(String path, String branch, String content, String commitLog) {
        this.createFile(path, GitBranchInfo.$(branch), content, commitLog, 1372, false);
    }

    public void deleteWorkflow(String name, GitUser user) {
        this.deleteFile(name, GitBranchInfo.$(GitBranch.MASTER), user, "delete workflow " + name, 1372);
    }

    private void deleteFile(String path, GitBranchInfo branch, GitUser user, String commitLog, int projectId) {
    }

    private void createFile(String path, GitBranchInfo branch, String content, String commitLog, int projectId, boolean create) {
        this.processFile(path, branch, content, commitLog, projectId, create ? ConfigFileContext.HTTPMethod.POST : ConfigFileContext.HTTPMethod.PUT);
    }

    private void processFile(String path, GitBranchInfo branch, String content, String commitLog, int projectId, ConfigFileContext.HTTPMethod httpMethod) {
        try {
            File targetFile = new File(this.dbRootDir, path);
            FileUtils.writeStringToFile((File)targetFile, (String)content, (Charset)TisUTF8.get(), (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException("filepath:" + path, e);
        }
    }

    public void updateDatasourceFileOnline(String path, String content, String commitLog) {
        this.createFile(path, GitBranchInfo.$(GitBranch.MASTER), content, commitLog, 1375, false);
    }

    private void deleteTable(String dbName, String tableLogicName, boolean isDaily, GitUser user) {
        String path = "table_cfg//" + dbName + "/" + tableLogicName;
        GitBranchInfo branch = isDaily ? GitBranchInfo.$(GitBranch.DEVELOP) : GitBranchInfo.$(GitBranch.MASTER);
        this.deleteFile(path + "/profile", branch, user, "delete table" + path, 1375);
        this.deleteFile(path + "/sql", branch, user, "delete table" + path, 1375);
    }

    public void deleteTableDaily(String dbName, String tableLogicName, GitUser user) {
        this.deleteTable(dbName, tableLogicName, true, user);
    }

    public void deleteTableOnline(String dbName, String tableLogicName, GitUser user) {
        this.deleteTable(dbName, tableLogicName, false, user);
    }

    public void getProjects() {
        String urlString = "http://git.qlangtech.net/api/v4/projects/owned";
        String result = (String)HttpUtils.processContent((String)urlString, (ConfigFileContext.StreamProcess)new GitStreamProcess<String>(){

            public String p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                try {
                    return IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        System.out.println(result);
    }

    private void getChildren() {
        String urlString = "http://git.qlangtech.net/api/v4/projects/1281/repository/tree?path=server&ref_name=master";
        HttpUtils.processContent((String)"http://git.qlangtech.net/api/v4/projects/1281/repository/tree?path=server&ref_name=master", (ConfigFileContext.StreamProcess)new GitStreamProcess<String>(){

            public String p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                try {
                    return IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private FileContent getFileContent(int projectId, String filePath, GitBranchInfo branch) {
        try {
            File targetFile = new File(this.dbRootDir, filePath);
            FileContent content = new FileContent(targetFile);
            if (this.fetchFromCenterRepository) {
                CenterResource.copyFromRemote2Local((URL)CenterResource.getPathURL((String)"cfg_repo/db", (String)filePath), (File)targetFile, (boolean)true);
            }
            if (!targetFile.exists()) {
                if (this.fetchFromCenterRepository) {
                    throw new IllegalStateException("filePath:" + filePath + " is not exist");
                }
                return content;
            }
            return content.setContent(FileUtils.readFileToString((File)targetFile, (Charset)TisUTF8.get()));
        }
        catch (IOException e) {
            throw new RuntimeException("filepath:" + filePath, e);
        }
    }

    private List<String> listChild(int projectId, String filePath, GitBranchInfo branch) {
        File path = new File(this.dbRootDir, filePath);
        if (this.fetchFromCenterRepository) {
            String relativePath = CenterResource.getPath((String)"db", (String)filePath);
            List subFiles = CenterResource.getSubFiles((String)relativePath, (boolean)false, (boolean)true);
            for (String f : subFiles) {
                CenterResource.copyFromRemote2Local((String)CenterResource.getPath((String)relativePath, (String)f), (boolean)true);
            }
        }
        if (!path.exists()) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])path.list());
    }

    private String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, TisUTF8.getName());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private FileContent getFileContent(int projectId, String filePath, GitBranch branch) {
        return this.getFileContent(projectId, filePath, GitBranchInfo.$(branch));
    }

    public List<String> listDbConfigPath(String dbname) {
        GitBranch branch = GitBranch.MASTER;
        return this.listChild(1375, this.getDBConfigParentPath(dbname), GitBranchInfo.$(branch));
    }

    public boolean containFacadeDbTypeSubpath(String dbname) {
        List<String> child = this.listDbConfigPath(dbname);
        return child.contains(DB_CONFIG_META_NAME + DbScope.FACADE.getDBType());
    }

    public boolean isDbConfigExist(String dbName, DbScope dbScope) {
        return this.getDbConfigFile(dbName, dbScope).exist();
    }

    public FileContent getDbConfigFile(String dbName, DbScope dbScope) {
        if (StringUtils.isEmpty((String)dbName)) {
            throw new IllegalArgumentException("param dbName can not be null");
        }
        GitBranch branch = GitBranch.MASTER;
        if (dbScope == DbScope.FACADE && !this.containFacadeDbTypeSubpath(dbName)) {
            dbScope = DbScope.DETAILED;
        }
        FileContent f = this.getFileContent(1375, this.getDBConfigPath(dbName, dbScope), branch);
        return f;
    }

    private JSONObject getGitJson(int gitProjectId, String gitPath) {
        return this.getGitJson(gitProjectId, gitPath, GitBranchInfo.$(GitBranch.DEVELOP));
    }

    private JSONObject getGitJson(int gitProjectId, String gitPath, GitBranchInfo branch) {
        FileContent target = this.getFileContent(gitProjectId, gitPath, branch);
        if (!target.exist()) {
            throw new IllegalStateException("target file is not exist" + target.getFile());
        }
        try {
            JSONTokener jsonTokener = new JSONTokener(target.getContent());
            return new JSONObject(jsonTokener);
        }
        catch (Exception e) {
            throw new IllegalStateException("projectid:" + gitProjectId + ",gitpath:" + gitPath + ",branch:" + branch.getBranch(), e);
        }
    }

    private String getFileContent(final String urlString) {
        return (String)HttpUtils.processContent((String)urlString, (ConfigFileContext.StreamProcess)new GitStreamProcess<String>(){

            public String p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                JSONTokener tokener = new JSONTokener(stream);
                JSONObject o = new JSONObject(tokener);
                try {
                    return new String(Base64.getDecoder().decode(o.getString("content")), StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    throw new RuntimeException(urlString, e);
                }
            }
        });
    }

    private String getGitUrlContent(String urlString) {
        return (String)HttpUtils.processContent((String)urlString, (ConfigFileContext.StreamProcess)new GitStreamProcess<String>(){

            public String p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                try {
                    return IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public List<GitRepositoryCommitPojo> getGitRepositoryCommits(int projectId) throws ParseException {
        String urlString = "http://git.qlangtech.net/api/v4/projects/" + projectId + "/repository/commits";
        String content = this.getGitUrlContent(urlString);
        LinkedList<GitRepositoryCommitPojo> commits = new LinkedList<GitRepositoryCommitPojo>();
        JSONArray jsonArray = new JSONArray(content);
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            GitRepositoryCommitPojo pojo = new GitRepositoryCommitPojo(jsonObject);
            commits.add(pojo);
        }
        return commits;
    }

    public GitCommitVersionDiff getGitCommitVersionDiff(String fromVersion, String toVersion, int projectId) throws Exception {
        String urlString = String.format("http://git.qlangtech.net/api/v4/projects/%d/repository/compare?&from=%s&to=%s", projectId, fromVersion, toVersion);
        JSONObject jsonObject = new JSONObject(this.getGitUrlContent(urlString));
        GitCommitVersionDiff diff = new GitCommitVersionDiff();
        diff.setCommit(new GitRepositoryCommitPojo(jsonObject.getJSONObject("commit")));
        LinkedList<GitRepositoryCommitPojo> commits = new LinkedList<GitRepositoryCommitPojo>();
        for (Object object : jsonObject.getJSONArray("commits")) {
            commits.add(new GitRepositoryCommitPojo((JSONObject)object));
        }
        diff.setCommits(commits);
        LinkedList<GitFileDiff> diffs = new LinkedList<GitFileDiff>();
        for (Object object : jsonObject.getJSONArray("diffs")) {
            diffs.add(new GitFileDiff((JSONObject)object));
        }
        diff.setDiffs(diffs);
        diff.setCompareTimeout(jsonObject.getBoolean("compare_timeout"));
        diff.setCompareSameRef(jsonObject.getBoolean("compare_same_ref"));
        return diff;
    }

    private void createBranch(int projectId, String branchName, String ref) {
        String urlString = String.format("http://git.qlangtech.net/api/v4/projects/%d/repository/branches", projectId);
        ArrayList<HttpUtils.PostParam> params = new ArrayList<HttpUtils.PostParam>();
        params.add(new HttpUtils.PostParam("branch_name", (Object)branchName));
        params.add(new HttpUtils.PostParam("ref", (Object)ref));
        String result = (String)HttpUtils.post((String)urlString, params, gitPostStreamProcess);
        System.out.println(result);
    }

    public void createWorkflowBarnch(String branchName) {
        this.createBranch(1372, branchName, "master");
    }

    private void deleteBranch(int projectId, String branchName) {
        String urlString = String.format("http://git.qlangtech.net/api/v4/projects/%d/repository/branches/%s", projectId, branchName);
        String result = (String)HttpUtils.delete((String)urlString, null, gitPostStreamProcess);
        System.out.println(result);
    }

    public void deleteWorkflowBranch(String branchName) {
        this.deleteBranch(1372, branchName);
    }

    private JSONObject createMergeRequest(int projectId, String sourceBranch, String targetBranch, String title, String description) {
        String urlString = String.format("http://git.qlangtech.net/api/v4/projects/%d/merge_requests", projectId);
        ArrayList<HttpUtils.PostParam> params = new ArrayList<HttpUtils.PostParam>();
        params.add(new HttpUtils.PostParam("source_branch", (Object)sourceBranch));
        params.add(new HttpUtils.PostParam("target_branch", (Object)targetBranch));
        params.add(new HttpUtils.PostParam("title", (Object)title));
        if (!StringUtils.isBlank((String)description)) {
            params.add(new HttpUtils.PostParam("description", (Object)description));
        }
        String result = (String)HttpUtils.post((String)urlString, params, gitPostStreamProcess);
        return new JSONObject(result);
    }

    private void acceptMergeRequest(int projectId, int mergeRequestId, String mergeCommitMessage) {
        String urlString = String.format("http://git.qlangtech.net/api/v4/projects/%d/merge_request/%d/merge", projectId, mergeRequestId);
        ArrayList<HttpUtils.PostParam> params = new ArrayList<HttpUtils.PostParam>();
        if (!StringUtils.isBlank((String)mergeCommitMessage)) {
            params.add(new HttpUtils.PostParam("merge_commit_message", (Object)mergeCommitMessage));
        }
        String result = (String)HttpUtils.put((String)urlString, params, gitPostStreamProcess);
        System.out.println(result);
    }

    private void closeMergeRequest(int projectId, int mergeRequestId) {
        String urlString = String.format("http://git.qlangtech.net/api/v4/projects/%d/merge_request/%d", projectId, mergeRequestId);
        ArrayList<HttpUtils.PostParam> params = new ArrayList<HttpUtils.PostParam>();
        params.add(new HttpUtils.PostParam("state_event", (Object)"close"));
        String result = (String)HttpUtils.put((String)urlString, params, gitPostStreamProcess);
        System.out.println(result);
    }

    public void mergeWorkflowChange(String branchName) {
        JSONObject result = this.createMergeRequest(1372, branchName, "master", branchName, "merge workflow " + branchName);
        int requestId = result.getInt("id");
        try {
            this.acceptMergeRequest(1372, requestId, "merge workflow " + branchName);
        }
        catch (Exception e) {
            this.closeMergeRequest(1372, requestId);
            throw new RuntimeException(e);
        }
        this.deleteWorkflowBranch(branchName);
        System.out.println(result);
    }

    private JSONArray getRepositoryTreeList(int projectId) {
        String urlString = String.format("http://git.qlangtech.net/api/v4/projects/%d/repository/tree", projectId);
        try {
            return new JSONArray(this.getGitUrlContent(urlString));
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6git\u4ed3\u5e93\u6811\u51fa\u9519", e);
        }
    }

    public List<GitRepositoryTreeNode> getWorkflowRepositoryTreeList() {
        JSONArray jsonArray = this.getRepositoryTreeList(1372);
        LinkedList<GitRepositoryTreeNode> treeNodeList = new LinkedList<GitRepositoryTreeNode>();
        for (Object object : jsonArray) {
            GitRepositoryTreeNode node = new GitRepositoryTreeNode((JSONObject)object);
            treeNodeList.add(node);
        }
        return treeNodeList;
    }

    public String getLatestSha(int projectId) {
        List<GitRepositoryCommitPojo> gitRepositoryCommitPojos = null;
        try {
            gitRepositoryCommitPojos = this.getGitRepositoryCommits(projectId);
        }
        catch (ParseException e) {
            return null;
        }
        if (CollectionUtils.isEmpty(gitRepositoryCommitPojos)) {
            return null;
        }
        return gitRepositoryCommitPojos.get(0).getId();
    }

    private static abstract class GitStreamProcess<T>
    extends ConfigFileContext.StreamProcess<T> {
        private GitStreamProcess() {
        }

        public final List<ConfigFileContext.Header> getHeaders() {
            ArrayList<ConfigFileContext.Header> heads = new ArrayList<ConfigFileContext.Header>();
            heads.add(PRIVATE_TOKEN);
            heads.addAll(super.getHeaders());
            return heads;
        }
    }

    private static abstract class GitPostStreamProcess<T>
    extends PostFormStreamProcess<T> {
        public GitPostStreamProcess() {
            super(Collections.singletonList(PRIVATE_TOKEN));
        }
    }

    public static class FileContent {
        private final File file;
        private String content;

        public FileContent(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public boolean exist() {
            return this.content != null;
        }

        public String getContent() {
            return this.content;
        }

        public FileContent setContent(String content) {
            this.content = content;
            return this;
        }
    }

    public static final class GitUser {
        private final String name;
        private final String email;

        public static GitUser dft() {
            return new GitUser("baisui", "baisui@2dfire.com");
        }

        public GitUser(String name, String email) {
            this.name = name;
            this.email = email;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }
    }

    public static class GitBranchInfo {
        private final String name;
        private final GitBranch staticName;

        public GitBranchInfo(String name, GitBranch staticName) {
            this.name = name;
            this.staticName = staticName;
        }

        public String getBranch() {
            return this.staticName != null ? this.staticName.value : this.name;
        }

        public static GitBranchInfo $(String branchName) {
            if (StringUtils.isEmpty((String)branchName)) {
                throw new IllegalArgumentException("param branch can not be null");
            }
            return new GitBranchInfo(branchName, null);
        }

        public static GitBranchInfo $(GitBranch name) {
            return new GitBranchInfo(null, name);
        }
    }

    public static enum GitBranch {
        MASTER("master"),
        DEVELOP("develop");

        private final String value;

        private GitBranch(String value) {
            this.value = value;
        }
    }

    public static class JoinRule {
        private final String content;

        public JoinRule(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }
    }
}

