/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension;

import com.qlangtech.tis.extension.TISExtensible;
import com.qlangtech.tis.extension.TISExtension;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"sezpoz.quiet"})
public class TISExtendsionInterceptor
extends AbstractProcessor {
    public static final String FILE_EXTENDPOINTS = "extendpoints.txt";
    private static final Pattern PATTERN_EXTEND_POINT = Pattern.compile("([\\w\\.]+?)(<\\S+?>)");

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        if (env.processingOver()) {
            return false;
        }
        HashMap<String, List<String>> extensionPoints = new HashMap<String, List<String>>();
        for (Element element : env.getElementsAnnotatedWith(TISExtension.class)) {
            Element enclose = element.getEnclosingElement();
            if (enclose.getKind() == ElementKind.PACKAGE) {
                this.visitParent(extensionPoints, element, element.asType());
                continue;
            }
            this.visitParent(extensionPoints, enclose, enclose.asType());
        }
        if (extensionPoints.isEmpty()) {
            return false;
        }
        try {
            FileObject out = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/annotations/extendpoints.txt", new Element[0]);
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(out.openOutputStream());){
                objectOutputStream.writeObject(extensionPoints);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private void visitParent(Map<String, List<String>> extensionPoints, Element impl, TypeMirror childtm) {
        if (childtm.getKind() != TypeKind.DECLARED) {
            return;
        }
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeVisitor typeVisitor = null;
        List<? extends TypeMirror> typeMirrors = typeUtils.directSupertypes(childtm);
        List<String> impls = null;
        for (TypeMirror typeMirror : typeMirrors) {
            typeVisitor = new TypeVisitor(childtm);
            typeMirror.accept(typeVisitor, null);
            if (typeVisitor.extendPointMatch) {
                impls = extensionPoints.get(typeVisitor.extendPoint);
                if (impls == null) {
                    impls = new ArrayList<String>();
                    extensionPoints.put(typeVisitor.extendPoint, impls);
                }
                impls.add(String.valueOf(impl));
                return;
            }
            this.visitParent(extensionPoints, impl, typeMirror);
        }
    }

    public static String parseExtendPoint(String rawExtendPoint) {
        Matcher matcher = PATTERN_EXTEND_POINT.matcher(rawExtendPoint);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return rawExtendPoint;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private static class TypeVisitor
    extends SimpleTypeVisitor8<Void, Void> {
        private boolean extendPointMatch;
        String extendPoint;
        final TypeMirror childtm;

        public TypeVisitor(TypeMirror childtm) {
            this.childtm = childtm;
        }

        @Override
        public Void visitDeclared(DeclaredType t, Void aVoid) {
            this.extendPointMatch = t.asElement().getSimpleName().contentEquals("Describable");
            if (!this.extendPointMatch) {
                TISExtensible extensible = t.asElement().getAnnotation(TISExtensible.class);
                boolean bl = this.extendPointMatch = extensible != null;
                if (this.extendPointMatch) {
                    this.extendPoint = TISExtendsionInterceptor.parseExtendPoint(t.toString());
                }
            } else {
                this.extendPoint = TISExtendsionInterceptor.parseExtendPoint(this.childtm.toString());
            }
            if (this.extendPointMatch) {
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    this.extendPoint = TISExtendsionInterceptor.parseExtendPoint(String.valueOf(typeMirror));
                }
            }
            return null;
        }
    }
}

