/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.impl;

import com.alibaba.citrus.turbine.Context;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.compiler.streamcode.IDBTableNamesGetter;
import com.qlangtech.tis.datax.DataXJobSubmitParams;
import com.qlangtech.tis.datax.IDataxWriter;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.exec.ExecuteResult;
import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.exec.ITaskPhaseInfo;
import com.qlangtech.tis.fullbuild.indexbuild.IDumpTable;
import com.qlangtech.tis.fullbuild.indexbuild.RemoteTaskTriggers;
import com.qlangtech.tis.fullbuild.phasestatus.IJoinTaskStatus;
import com.qlangtech.tis.fullbuild.phasestatus.PhaseStatusCollection;
import com.qlangtech.tis.fullbuild.phasestatus.impl.DumpPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.JoinPhaseStatus;
import com.qlangtech.tis.fullbuild.taskflow.AdapterTask;
import com.qlangtech.tis.fullbuild.taskflow.DataflowTask;
import com.qlangtech.tis.fullbuild.taskflow.IFlatTableBuilder;
import com.qlangtech.tis.fullbuild.taskflow.TISReactor;
import com.qlangtech.tis.fullbuild.taskflow.TaskAndMilestone;
import com.qlangtech.tis.manage.IAppSource;
import com.qlangtech.tis.manage.IDataFlowAppSource;
import com.qlangtech.tis.manage.ISolrAppSource;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.DagTaskUtils;
import com.qlangtech.tis.order.center.IJoinTaskContext;
import com.qlangtech.tis.plugin.PluginStore;
import com.qlangtech.tis.plugin.ds.ColumnMetaData;
import com.qlangtech.tis.plugin.ds.IDataSourceFactoryGetter;
import com.qlangtech.tis.powerjob.IDAGSessionSpec;
import com.qlangtech.tis.runtime.module.misc.IMessageHandler;
import com.qlangtech.tis.sql.parser.DAGSessionSpec;
import com.qlangtech.tis.sql.parser.DBNode;
import com.qlangtech.tis.sql.parser.ISqlTask;
import com.qlangtech.tis.sql.parser.SqlTaskNodeMeta;
import com.qlangtech.tis.sql.parser.er.ERRules;
import com.qlangtech.tis.sql.parser.er.IPrimaryTabFinder;
import com.qlangtech.tis.sql.parser.er.PrimaryTableMeta;
import com.qlangtech.tis.sql.parser.er.TabFieldProcessor;
import com.qlangtech.tis.sql.parser.er.TableMeta;
import com.qlangtech.tis.sql.parser.meta.DependencyNode;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.sql.parser.tuple.creator.IDataTupleCreatorVisitor;
import com.qlangtech.tis.sql.parser.tuple.creator.IEntityNameGetter;
import com.qlangtech.tis.sql.parser.tuple.creator.IValChain;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.TableTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.TaskNodeTraversesCreatorVisitor;
import com.qlangtech.tis.workflow.pojo.WorkFlow;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.jvnet.hudson.reactor.Milestone;
import org.jvnet.hudson.reactor.MilestoneImpl;
import org.jvnet.hudson.reactor.ReactorListener;
import org.jvnet.hudson.reactor.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFlowAppSource
implements ISolrAppSource,
IDataFlowAppSource {
    private static final Logger logger = LoggerFactory.getLogger((String)"fullbuild");
    public static final File parent = new File(Config.getPluginCfgDir(), "ap");
    private final String dataflowName;
    private final WorkFlow dataflow;
    private final IFlatTableBuilder flatTableBuilder;
    private final IDataSourceFactoryGetter dsGetter;

    public String identityValue() {
        return this.dataflowName;
    }

    public void setPluginStore(PluginStore<IAppSource> pluginStore) {
    }

    public DataFlowAppSource(WorkFlow dataflow, IDataxWriter writer) {
        this.dataflowName = dataflow.getName();
        this.dataflow = dataflow;
        if (!(writer instanceof IFlatTableBuilder)) {
            throw new IllegalStateException(writer.getClass() + " must be type of " + IFlatTableBuilder.class.getSimpleName());
        }
        if (!(writer instanceof IDataSourceFactoryGetter)) {
            throw new IllegalStateException(writer.getClass() + " must be type of " + IDataSourceFactoryGetter.class.getSimpleName());
        }
        this.flatTableBuilder = (IFlatTableBuilder)writer;
        this.dsGetter = (IDataSourceFactoryGetter)writer;
    }

    public static ExecutorService createExecutorService(final IExecChainContext execChainContext) {
        DataXJobSubmitParams submitParams = DataXJobSubmitParams.getDftIfEmpty();
        int nThreads = submitParams.pipelineParallelism;
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(submitParams.maxJobs), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(() -> {
                    execChainContext.rebindLoggingMDCParams();
                    r.run();
                });
                t.setUncaughtExceptionHandler((thread, ex) -> logger.error("DataX Name:" + execChainContext.getIndexName() + ",taskid:" + execChainContext.getTaskId() + " has been canceled", ex));
                return t;
            }
        });
    }

    public StoreResourceType getResType() {
        return StoreResourceType.DataFlow;
    }

    public Integer getDfId() {
        return this.dataflow.getId();
    }

    public boolean isExcludeFacadeDAOSupport() {
        try {
            SqlTaskNodeMeta.SqlDataFlowTopology wfTopology = SqlTaskNodeMeta.getSqlDataFlowTopology((String)this.dataflowName);
            return wfTopology.isSingleDumpTableDependency();
        }
        catch (Exception e) {
            throw new RuntimeException("dataflow:" + this.dataflowName, e);
        }
    }

    public Map<IEntityNameGetter, List<IValChain>> getTabTriggerLinker() {
        try {
            SqlTaskNodeMeta.SqlDataFlowTopology topology = SqlTaskNodeMeta.getSqlDataFlowTopology((String)this.dataflowName);
            TableTupleCreator finalTableNode = topology.parseFinalSqlTaskNode();
            ERRules erR = this.getErRules();
            TaskNodeTraversesCreatorVisitor visitor = new TaskNodeTraversesCreatorVisitor(erR);
            finalTableNode.accept((IDataTupleCreatorVisitor)visitor);
            Map tabTriggers = visitor.getTabTriggerLinker();
            return tabTriggers;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean containErRules() {
        return this.getOptionalErRules().isPresent();
    }

    private ERRules getErRules() {
        Optional<ERRules> erRules = this.getOptionalErRules();
        if (!erRules.isPresent()) {
            throw new IllegalStateException("topology:" + this.dataflowName + " relevant erRule can not be null");
        }
        return erRules.get();
    }

    private Optional<ERRules> getOptionalErRules() {
        try {
            Optional erRule;
            SqlTaskNodeMeta.SqlDataFlowTopology topology = SqlTaskNodeMeta.getSqlDataFlowTopology((String)this.dataflowName);
            if (topology.isSingleTableModel() && !(erRule = ERRules.getErRule((String)this.dataflowName)).isPresent()) {
                ERRules.createDefaultErRule((SqlTaskNodeMeta.SqlDataFlowTopology)topology);
            }
            return ERRules.getErRule((String)this.dataflowName);
        }
        catch (Exception e) {
            throw new RuntimeException("dataflowName:" + this.dataflowName, e);
        }
    }

    public List<PrimaryTableMeta> getPrimaryTabs() {
        try {
            return this.getErRules().getPrimaryTabs();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ExecuteResult getProcessDataResults(IExecChainContext execChainContext, ISolrAppSource.ISingleTableDumpFactory singleTableDumpFactory, ISolrAppSource.IDataProcessFeedback dataProcessFeedback, ITaskPhaseInfo taskPhaseInfo) throws Exception {
        SqlTaskNodeMeta.SqlDataFlowTopology topology = SqlTaskNodeMeta.getSqlDataFlowTopology((String)this.dataflowName);
        DAGSessionSpec dagSessionSpec = (DAGSessionSpec)topology.getDAGSessionSpec();
        List tables = topology.getDumpNodes();
        StringBuffer dumps = new StringBuffer("dependency table:\n");
        dumps.append("\t\t=======================\n");
        for (DependencyNode t : tables) {
            dumps.append("\t\t").append(t.getDbName()).append(".").append(t.getName()).append("[").append(t.getTabid()).append(",").append("] \n");
        }
        dumps.append("\t\t=======================\n");
        logger.info(dumps.toString());
        DumpPhaseStatus dumpPhaseStatus = (DumpPhaseStatus)taskPhaseInfo.getPhaseStatus(execChainContext, FullbuildPhase.FullDump);
        ExecutorService executorService = DataFlowAppSource.createExecutorService(execChainContext);
        RemoteTaskTriggers trigger = new RemoteTaskTriggers(executorService);
        execChainContext.setTskTriggers(trigger);
        for (DependencyNode dump : topology.getDumpNodes()) {
            singleTableDumpFactory.createSingleTableDump(trigger, dump, false, "tableDump.getPt()", execChainContext.getZkClient(), execChainContext, dumpPhaseStatus, taskPhaseInfo, (IDAGSessionSpec)dagSessionSpec);
        }
        DagTaskUtils.createTasks(execChainContext, taskPhaseInfo, (IDAGSessionSpec)dagSessionSpec, trigger);
        JoinPhaseStatus joinPhaseStatus = (JoinPhaseStatus)taskPhaseInfo.getPhaseStatus(execChainContext, FullbuildPhase.JOIN);
        Supplier<IPrimaryTabFinder> primaryTabFinder = () -> this.containErRules() ? this.getErRules() : new IPrimaryTabFinder(){};
        return this.flatTableBuilder.startTask(context -> {
            DataflowTask process = null;
            for (ISqlTask pnode : topology.getParseNodes()) {
                process = this.flatTableBuilder.createTask(pnode, false, execChainContext, context, (IJoinTaskStatus)joinPhaseStatus.getTaskStatus(pnode.getExportName()), this.dsGetter, primaryTabFinder);
                dagSessionSpec.put(pnode.getId(), new TaskAndMilestone(process));
            }
            ExecuteResult faildResult = this.executeDAG(executorService, execChainContext, topology, dataProcessFeedback, dagSessionSpec.getTaskMap());
            return faildResult;
        });
    }

    private ExecuteResult executeDAG(ExecutorService executorService, final IExecChainContext execChainContext, SqlTaskNodeMeta.SqlDataFlowTopology topology, final ISolrAppSource.IDataProcessFeedback dataProcessFeedback, Map<String, TaskAndMilestone> taskMap) {
        final ExecuteResult[] faildResult = new ExecuteResult[1];
        try {
            TISReactor reactor = new TISReactor(execChainContext, taskMap);
            StringBuffer dagSessionSpec = topology.getDAGSessionSpec().buildSpec();
            logger.info("dagSessionSpec:" + dagSessionSpec);
            ReactorListener listener = new ReactorListener(){

                public void onAttained(Milestone milestone) {
                    MilestoneImpl m = (MilestoneImpl)milestone;
                    String mId = m.toString();
                    if (!StringUtils.startsWith((String)mId, (String)"milestone_")) {
                        AdapterTask.createTaskWorkStatus((IJoinTaskContext)execChainContext).put(mId, true);
                    }
                }

                public synchronized void onTaskCompleted(Task t) {
                    DataFlowAppSource.this.processTaskResult(execChainContext, (TISReactor.TaskImpl)t, dataProcessFeedback, new ITaskResultProcessor(){

                        @Override
                        public void process(DumpPhaseStatus dumpPhase, TISReactor.TaskImpl task) {
                        }

                        @Override
                        public void process(JoinPhaseStatus joinPhase, TISReactor.TaskImpl task) {
                        }
                    });
                }

                public synchronized void onTaskFailed(Task t, Throwable err, boolean fatal) {
                    DataFlowAppSource.this.processTaskResult(execChainContext, (TISReactor.TaskImpl)t, dataProcessFeedback, new ITaskResultProcessor(){

                        @Override
                        public void process(DumpPhaseStatus dumpPhase, TISReactor.TaskImpl task) {
                            dataProcessFeedback.reportDumpTableStatusError(execChainContext, dumpPhase, task);
                        }

                        @Override
                        public void process(JoinPhaseStatus joinPhase, TISReactor.TaskImpl task) {
                            JoinPhaseStatus.JoinTaskStatus stat = joinPhase.getTaskStatus(task.getIdentityName());
                            stat.setWaiting(false);
                            stat.setFaild(true);
                            stat.setComplete(true);
                        }
                    });
                }
            };
            reactor.execute(executorService, reactor.buildSession(dagSessionSpec.toString()), listener, new ReactorListener(){

                public void onTaskCompleted(Task t) {
                }

                public void onTaskFailed(Task t, Throwable err, boolean fatal) {
                    logger.error(t.getDisplayName(), err);
                    faildResult[0] = ExecuteResult.createFaild().setMessage("status.runningStatus.isComplete():" + err.getMessage());
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            executorService.shutdown();
        }
        return faildResult[0];
    }

    private void processTaskResult(IExecChainContext execContext, TISReactor.TaskImpl t, ISolrAppSource.IDataProcessFeedback dataProcessFeedback, ITaskResultProcessor resultProcessor) {
        TISReactor.TaskImpl task = t;
        PhaseStatusCollection pstats = dataProcessFeedback.getPhaseStatusSet(execContext);
        if (pstats != null) {
            switch (task.getPhase()) {
                case FullDump: {
                    pstats.getDumpPhase().isComplete();
                    resultProcessor.process(pstats.getDumpPhase(), task);
                    return;
                }
                case JOIN: {
                    pstats.getJoinPhase().isComplete();
                    resultProcessor.process(pstats.getJoinPhase(), task);
                    return;
                }
            }
            throw new IllegalStateException("taskphase:" + task.getPhase() + " is illegal");
        }
    }

    public Map<DBNode, List<String>> getDependencyTables(IDBTableNamesGetter dbTableNamesGetter) {
        try {
            SqlTaskNodeMeta.SqlDataFlowTopology topology = SqlTaskNodeMeta.getSqlDataFlowTopology((String)this.dataflowName);
            HashMap dbNameMap = Maps.newHashMap();
            List tables = null;
            DBNode dbNode = null;
            for (DependencyNode dependencyNode : topology.getDumpNodes()) {
                dbNode = new DBNode(dependencyNode.getDbName(), Integer.parseInt(dependencyNode.getDbid()));
                dependencyNode.parseEntityName();
                tables = (List)dbNameMap.get(dbNode);
                if (tables == null) {
                    tables = Lists.newArrayList();
                    dbNameMap.put(dbNode, tables);
                }
                tables.add(dependencyNode.getName());
            }
            for (Map.Entry entry : dbNameMap.entrySet()) {
                entry.setValue(dbTableNamesGetter.getTableNames(Integer.valueOf(((DBNode)entry.getKey()).getDbId()), (List)entry.getValue()));
            }
            return dbNameMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IPrimaryTabFinder getPrimaryTabFinder() {
        Optional erRule = ERRules.getErRule((String)this.dataflowName);
        DftTabFinder pTabFinder = null;
        pTabFinder = !erRule.isPresent() ? new DftTabFinder() : (IPrimaryTabFinder)erRule.get();
        return pTabFinder;
    }

    @Override
    public EntityName getTargetEntity() {
        try {
            SqlTaskNodeMeta.SqlDataFlowTopology workflowDetail = SqlTaskNodeMeta.getSqlDataFlowTopology((String)this.dataflowName);
            Objects.requireNonNull(workflowDetail, "workflowDetail can not be null");
            EntityName targetEntity = null;
            if (workflowDetail.isSingleTableModel()) {
                DependencyNode dumpNode = (DependencyNode)workflowDetail.getDumpNodes().get(0);
                targetEntity = dumpNode.parseEntityName();
            } else {
                SqlTaskNodeMeta finalN = workflowDetail.getFinalNode();
                targetEntity = EntityName.parse((String)finalN.getExportName());
            }
            return targetEntity;
        }
        catch (Exception e) {
            throw new RuntimeException(this.dataflowName, e);
        }
    }

    @Override
    public List<ColumnMetaData> reflectCols() {
        try {
            SqlTaskNodeMeta.SqlDataFlowTopology dfTopology = SqlTaskNodeMeta.getSqlDataFlowTopology((String)this.dataflowName);
            return dfTopology.getFinalTaskNodeCols();
        }
        catch (Exception e) {
            throw new RuntimeException("dataflowName:" + this.dataflowName, e);
        }
    }

    @Override
    public boolean triggerFullIndexSwapeValidate(IMessageHandler module, Context context) {
        try {
            SqlTaskNodeMeta.SqlDataFlowTopology topology = SqlTaskNodeMeta.getSqlDataFlowTopology((String)this.dataflowName);
            Objects.requireNonNull(topology, "topology:" + this.dataflowName + " relevant topology can not be be null");
            Optional erRule = ERRules.getErRule((String)this.dataflowName);
            if (!topology.isSingleTableModel()) {
                if (!erRule.isPresent()) {
                    module.addErrorMessage(context, "\u8bf7\u4e3a\u6570\u636e\u6d41:[" + this.dataflowName + "]\u5b9a\u4e49ER Rule");
                    return false;
                }
                ERRules erRules = (ERRules)erRule.get();
                List pTabs = erRules.getPrimaryTabs();
                Optional prTableMeta = pTabs.stream().findFirst();
                if (!TableMeta.hasValidPrimayTableSharedKey(prTableMeta.isPresent() ? Optional.of((TableMeta)prTableMeta.get()) : Optional.empty())) {
                    module.addErrorMessage(context, "\u8bf7\u4e3a\u6570\u636e\u6d41:[" + this.dataflowName + "]\u5b9a\u4e49ERRule \u9009\u62e9\u4e3b\u8868\u5e76\u4e14\u8bbe\u7f6e\u5206\u533a\u952e");
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(this.dataflowName, e);
        }
    }

    static class DftTabFinder
    implements IPrimaryTabFinder {
        DftTabFinder() {
        }

        public Optional<TableMeta> getPrimaryTab(IDumpTable entityName) {
            return Optional.empty();
        }

        public final Map<EntityName, TabFieldProcessor> getTabFieldProcessorMap() {
            return Collections.emptyMap();
        }
    }

    static interface ITaskResultProcessor {
        public void process(DumpPhaseStatus var1, TISReactor.TaskImpl var2);

        public void process(JoinPhaseStatus var1, TISReactor.TaskImpl var2);
    }
}

