/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.google.common.collect.Lists;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.exec.ITaskPhaseInfo;
import com.qlangtech.tis.fullbuild.indexbuild.IRemoteTaskTrigger;
import com.qlangtech.tis.fullbuild.indexbuild.RemoteTaskTriggers;
import com.qlangtech.tis.fullbuild.phasestatus.impl.AbstractChildProcessStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.DumpPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.JoinPhaseStatus;
import com.qlangtech.tis.fullbuild.taskflow.DumpTask;
import com.qlangtech.tis.fullbuild.taskflow.JoinTask;
import com.qlangtech.tis.fullbuild.taskflow.TaskAndMilestone;
import com.qlangtech.tis.powerjob.IDAGSessionSpec;
import com.qlangtech.tis.sql.parser.DAGSessionSpec;
import java.util.ArrayList;
import java.util.List;

public class DagTaskUtils {
    public static List<IRemoteTaskTrigger> createTasks(IExecChainContext execChainContext, ITaskPhaseInfo phaseStatus, IDAGSessionSpec dagSessionSpec, RemoteTaskTriggers tskTriggers) {
        ArrayList triggers = Lists.newArrayList();
        for (IRemoteTaskTrigger trigger : tskTriggers.getDumpPhaseTasks()) {
            triggers.add(DagTaskUtils.addDumpTask(execChainContext, phaseStatus, (DAGSessionSpec)dagSessionSpec, trigger));
        }
        for (IRemoteTaskTrigger trigger : tskTriggers.getJoinPhaseTasks()) {
            triggers.add(DagTaskUtils.addJoinTask(execChainContext, phaseStatus, (DAGSessionSpec)dagSessionSpec, trigger));
        }
        return triggers;
    }

    private static IRemoteTaskTrigger addDumpTask(IExecChainContext execChainContext, ITaskPhaseInfo phaseStatus, DAGSessionSpec dagSessionSpec, IRemoteTaskTrigger jobTrigger) {
        DumpPhaseStatus dumpStatus = (DumpPhaseStatus)phaseStatus.getPhaseStatus(execChainContext, FullbuildPhase.FullDump);
        dagSessionSpec.put(jobTrigger.getTaskName(), new TaskAndMilestone(DumpTask.createDumpTask((IRemoteTaskTrigger)jobTrigger, (AbstractChildProcessStatus)dumpStatus.getTable(jobTrigger.getTaskName()))));
        return jobTrigger;
    }

    private static IRemoteTaskTrigger addJoinTask(IExecChainContext execChainContext, ITaskPhaseInfo phaseStatus, DAGSessionSpec dagSessionSpec, IRemoteTaskTrigger postTaskTrigger) {
        JoinPhaseStatus joinStatus = (JoinPhaseStatus)phaseStatus.getPhaseStatus(execChainContext, FullbuildPhase.JOIN);
        JoinPhaseStatus.JoinTaskStatus taskStatus = joinStatus.getTaskStatus(postTaskTrigger.getTaskName());
        taskStatus.setWaiting(true);
        dagSessionSpec.put(postTaskTrigger.getTaskName(), new TaskAndMilestone(JoinTask.createJoinTask((IRemoteTaskTrigger)postTaskTrigger, (JoinPhaseStatus.JoinTaskStatus)taskStatus)));
        return postTaskTrigger;
    }
}

