/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.taskflow;

import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.fullbuild.taskflow.DataflowTask;
import com.qlangtech.tis.fullbuild.taskflow.TaskAndMilestone;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jvnet.hudson.reactor.Milestone;
import org.jvnet.hudson.reactor.Reactor;
import org.jvnet.hudson.reactor.ReactorListener;
import org.jvnet.hudson.reactor.Task;
import org.jvnet.hudson.reactor.TaskBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TISReactor {
    private static final Logger logger = LoggerFactory.getLogger(TISReactor.class);
    private final Map<String, TaskAndMilestone> taskMap;
    private final IExecChainContext execContext;
    Pattern PatternNode = Pattern.compile("[\\S]+");

    public TISReactor(IExecChainContext execContext, Map<String, TaskAndMilestone> taskMap) {
        this.taskMap = taskMap;
        this.execContext = execContext;
    }

    public void execute(Executor executor, Reactor s, ReactorListener ... addedListeners) throws Exception {
        this.execContext.rebindLoggingMDCParams();
        ReactorListener.Aggregator listener = null;
        if (addedListeners.length <= 0) {
            throw new IllegalStateException("param addedListeners length can not small than 1");
        }
        List listeners = Arrays.stream(addedListeners).collect(Collectors.toList());
        listener = new ReactorListener.Aggregator(listeners);
        try {
            s.execute(executor, (ReactorListener)listener);
        }
        catch (InterruptedException e) {
            logger.warn("task:" + this.execContext.getTaskId() + " has been cancel", (Throwable)e);
        }
    }

    public Reactor buildSession(CharSequence spec) throws Exception {
        ArrayList<TaskImpl> tasks = new ArrayList<TaskImpl>();
        Matcher matcher = this.PatternNode.matcher(spec);
        while (matcher.find()) {
            tasks.add(new TaskImpl(matcher.group(), this.taskMap));
        }
        return new Reactor(new TaskBuilder[]{TaskBuilder.fromTasks(tasks)});
    }

    public static class TaskImpl
    implements Task {
        final Collection<Milestone> requires;
        final Collection<Milestone> attains;
        final Map<String, TaskAndMilestone> taskMap;
        private final DataflowTask work;
        private final String id;

        TaskImpl(String idd, Map<String, TaskAndMilestone> taskMap) {
            String[] tokens = idd.split("->");
            this.id = Objects.requireNonNull(tokens[1], "relevant task id is null in taskMap,param idd:" + idd);
            this.work = Objects.requireNonNull(taskMap.get((Object)this.id), (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"nodeId:\u0001 can not find Task in \u0001"}, (String)this.id, (String)String.join((CharSequence)",", taskMap.keySet())))).task;
            this.taskMap = taskMap;
            this.requires = this.adapt(tokens[0].length() == 0 ? Collections.emptyList() : Arrays.asList(tokens[0].split(",")));
            this.attains = this.adapt(tokens.length < 3 ? Arrays.asList(this.id) : Arrays.asList(tokens[2].split(",")));
        }

        public FullbuildPhase getPhase() {
            return this.work.phase();
        }

        public String getIdentityName() {
            return this.work.getIdentityName();
        }

        private Collection<Milestone> adapt(List<String> strings) {
            ArrayList<Milestone> r = new ArrayList<Milestone>();
            TaskAndMilestone w = null;
            for (String s : strings) {
                w = this.taskMap.get(s);
                if (w == null) {
                    throw new IllegalStateException("relevant task:" + s + " is null in taskMap");
                }
                r.add((Milestone)w.milestone);
            }
            return r;
        }

        public Collection<Milestone> requires() {
            return this.requires;
        }

        public Collection<Milestone> attains() {
            return this.attains;
        }

        public String getDisplayName() {
            return this.work.getIdentityName();
        }

        public void run(Reactor reactor) throws Exception {
            this.work.run();
        }

        public boolean failureIsFatal() {
            return false;
        }
    }
}

