/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.visitor;

import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.TISStackableAstVisitor;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.google.common.base.Joiner;
import com.qlangtech.tis.sql.parser.IDumpNodeMapContext;
import com.qlangtech.tis.sql.parser.NodeProcessResult;
import com.qlangtech.tis.sql.parser.TisGroupBy;
import com.qlangtech.tis.sql.parser.tuple.creator.IDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.ColRef;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.FunctionDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.TabCriteriaEntityRecognizeVisitor;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.TableTupleCreator;
import com.qlangtech.tis.sql.parser.utils.NodeUtils;
import com.qlangtech.tis.sql.parser.visitor.StreamTransformVisitor;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class TableReferenceVisitor
extends DefaultTraversalVisitor<NodeProcessResult<?>, TISStackableAstVisitor.StackableAstVisitorContext<Integer>> {
    private final ColRef colRef;
    private final IDumpNodeMapContext dumpNodsContext;

    public TableReferenceVisitor(ColRef colRef, IDumpNodeMapContext dumpNodsContext) {
        this.colRef = colRef;
        this.dumpNodsContext = dumpNodsContext;
    }

    protected NodeProcessResult<?> visitJoin(Join node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        Join.Type type = node.getType();
        Relation left = node.getLeft();
        this.processLeftOrRightRelation(context, left, null, null);
        Relation right = node.getRight();
        Optional<JoinOn> joinOn = node.getCriteria().filter(criteria -> criteria instanceof JoinOn).map(criteria -> (JoinOn)criteria);
        this.processLeftOrRightRelation(context, right, joinOn, type);
        return null;
    }

    protected NodeProcessResult<?> visitAliasedRelation(AliasedRelation node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        String alias = node.getAlias().getValue();
        IDataTupleCreator tupleCreator = this.getDataTupleCreatorByRef(alias);
        if (node.getRelation() instanceof Table) {
            this.processTableReferenceRecoginize(null, null, (Table)node.getRelation(), tupleCreator, alias);
        } else if (node.getRelation() instanceof TableSubquery) {
            this.processSubQuery(null, null, node.getAlias(), tupleCreator, alias, (TableSubquery)node.getRelation());
        } else {
            NodeUtils.faild((Node)node);
        }
        return null;
    }

    private IDataTupleCreator getDataTupleCreatorByRef(String alias) {
        IDataTupleCreator tupleCreator = this.colRef.getTupleCreator(alias);
        if (tupleCreator == null) {
            throw new IllegalStateException("alias:" + alias + ",in[" + Joiner.on((String)",").join(this.colRef.getBaseRefKeys()) + "] relevant tupleCreator shall not be null");
        }
        return tupleCreator;
    }

    private void processLeftOrRightRelation(TISStackableAstVisitor.StackableAstVisitorContext<Integer> context, Relation rel, Optional<JoinOn> joinOn, Join.Type jointype) {
        AliasedRelation aliasRel = null;
        Identifier a = null;
        IDataTupleCreator tupleCreator = null;
        if (rel instanceof Table) {
            Table tab = (Table)rel;
            tupleCreator = this.getDataTupleCreatorByRef(String.valueOf(tab.getName()));
            this.processTableReferenceRecoginize(joinOn, jointype, tab, tupleCreator, String.valueOf(tab.getName()));
        } else if (rel instanceof AliasedRelation) {
            aliasRel = (AliasedRelation)rel;
            a = aliasRel.getAlias();
            tupleCreator = this.getDataTupleCreatorByRef(aliasRel.getAlias().getValue());
            if (joinOn != null && !joinOn.isPresent()) {
                StreamTransformVisitor.faild((Node)rel);
            }
            if (aliasRel.getRelation() instanceof Table) {
                this.processTableReferenceRecoginize(joinOn, jointype, (Table)aliasRel.getRelation(), tupleCreator, a.getValue());
            } else if (aliasRel.getRelation() instanceof TableSubquery) {
                TableSubquery subQuery = (TableSubquery)aliasRel.getRelation();
                this.processSubQuery(joinOn, jointype, a, tupleCreator, a.getValue(), subQuery);
            } else {
                NodeUtils.faild((Node)aliasRel.getRelation());
            }
        } else {
            this.process((Node)rel, context);
        }
    }

    private void processSubQuery(Optional<JoinOn> joinOn, Join.Type jointype, Identifier a, IDataTupleCreator tupleCreator, String tabRefName, TableSubquery subQuery) {
        String tabName = "innertab_" + a.getValue();
        TabCriteriaEntityRecognizeVisitor tabCriteriaEntityRecognizeVisitor = new TabCriteriaEntityRecognizeVisitor(new TabCriteria(tabName, joinOn == null ? null : joinOn.get(), joinOn == null, jointype), this.dumpNodsContext);
        tabCriteriaEntityRecognizeVisitor.setSubQuery(subQuery);
        tupleCreator.accept(tabCriteriaEntityRecognizeVisitor);
        this.setFuncGroupByTuple(tupleCreator, tabRefName);
    }

    private void processTableReferenceRecoginize(Optional<JoinOn> joinOn, Join.Type jointype, Table table, IDataTupleCreator tupleCreator, String tabRefName) {
        String tabName = String.valueOf(table.getName());
        TabCriteriaEntityRecognizeVisitor tabCriteriaEntityRecognizeVisitor = new TabCriteriaEntityRecognizeVisitor(new TabCriteria(tabName, joinOn == null ? null : joinOn.get(), joinOn == null, jointype), this.dumpNodsContext);
        tupleCreator.accept(tabCriteriaEntityRecognizeVisitor);
        this.setFuncGroupByTuple(tupleCreator, tabRefName);
    }

    private void setFuncGroupByTuple(IDataTupleCreator tupleCreator, String tabRefName) {
        Stream<FunctionDataTupleCreator> funcs = this.colRef.getColRefMap().values().stream().filter(r -> r instanceof FunctionDataTupleCreator).map(r -> (FunctionDataTupleCreator)r);
        funcs.forEach(f -> {
            Optional<TisGroupBy> g = f.getGroupBy();
            if (g.isPresent()) {
                g.get().getGroups().forEach(group -> {
                    TableTupleCreator tabTuple = null;
                    if (!group.isTupleSetted() && StringUtils.equals((String)group.getTabRef(), (String)tabRefName)) {
                        if (!(tupleCreator instanceof TableTupleCreator)) {
                            throw new IllegalStateException("tupleCreator type shall be TableTupleCterator");
                        }
                        tabTuple = (TableTupleCreator)tupleCreator;
                        if (!tabRefName.equals(tabTuple.getMediaTabRef())) {
                            throw new IllegalStateException("tabRefName:" + tabRefName + ",tabTuple.getMediaTabRef:" + tabTuple.getMediaTabRef() + " shall be equal");
                        }
                        group.setTabTuple(tabTuple);
                    }
                });
            }
        });
    }

    public static class TabCriteria {
        private final String name;
        private final JoinOn joinOn;
        private boolean primary;
        private Join.Type jointype;

        public TabCriteria(String name, JoinOn joinOn, boolean primary, Join.Type jointype) {
            this.name = name;
            this.joinOn = joinOn;
            this.primary = primary;
            this.jointype = jointype;
        }

        public Join.Type getJointype() {
            return this.jointype;
        }

        public void setJointype(Join.Type jointype) {
            this.jointype = jointype;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public void setPrimary(boolean primary) {
            this.primary = primary;
        }

        public String getName() {
            return this.name;
        }

        public JoinOn getJoinOn() {
            return this.joinOn;
        }
    }
}

