/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.visitor;

import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NaturalJoin;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SimpleGroupBy;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.TISStackableAstVisitor;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.WhenClause;
import com.google.common.collect.ImmutableSet;
import com.qlangtech.tis.sql.parser.ColName;
import com.qlangtech.tis.sql.parser.IDumpNodeMapContext;
import com.qlangtech.tis.sql.parser.NodeProcessResult;
import com.qlangtech.tis.sql.parser.TisGroupBy;
import com.qlangtech.tis.sql.parser.tuple.creator.IDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.ColRef;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.FunctionDataTupleCreator;
import com.qlangtech.tis.sql.parser.utils.NodeUtils;
import com.qlangtech.tis.sql.parser.visitor.TableReferenceVisitor;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class StreamTransformVisitor
extends TISStackableAstVisitor<NodeProcessResult<?>, Integer> {
    private ColRef colsRef;
    private final IDumpNodeMapContext dumpNodesContext;
    public static final String DEFAULT_SINGLE_TABLE = "default_single_table";

    public StreamTransformVisitor(IDumpNodeMapContext dumpNodesContext) {
        this.dumpNodesContext = dumpNodesContext;
    }

    public ColRef getColsRef() {
        if (this.colsRef == null) {
            throw new NullPointerException("colsRef can not be null");
        }
        return this.colsRef;
    }

    @Override
    public NodeProcessResult<?> process(Node node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        return (NodeProcessResult)super.process(node, context);
    }

    protected NodeProcessResult<?> visitQuery(Query node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        if (node.getWith().isPresent()) {
            throw new IllegalStateException("with is not support," + node.getWith().get());
        }
        this.processRelation((Relation)node.getQueryBody(), context);
        if (node.getOrderBy().isPresent()) {
            this.process((Node)node.getOrderBy().get(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        }
        if (node.getLimit().isPresent()) {
            // empty if block
        }
        return null;
    }

    protected NodeProcessResult<?> visitAliasedRelation(AliasedRelation node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        this.process((Node)node.getRelation(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        if (context.getPreviousNode().isPresent()) {
            // empty if block
        }
        return null;
    }

    protected NodeProcessResult<?> visitGroupBy(GroupBy node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        TisGroupBy groupBy = new TisGroupBy();
        for (GroupingElement groupingElement : node.getGroupingElements()) {
            if (groupingElement instanceof SimpleGroupBy) {
                ImmutableSet columns = ImmutableSet.copyOf((Collection)((SimpleGroupBy)groupingElement).getColumnExpressions());
                for (Expression g : columns) {
                    if (g instanceof DereferenceExpression) {
                        DereferenceExpression group = (DereferenceExpression)g;
                        if (!(group.getBase() instanceof Identifier)) {
                            StreamTransformVisitor.faild((Node)group.getBase());
                        }
                        groupBy.add(new TisGroupBy.TisGroup(((Identifier)group.getBase()).getValue(), group.getField().getValue()));
                        continue;
                    }
                    StreamTransformVisitor.faild("groupby cols shall col must has tab reference", (Node)g);
                }
                continue;
            }
            StreamTransformVisitor.faild((Node)node);
        }
        if (groupBy.getGroups().size() > 0) {
            this.colsRef.getColRefMap().entrySet().forEach(r -> {
                if (r.getValue() instanceof FunctionDataTupleCreator) {
                    ((FunctionDataTupleCreator)r.getValue()).setGroupBy(groupBy);
                }
            });
        }
        return null;
    }

    protected NodeProcessResult<?> visitFunctionCall(FunctionCall expression, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        QualifiedName name = expression.getName();
        List exps = expression.getArguments();
        int argsize = exps.size();
        boolean index = false;
        for (Expression arg : exps) {
            this.process((Node)arg, (TISStackableAstVisitor.StackableAstVisitorContext)context);
        }
        return null;
    }

    protected NodeProcessResult<?> visitTableSubquery(TableSubquery node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        this.process((Node)node.getQuery(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        return null;
    }

    protected NodeProcessResult<?> visitLongLiteral(LongLiteral node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        return null;
    }

    protected NodeProcessResult<?> visitCast(Cast node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        this.process((Node)node.getExpression(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        return null;
    }

    protected NodeProcessResult<?> visitStringLiteral(StringLiteral node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        return null;
    }

    protected NodeProcessResult<?> visitIdentifier(Identifier node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        return null;
    }

    protected NodeProcessResult<?> visitDereferenceExpression(DereferenceExpression node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        this.process((Node)node.getBase(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        return null;
    }

    protected NodeProcessResult<?> visitComparisonExpression(ComparisonExpression node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        this.process((Node)node.getLeft(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        this.process((Node)node.getRight(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        return null;
    }

    protected NodeProcessResult<?> visitLogicalBinaryExpression(LogicalBinaryExpression node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        this.process((Node)node.getLeft(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        this.process((Node)node.getRight(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        return null;
    }

    protected NodeProcessResult<?> visitTable(Table node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        return null;
    }

    protected NodeProcessResult<?> visitSearchedCaseExpression(SearchedCaseExpression node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        this.processSearchedCaseExpression(node, context);
        return null;
    }

    private void processSearchedCaseExpression(SearchedCaseExpression expression, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        for (WhenClause when : expression.getWhenClauses()) {
            this.process((Node)when.getOperand(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
            this.process((Node)when.getResult(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        }
        Optional dft = expression.getDefaultValue();
        if (dft.isPresent()) {
            this.process((Node)dft.get(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        }
    }

    protected NodeProcessResult<?> visitCoalesceExpression(CoalesceExpression expression, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        for (Expression operand : expression.getOperands()) {
            this.process((Node)operand, (TISStackableAstVisitor.StackableAstVisitorContext)context);
        }
        return null;
    }

    protected NodeProcessResult<?> visitArithmeticBinary(ArithmeticBinaryExpression arithmeticBinaryExpression, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        this.process((Node)arithmeticBinaryExpression.getLeft(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        ArithmeticBinaryExpression.Operator operator = arithmeticBinaryExpression.getOperator();
        this.process((Node)arithmeticBinaryExpression.getRight(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        return null;
    }

    protected NodeProcessResult<?> visitSubscriptExpression(SubscriptExpression subscript, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        this.process((Node)subscript.getBase(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        this.process((Node)subscript.getIndex(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeProcessResult<?> visitSelect(Select node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        context.processSelect = true;
        try {
            SingleColumn single = null;
            Expression express = null;
            DereferenceExpression dref = null;
            ColName colName = null;
            ColRef colRef = new ColRef();
            NodeProcessResult<ColRef> result = new NodeProcessResult<ColRef>(colRef);
            IDataTupleCreator tupleCreator = null;
            for (SelectItem item : node.getSelectItems()) {
                if (item instanceof SingleColumn) {
                    single = (SingleColumn)item;
                    express = single.getExpression();
                    if (express instanceof DereferenceExpression) {
                        dref = (DereferenceExpression)express;
                        if (dref.getBase() instanceof Identifier) {
                            colName = single.getAlias().isPresent() ? new ColName(dref.getField().getValue(), ((Identifier)single.getAlias().get()).getValue()) : new ColName(dref.getField().getValue());
                            tupleCreator = StreamTransformVisitor.createTableTupleCreator(dref, colRef);
                            colRef.getColRefMap().put(colName, tupleCreator);
                            continue;
                        }
                        StreamTransformVisitor.faild((Node)dref.getBase());
                        continue;
                    }
                    if (single.getAlias().isPresent()) {
                        String name = ((Identifier)single.getAlias().get()).getValue();
                        colName = new ColName(name);
                        if (express instanceof SearchedCaseExpression) {
                            colRef.getColRefMap().put(colName, new FunctionDataTupleCreator(express, colRef));
                            continue;
                        }
                        if (express instanceof CoalesceExpression) {
                            colRef.getColRefMap().put(colName, new FunctionDataTupleCreator(express, colRef));
                            continue;
                        }
                        if (express instanceof FunctionCall) {
                            colRef.getColRefMap().put(colName, new FunctionDataTupleCreator(express, colRef));
                            continue;
                        }
                        if (express instanceof SubscriptExpression) {
                            colRef.getColRefMap().put(colName, new FunctionDataTupleCreator(express, colRef));
                            continue;
                        }
                        if (express instanceof Identifier) {
                            this.processIdentifier((Identifier)express, colRef);
                            continue;
                        }
                        if (express instanceof StringLiteral) {
                            colRef.getColRefMap().put(colName, new FunctionDataTupleCreator(express, colRef));
                            continue;
                        }
                        if (express instanceof IfExpression) {
                            colRef.getColRefMap().put(colName, new FunctionDataTupleCreator(express, colRef));
                            continue;
                        }
                        StreamTransformVisitor.faild((Node)express);
                    } else if (express instanceof Identifier) {
                        this.processIdentifier((Identifier)express, colRef);
                        continue;
                    }
                    StreamTransformVisitor.faild((Node)express);
                    continue;
                }
                throw new IllegalStateException("item type:" + item.getClass() + item);
            }
            NodeProcessResult<ColRef> nodeProcessResult = result;
            return nodeProcessResult;
        }
        finally {
            context.processSelect = false;
        }
    }

    private void processIdentifier(Identifier express, ColRef colRef) {
        ColName colName = new ColName(express.getValue());
        colRef.getColRefMap().put(colName, StreamTransformVisitor.createTableTupleCreator(null, colRef));
    }

    public static IDataTupleCreator createTableTupleCreator(DereferenceExpression dref, ColRef colRef) {
        String baseRef = null;
        baseRef = dref != null ? ((Identifier)dref.getBase()).getValue() : DEFAULT_SINGLE_TABLE;
        return colRef.createBaseRefIfNull(baseRef);
    }

    public static void faild(Node node) {
        NodeUtils.faild(null, node);
    }

    public static void faild(String msg, Node node) {
        NodeUtils.faild(msg, node);
    }

    protected NodeProcessResult<?> visitQuerySpecification(QuerySpecification body, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        Object selectresult = this.process((Node)body.getSelect(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        if (selectresult == null || ((NodeProcessResult)selectresult).getResult() == null || ((ColRef)((NodeProcessResult)selectresult).getResult()).getColRefMap().size() < 1) {
            throw new IllegalStateException("selectresult can not be null");
        }
        this.colsRef = (ColRef)((NodeProcessResult)selectresult).getResult();
        if (body.getLimit().isPresent()) {
            System.out.println("Limit = " + (String)body.getLimit().get());
        }
        Optional gby = body.getGroupBy();
        GroupBy group = null;
        if (gby.isPresent()) {
            group = (GroupBy)gby.get();
            this.visitGroupBy(group, context);
        }
        Optional from = body.getFrom();
        Relation rel = null;
        if (!from.isPresent()) {
            throw new IllegalStateException("have not set from \n" + body);
        }
        rel = (Relation)from.get();
        this.processFromRemoveAlias(this.colsRef, rel, context);
        Optional w = body.getWhere();
        Expression where = null;
        if (w.isPresent()) {
            where = (Expression)w.get();
            this.process((Node)where, (TISStackableAstVisitor.StackableAstVisitorContext)context);
        }
        return null;
    }

    private void processFromRemoveAlias(ColRef colRef, Relation from, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        TableReferenceVisitor tabRefVisitor = new TableReferenceVisitor(colRef, this.dumpNodesContext);
        tabRefVisitor.process((Node)from, context);
    }

    protected NodeProcessResult<?> visitJoin(Join node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        JoinCriteria criteria = node.getCriteria().orElse(null);
        Object type = node.getType().toString();
        if (criteria instanceof NaturalJoin) {
            type = "NATURAL " + (String)type;
        }
        if (node.getType() != Join.Type.IMPLICIT) {
            // empty if block
        }
        this.process((Node)node.getLeft(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        if (node.getType() == Join.Type.IMPLICIT) {
            // empty if block
        }
        this.process((Node)node.getRight(), (TISStackableAstVisitor.StackableAstVisitorContext)context);
        if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
            if (criteria instanceof JoinUsing) {
                JoinUsing joinUsing = (JoinUsing)criteria;
            } else if (criteria instanceof JoinOn) {
                JoinOn joinOn = (JoinOn)criteria;
            } else if (!(criteria instanceof NaturalJoin)) {
                throw new UnsupportedOperationException("unknown join criteria: " + criteria);
            }
        }
        if (node.getType() != Join.Type.IMPLICIT) {
            // empty if block
        }
        return null;
    }

    private void processRelation(Relation relation, TISStackableAstVisitor.StackableAstVisitorContext<Integer> indent) {
        if (!(relation instanceof Table)) {
            this.process((Node)relation, (TISStackableAstVisitor.StackableAstVisitorContext)indent);
        }
    }

    protected NodeProcessResult<?> visitIsNotNullPredicate(IsNotNullPredicate node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        return null;
    }

    protected NodeProcessResult<?> visitIsNullPredicate(IsNullPredicate node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        return null;
    }

    protected NodeProcessResult<?> visitNode(Node node, TISStackableAstVisitor.StackableAstVisitorContext<Integer> context) {
        throw new UnsupportedOperationException(String.valueOf(node));
    }
}

