/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.visitor;

import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qlangtech.tis.realtime.transfer.ruledriven.FunctionUtils;
import com.qlangtech.tis.realtime.transfer.ruledriven.GroupValues;
import com.qlangtech.tis.realtime.transfer.ruledriven.TypeCast;
import com.qlangtech.tis.sql.parser.ColName;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.sql.parser.tuple.creator.IDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.ColRef;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.FunctionDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.IScriptGenerateContext;
import com.qlangtech.tis.sql.parser.utils.NodeUtils;
import com.qlangtech.tis.sql.parser.visitor.BlockScriptBuffer;
import com.qlangtech.tis.sql.parser.visitor.FuncFormat;
import com.qlangtech.tis.sql.parser.visitor.OperatorResultTypeEnum;
import com.qlangtech.tis.sql.parser.visitor.StreamTransformVisitor;
import com.qlangtech.tis.sql.parser.visitor.TISUdfMeta;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;

public class FunctionVisitor
extends DefaultTraversalVisitor<Void, Void> {
    public static final String ROW_KEY = "row";
    public static final String SubscriptFunctionName = "getArrayIndexProp";
    public static final String FUNCTION_OP_AND = "op_and";
    private final ColRef colRef;
    protected final Map<ColName, IDataTupleCreator> functionParams;
    protected final IScriptGenerateContext generateContext;
    private final Stack<TISUdfMeta> inAggregateFunctionStack = new Stack();
    private final Stack<OperatorResultTypeEnum> operatorResultTypeStack = new Stack();
    private static final Map<String, TISUdfMeta> funcMeta = Maps.newHashMap();
    private final boolean processAggregationResult;
    private final BlockScriptBuffer funcFormat;

    public FunctionVisitor(ColRef colRef, Map<ColName, IDataTupleCreator> params, FuncFormat funcFormat, boolean processAggregationResult) {
        this(colRef, params, funcFormat, new MockScriptGenerateContext(), processAggregationResult);
    }

    public FunctionVisitor(ColRef colRef, Map<ColName, IDataTupleCreator> params, BlockScriptBuffer funcFormat, IScriptGenerateContext generateContext, boolean processAggregationResult) {
        this.funcFormat = funcFormat;
        this.colRef = colRef;
        this.functionParams = params;
        this.generateContext = generateContext;
        this.processAggregationResult = processAggregationResult;
    }

    protected Void visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
        this.process((Node)node.getLeft(), context);
        if (node.getOperator() == LogicalBinaryExpression.Operator.AND) {
            this.funcFormat.append((Object)" && ");
        } else if (node.getOperator() == LogicalBinaryExpression.Operator.OR) {
            this.funcFormat.append((Object)" || ");
        } else {
            NodeUtils.faild("visitLogicalBinaryExpression", (Node)node);
        }
        this.process((Node)node.getRight(), context);
        return null;
    }

    protected Void visitSubscriptExpression(SubscriptExpression node, Void context) {
        this.funcFormat.append((Object)SubscriptFunctionName).append((Object)"(");
        this.process((Node)node.getBase(), context);
        this.funcFormat.append((Object)",");
        this.process((Node)node.getIndex(), context);
        this.funcFormat.append((Object)")");
        return null;
    }

    public static void main(String[] args) throws Exception {
        InputStream input = FunctionVisitor.class.getResourceAsStream("/function/func.txt");
        LineIterator lineIt = IOUtils.lineIterator((InputStream)input, (Charset)Charset.defaultCharset());
        HashSet func = Sets.newHashSet();
        while (lineIt.hasNext()) {
            func.add(StringUtils.substringAfter((String)lineIt.next(), (String)":"));
        }
        func.forEach(e -> System.out.println((String)e));
    }

    protected Void visitComparisonExpression(ComparisonExpression node, Void context) {
        this.operatorResultTypeStack.push(OperatorResultTypeEnum.INT);
        try {
            this.funcFormat.append((Object)"(");
            this.process((Node)node.getLeft(), context);
            this.funcFormat.append((Object)this.operatorLiteria(node.getOperator()));
            if (this.isEqualOrNotOperator(node.getOperator())) {
                this.funcFormat.append((Object)" String.valueOf(");
            }
            this.process((Node)node.getRight(), context);
            this.funcFormat.append((Object)")");
            if (this.isEqualOrNotOperator(node.getOperator())) {
                this.funcFormat.append((Object)")");
            }
        }
        finally {
            this.operatorResultTypeStack.pop();
        }
        return null;
    }

    private boolean isEqualOrNotOperator(ComparisonExpression.Operator operator) {
        switch (operator) {
            case EQUAL: 
            case NOT_EQUAL: {
                return true;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unsupported comparison: " + operator);
    }

    private String operatorLiteria(ComparisonExpression.Operator operator) {
        switch (operator) {
            case EQUAL: {
                return "==";
            }
            case NOT_EQUAL: {
                return "!=";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_THAN_OR_EQUAL: {
                return "<=";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_THAN_OR_EQUAL: {
                return ">=";
            }
        }
        throw new IllegalArgumentException("Unsupported comparison: " + operator);
    }

    protected Void visitNode(Node node, Void context) {
        System.out.println("notsupported:" + node.getClass());
        return null;
    }

    protected Void visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
        this.funcFormat.append((Object)"(");
        this.process((Node)node.getLeft(), context);
        this.funcFormat.append((Object)node.getOperator().getValue());
        this.process((Node)node.getRight(), context);
        this.funcFormat.append((Object)")");
        return null;
    }

    protected Void visitDereferenceExpression(DereferenceExpression node, Void context) {
        ColName col = new ColName(node.getField().getValue());
        IDataTupleCreator tupleCreator = StreamTransformVisitor.createTableTupleCreator(node, this.colRef);
        this.functionParams.put(col, tupleCreator);
        boolean isAggregateNumerica = this.isAggregateNumerica();
        boolean isAggregateFunc = this.isAggregateFunc();
        if (isAggregateNumerica) {
            // empty if block
        }
        if (this.generateContext.isJoinPoint()) {
            this.processJoinPointPram(col);
            if (!this.operatorResultTypeStack.isEmpty()) {
                OperatorResultTypeEnum operatorResultTypeEnum = this.operatorResultTypeStack.peek();
            }
            this.funcFormat.append((Object)("getMediaResult(\"" + col.getName() + "\",row)"));
        } else if (this.generateContext.isNextGroupByFunction() && !this.generateContext.isGroupByFunction()) {
            this.funcFormat.startLine((Object)("v.getMediaProp(\"" + col.getName() + "\")"));
        } else if (this.processAggregationResult && !isAggregateFunc) {
            this.funcFormat.append((Object)"k.getKeyVal(\"").append((Object)col.getName()).append((Object)"\")");
        } else {
            this.funcFormat.append((Object)(isAggregateFunc ? "r" : ROW_KEY));
            this.funcFormat.append((Object)".getColumn(\"").append((Object)col.getName()).append((Object)"\")");
        }
        if (isAggregateNumerica) {
            // empty if block
        }
        return null;
    }

    protected void processJoinPointPram(ColName param) {
    }

    private boolean isAggregateNumerica() {
        if (this.inAggregateFunctionStack.isEmpty()) {
            return false;
        }
        TISUdfMeta udfMeta = this.inAggregateFunctionStack.peek();
        boolean isAggregateNumerica = udfMeta != null && udfMeta.isAggregateFunc() && udfMeta.isNumeric();
        return isAggregateNumerica;
    }

    private boolean isAggregateFunc() {
        return this.inAggregateFunctionStack.stream().filter(r -> r.isAggregateFunc()).findFirst().isPresent();
    }

    protected Void visitCast(Cast node, Void context) {
        String type = StringUtils.lowerCase((String)node.getType());
        TypeCast<?> cast = TypeCast.getTypeCast(type);
        this.funcFormat.append((Object)"typeCast(\"").append((Object)type).append((Object)"\",");
        this.process((Node)node.getExpression(), context);
        this.funcFormat.append((Object)")");
        return null;
    }

    public String getFuncFormat() {
        return this.funcFormat.toString();
    }

    protected Void visitStringLiteral(StringLiteral node, Void context) {
        this.funcFormat.append((Object)"\"").append((Object)node.getValue()).append((Object)"\"");
        return null;
    }

    protected Void visitLongLiteral(LongLiteral node, Void context) {
        this.funcFormat.append(node.getValue());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void visitFunctionCall(FunctionCall node, Void context) {
        String functionName = StringUtils.lowerCase((String)String.valueOf(node.getName()));
        TISUdfMeta fmeta = funcMeta.get(functionName);
        if (fmeta == null) {
            throw new IllegalStateException("func:" + functionName + " have not been define in funcMeta");
        }
        this.funcFormat.append((Object)functionName).append((Object)"(");
        this.inAggregateFunctionStack.push(fmeta);
        try {
            if (fmeta.isAggregateFunc()) {
                this.funcFormat.append((Object)"v, (r) => { \n");
                if (fmeta.isNumeric()) {
                    // empty if block
                }
                this.writeParams(node, context);
                this.funcFormat.append((Object)"}");
            } else {
                this.writeParams(node, context);
            }
        }
        finally {
            this.inAggregateFunctionStack.pop();
        }
        this.funcFormat.append((Object)")");
        return null;
    }

    private void writeParams(FunctionCall node, Void context) {
        List arguments = node.getArguments();
        boolean first = true;
        for (Expression arg : arguments) {
            if (!first) {
                this.funcFormat.append((Object)",");
            }
            first = false;
            this.process((Node)arg, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void visitCoalesceExpression(CoalesceExpression node, Void context) {
        boolean isAggregateNumerica = this.isAggregateNumerica();
        this.funcFormat.append((Object)(isAggregateNumerica ? "defaultDoubleVal" : "defaultVal")).append((Object)"(");
        this.inAggregateFunctionStack.push(new TISUdfMeta(false, null));
        try {
            boolean first = true;
            for (Expression oper : node.getOperands()) {
                if (!first) {
                    this.funcFormat.append((Object)",");
                }
                this.process((Node)oper, context);
                first = false;
            }
        }
        finally {
            this.inAggregateFunctionStack.pop();
        }
        this.funcFormat.append((Object)")");
        return null;
    }

    protected Void visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
        this.funcFormat.startLine((Object)"caseIfFunc(");
        Optional dft = node.getDefaultValue();
        if (!dft.isPresent()) {
            NodeUtils.faild("default value shall exist", (Node)node);
        }
        this.process((Node)dft.get(), context);
        for (WhenClause when : node.getWhenClauses()) {
            this.funcFormat.append((Object)",");
            this.funcFormat.startLine((Object)"new Case(");
            this.process((Node)when.getOperand(), context);
            this.funcFormat.append((Object)",");
            this.process((Node)when.getResult(), context);
            this.funcFormat.append((Object)")");
        }
        this.funcFormat.append((Object)")");
        return null;
    }

    static {
        funcMeta.put("rlike", new TISUdfMeta(false, FunctionUtils.getMethod("rlike", String.class, String.class)));
        funcMeta.put("min", new TISUdfMeta(true, FunctionUtils.getMethod("min", GroupValues.class, FunctionUtils.IValGetter.class)));
        funcMeta.put("max", new TISUdfMeta(true, FunctionUtils.getMethod("max", GroupValues.class, FunctionUtils.IValGetter.class)));
        funcMeta.put("split", new TISUdfMeta(false, FunctionUtils.getMethod("split", String.class, String.class)));
        funcMeta.put("concat_ws", new TISUdfMeta(false, FunctionUtils.getMethod("concat_ws", String.class, Object[].class)));
        funcMeta.put("round", new TISUdfMeta(false, FunctionUtils.getMethod("round", Double.TYPE, Integer.TYPE)));
        funcMeta.put("collect_list", new TISUdfMeta(true, FunctionUtils.getMethod("collect_list", GroupValues.class, FunctionUtils.IValGetter.class)));
        funcMeta.put("collect_set", new TISUdfMeta(true, FunctionUtils.getMethod("collect_set", GroupValues.class, FunctionUtils.IValGetter.class)));
        funcMeta.put("count", new TISUdfMeta(true, FunctionUtils.getMethod("count", GroupValues.class, FunctionUtils.IIntValGetter.class)));
        funcMeta.put(FUNCTION_OP_AND, new TISUdfMeta(false, FunctionUtils.getMethod(FUNCTION_OP_AND, Integer.TYPE, Integer.TYPE)));
        funcMeta.put("sum", new TISUdfMeta(true, true, FunctionUtils.getMethod("sum", GroupValues.class, FunctionUtils.IDoubleValGetter.class)));
        funcMeta.put("get_json_object", new TISUdfMeta(false, FunctionUtils.getMethod("get_json_object", String.class, String.class)));
        funcMeta.put("coalesce", new TISUdfMeta(false, FunctionUtils.getMethod("caseIfFunc", Object.class, FunctionUtils.Case[].class)));
        funcMeta.put("instr", new TISUdfMeta(false, FunctionUtils.getMethod("instr", String.class, String.class)));
        funcMeta.put("concat", new TISUdfMeta(false, FunctionUtils.getMethod("concat", String.class, String.class)));
    }

    private static class MockScriptGenerateContext
    implements IScriptGenerateContext {
        private MockScriptGenerateContext() {
        }

        @Override
        public IDataTupleCreator getTupleCreator() {
            return null;
        }

        @Override
        public boolean isLastFunctInChain() {
            return false;
        }

        @Override
        public boolean isGroupByFunction() {
            return false;
        }

        @Override
        public boolean isNextGroupByFunction() {
            return false;
        }

        @Override
        public boolean isNotDeriveFrom(EntityName entityName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isJoinPoint() {
            return false;
        }

        @Override
        public EntityName getEntityName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ColName getOutputColName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FunctionDataTupleCreator getFunctionDataTuple() {
            throw new UnsupportedOperationException();
        }
    }
}

