/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.utils;

import com.qlangtech.tis.sql.parser.IDumpNodeMapContext;
import com.qlangtech.tis.sql.parser.SqlTaskNode;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.TableTupleCreator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class DefaultDumpNodeMapContext
implements IDumpNodeMapContext {
    private final Map<EntityName, List<TableTupleCreator>> dumpNodsContext;
    private List<SqlTaskNode> allJoinNodes;

    public DefaultDumpNodeMapContext(Map<EntityName, List<TableTupleCreator>> dumpNodsContext) {
        this.dumpNodsContext = dumpNodsContext;
    }

    public void setAllJoinNodes(List<SqlTaskNode> allJoinNodes) {
        this.allJoinNodes = allJoinNodes;
    }

    @Override
    public List<SqlTaskNode> getAllJoinNodes() {
        return this.allJoinNodes;
    }

    @Override
    public SqlTaskNode geTaskNode(EntityName entityName) throws Exception {
        if (entityName == null) {
            throw new IllegalArgumentException("param entityName can not be null");
        }
        List<SqlTaskNode> allNodes = this.getAllJoinNodes();
        if (allNodes == null) {
            throw new IllegalStateException("entityName:" + entityName + " relevant join node can not be null");
        }
        Optional<SqlTaskNode> node = allNodes.stream().filter(r -> StringUtils.equals((String)r.getExportName().getTabName(), (String)entityName.getTabName())).findFirst();
        if (!node.isPresent()) {
            throw new IllegalStateException("nodename:" + entityName.getTabName() + " can not be find ,all:[" + allNodes.stream().map(e -> e.getExportName().getTabName()).collect(Collectors.joining(",")) + "] ");
        }
        return node.get();
    }

    @Override
    public Map<EntityName, List<TableTupleCreator>> getDumpNodesMap() {
        return this.dumpNodsContext;
    }

    @Override
    public EntityName accurateMatch(String tabname) {
        List names = this.dumpNodsContext.keySet().stream().filter(e -> StringUtils.equals((String)e.getTabName(), (String)tabname)).collect(Collectors.toList());
        if (names.size() != 1) {
            throw new IllegalStateException("table:" + tabname + " relevant tab not equal with 1 ,size:" + names.size());
        }
        return (EntityName)names.get(0);
    }

    @Override
    public EntityName nullableMatch(String tabname) {
        List names = this.dumpNodsContext.keySet().stream().filter(e -> StringUtils.equals((String)e.getTabName(), (String)tabname)).collect(Collectors.toList());
        if (names.size() < 1) {
            return null;
        }
        if (names.size() != 1) {
            throw new IllegalStateException("table:" + tabname + " relevant tab not equal with 1 ,size:" + names.size());
        }
        return (EntityName)names.get(0);
    }
}

