/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.tuple.creator.impl;

import com.google.common.collect.Lists;
import com.qlangtech.tis.sql.parser.tuple.creator.IValChain;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.FunctionDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.PropGetter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class ValChain
implements IValChain {
    private List<PropGetter> chain = Lists.newArrayList();
    private PropGetter last = null;
    private PropGetter first = null;
    private final AtomicBoolean everAdd = new AtomicBoolean(false);
    private final AtomicBoolean everReverse = new AtomicBoolean(false);

    @Override
    public boolean useAliasOutputName() {
        return !StringUtils.equals((String)this.last.getOutputColName().getName(), (String)this.first.getOutputColName().getAliasName());
    }

    public void add(PropGetter p) {
        if (this.everAdd.compareAndSet(false, true)) {
            this.first = p;
        }
        if (this.last != null) {
            this.last.setNext(p);
            p.setPrev(this.last);
        }
        this.chain.add(p);
        this.last = p;
    }

    @Override
    public <R> Stream<R> mapChainValve(Function<PropGetter, ? extends R> mapper) {
        return this.chain.stream().map(mapper);
    }

    @Override
    public Stream<PropGetter> chainStream() {
        if (this.everReverse.compareAndSet(false, true)) {
            Collections.reverse(this.chain);
            AtomicReference lastFunc = new AtomicReference();
            this.chain.stream().filter(r -> r.getTupleCreator() != null && r.getTupleCreator() instanceof FunctionDataTupleCreator).forEach(r -> {
                r.setLastFunctInChain(true);
                PropGetter prev = lastFunc.getAndSet(r);
                if (prev != null) {
                    prev.setLastFunctInChain(false);
                }
            });
            this.chain = Collections.unmodifiableList(this.chain);
        }
        return this.chain.stream();
    }

    @Override
    public boolean hasFuncTuple() {
        for (PropGetter p : this.chain) {
            if (p.getTupleCreator() == null || !(p.getTupleCreator() instanceof FunctionDataTupleCreator)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PropGetter first() {
        return this.first;
    }

    @Override
    public PropGetter last() {
        return this.last;
    }
}

