/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.tuple.creator.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.sql.parser.ColName;
import com.qlangtech.tis.sql.parser.er.ERRules;
import com.qlangtech.tis.sql.parser.meta.NodeType;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.sql.parser.tuple.creator.IDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.IDataTupleCreatorVisitor;
import com.qlangtech.tis.sql.parser.tuple.creator.IEntityNameGetter;
import com.qlangtech.tis.sql.parser.tuple.creator.IValChain;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.FunctionDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.PropGetter;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.TableTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.ValChain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class TaskNodeTraversesCreatorVisitor
implements IDataTupleCreatorVisitor {
    public final Stack<PropGetter> propStack = new Stack();
    private final Map<TableTupleCreator, List<ValChain>> tabTriggerLinker = Maps.newHashMap();
    private final ERRules erRules;

    public TaskNodeTraversesCreatorVisitor(ERRules erRules) {
        this.erRules = erRules;
    }

    @Override
    public void visit(FunctionDataTupleCreator function) {
        PropGetter peek = this.getPeek();
        if (peek == null) {
            throw new IllegalStateException("peek can not be null");
        }
        function.getParams().entrySet().stream().forEach(r -> {
            this.pushPropGetter(new ColName(((ColName)r.getKey()).getName(), peek.getOutputColName().getAliasName()), peek.getTupleCreator().getEntityName(), (IDataTupleCreator)r.getValue());
            try {
                ((IDataTupleCreator)r.getValue()).accept(this);
            }
            finally {
                this.propStack.pop();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(TableTupleCreator tableTuple) {
        if (tableTuple.getNodetype() == NodeType.DUMP) {
            ArrayList propsGetters;
            ValChain propGetters = new ValChain();
            PropGetter prop = null;
            for (int i = 0; i < this.propStack.size(); ++i) {
                prop = (PropGetter)this.propStack.get(i);
                propGetters.add(prop);
            }
            if (prop != null) {
                propGetters.add(new PropGetter(new ColName(prop.getOutputColName().getName()), tableTuple.getEntityName(), null));
            }
            if ((propsGetters = this.tabTriggerLinker.get(tableTuple)) == null) {
                propsGetters = Lists.newArrayList();
                this.tabTriggerLinker.put(tableTuple, propsGetters);
            }
            propsGetters.add(propGetters);
            return;
        }
        if (tableTuple.getNodetype() == NodeType.JOINER_SQL) {
            PropGetter peek = this.getPeek();
            for (Map.Entry<ColName, IDataTupleCreator> centry : tableTuple.getColsRefs().getColRefMap().entrySet()) {
                if (peek != null && !StringUtils.equals((String)peek.getOutputColName().getName(), (String)centry.getKey().getAliasName())) continue;
                this.pushPropGetter(centry.getKey(), tableTuple.getEntityName(), centry.getValue());
                if (centry.getValue() == null) {
                    throw new IllegalStateException("centry.getKey():" + centry.getKey() + " relevant value IDataTupleCreator can not be null");
                }
                try {
                    centry.getValue().accept(this);
                }
                finally {
                    this.propStack.pop();
                }
                if (peek == null) continue;
                break;
            }
        } else {
            throw new IllegalStateException("tableTuple.getNodetype():" + tableTuple.getNodetype() + " is illegal");
        }
    }

    public PropGetter getPeek() {
        PropGetter peek = null;
        if (!this.propStack.isEmpty()) {
            peek = this.propStack.peek();
        }
        return peek;
    }

    public int getPropGetterStackSize() {
        return this.propStack.size();
    }

    public void clearPropStack() {
        this.propStack.clear();
    }

    public void pushPropGetter(ColName output, EntityName entityName, IDataTupleCreator tupleCreator) {
        this.propStack.push(new PropGetter(output, entityName, tupleCreator));
    }

    public Map<IEntityNameGetter, List<IValChain>> getTabTriggerLinker() {
        HashMap convert = Maps.newHashMap();
        for (Map.Entry<TableTupleCreator, List<ValChain>> entry : this.tabTriggerLinker.entrySet()) {
            convert.put((IEntityNameGetter)entry.getKey(), entry.getValue().stream().collect(Collectors.toList()));
        }
        return convert;
    }
}

