/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.tuple.creator.impl;

import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.TableSubquery;
import com.qlangtech.tis.sql.parser.IDumpNodeMapContext;
import com.qlangtech.tis.sql.parser.SqlTaskNode;
import com.qlangtech.tis.sql.parser.meta.NodeType;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.sql.parser.tuple.creator.IDataTupleCreatorVisitor;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.FunctionDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.TableTupleCreator;
import com.qlangtech.tis.sql.parser.visitor.TableDependencyVisitor;
import com.qlangtech.tis.sql.parser.visitor.TableReferenceVisitor;
import java.util.Optional;

public class TabCriteriaEntityRecognizeVisitor
implements IDataTupleCreatorVisitor {
    private final TableReferenceVisitor.TabCriteria tabCriteria;
    private final IDumpNodeMapContext dumpNodsContext;
    private TableSubquery subQuery;

    public TabCriteriaEntityRecognizeVisitor(TableReferenceVisitor.TabCriteria tabCriteria, IDumpNodeMapContext dumpNodsContext) {
        this.tabCriteria = tabCriteria;
        this.dumpNodsContext = dumpNodsContext;
    }

    @Override
    public void visit(FunctionDataTupleCreator function) {
    }

    @Override
    public void visit(TableTupleCreator tableTuple) {
        TableReferenceVisitor.TabCriteria tableCriteria = this.tabCriteria;
        if (!tableCriteria.isPrimary()) {
            JoinOn joinOn = tableCriteria.getJoinOn();
            ComparisonExpression compare = null;
            LogicalBinaryExpression logic = null;
            if (joinOn.getExpression() instanceof ComparisonExpression) {
                compare = (ComparisonExpression)joinOn.getExpression();
            } else if (joinOn.getExpression() instanceof LogicalBinaryExpression) {
                logic = (LogicalBinaryExpression)joinOn.getExpression();
            }
        }
        if (this.subQuery != null) {
            SqlTaskNode subqueryTaskNode = new SqlTaskNode(EntityName.parse((String)tableCriteria.getName()), NodeType.JOINER_SQL, this.dumpNodsContext);
            subqueryTaskNode.setContent(SqlFormatter.formatSql((Node)this.subQuery.getQuery().getQueryBody(), Optional.empty()));
            TableDependencyVisitor dependenciesVisitor = TableDependencyVisitor.create();
            Query query = SqlTaskNode.parseQuery(subqueryTaskNode.getContent());
            dependenciesVisitor.process((Node)query, null);
            dependenciesVisitor.getTabDependencies().stream().forEach(table -> {
                EntityName firstMatch = this.dumpNodsContext.accurateMatch((String)table);
                subqueryTaskNode.addRequired(firstMatch, new SqlTaskNode(firstMatch, NodeType.DUMP, this.dumpNodsContext));
            });
            TableTupleCreator tupleCreator = subqueryTaskNode.parse(true);
            tableTuple.setColsRefs(tupleCreator.getColsRefs());
            tableTuple.setRealEntityName(tupleCreator.getEntityName());
        } else {
            EntityName ename = this.dumpNodsContext.nullableMatch(tableCriteria.getName());
            if (ename != null) {
                tableTuple.setNodetype(NodeType.DUMP);
                tableTuple.setRealEntityName(ename);
            } else {
                tableTuple.setRealEntityName(EntityName.parse((String)tableCriteria.getName()));
            }
        }
    }

    public TableSubquery getSubQuery() {
        return this.subQuery;
    }

    public void setSubQuery(TableSubquery subQuery) {
        this.subQuery = subQuery;
    }
}

