/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.tuple.creator.impl;

import com.qlangtech.tis.sql.parser.ColName;
import com.qlangtech.tis.sql.parser.TisGroupBy;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.sql.parser.tuple.creator.IDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.FunctionDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.IScriptGenerateContext;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.TableTupleCreator;
import com.qlangtech.tis.sql.parser.visitor.BlockScriptBuffer;
import java.util.Optional;

public class PropGetter
implements IScriptGenerateContext {
    protected final IDataTupleCreator tupleCreator;
    protected final ColName output;
    private final EntityName entityName;
    private boolean lastFunctInChain = false;
    private PropGetter next;
    private PropGetter prev;

    public PropGetter(ColName output, EntityName entityName, IDataTupleCreator tupleCreator) {
        this.tupleCreator = tupleCreator;
        this.output = output;
        this.entityName = entityName;
    }

    public PropGetter getPrev() {
        return this.prev;
    }

    public void setPrev(PropGetter prev) {
        this.prev = prev;
    }

    @Override
    public boolean isNotDeriveFrom(EntityName entityName) {
        if (!(this.next.getTupleCreator() instanceof TableTupleCreator)) {
            return false;
        }
        TableTupleCreator nextTableTuple = (TableTupleCreator)this.next.getTupleCreator();
        return nextTableTuple.getEntityName().equals((Object)entityName);
    }

    @Override
    public boolean isGroupByFunction() {
        if (!(this.tupleCreator instanceof FunctionDataTupleCreator)) {
            return false;
        }
        FunctionDataTupleCreator tuple = this.getFunctionDataTuple();
        Optional<TisGroupBy> group = tuple.getGroupBy();
        return group.isPresent();
    }

    @Override
    public boolean isNextGroupByFunction() {
        for (PropGetter next = this.getNext(); next != null; next = next.getNext()) {
            if (!(next.tupleCreator instanceof FunctionDataTupleCreator)) continue;
            return next.isGroupByFunction();
        }
        return false;
    }

    public PropGetter getNextGroupByPropGetter() {
        for (PropGetter next = this.getNext(); next != null; next = next.getNext()) {
            if (!(next.tupleCreator instanceof FunctionDataTupleCreator) || !next.isGroupByFunction()) continue;
            return next;
        }
        return null;
    }

    public boolean isNextFunctionTuple() {
        for (PropGetter next = this.getNext(); next != null; next = next.getNext()) {
            if (!(next.tupleCreator instanceof FunctionDataTupleCreator)) continue;
            return next.isGroupByFunction();
        }
        return false;
    }

    public PropGetter getNext() {
        return this.next;
    }

    public void setNext(PropGetter next) {
        this.next = next;
    }

    @Override
    public boolean isJoinPoint() {
        return this.tupleCreator.refTableSourceCount() > 1;
    }

    public boolean shallCallableProcess() {
        return this.isJoinPoint() && this.isLastFunctInChain();
    }

    @Override
    public boolean isLastFunctInChain() {
        return this.lastFunctInChain;
    }

    public void setLastFunctInChain(boolean lastFunctInChain) {
        this.lastFunctInChain = lastFunctInChain;
    }

    public String getIdentityName() {
        return this.entityName + "." + this.output.getAliasName();
    }

    public void getGroovyScript(BlockScriptBuffer rr, boolean processAggregationResult) {
        if (this.tupleCreator == null) {
            return;
        }
        this.tupleCreator.generateGroovyScript(rr, this, processAggregationResult);
    }

    @Override
    public IDataTupleCreator getTupleCreator() {
        return this.tupleCreator;
    }

    @Override
    public ColName getOutputColName() {
        return this.output;
    }

    @Override
    public EntityName getEntityName() {
        if (this.entityName == null) {
            throw new IllegalStateException("entityName can not be null");
        }
        return this.entityName;
    }

    @Override
    public FunctionDataTupleCreator getFunctionDataTuple() {
        if (!(this.tupleCreator instanceof FunctionDataTupleCreator)) {
            throw new IllegalStateException("this.tupleCreator is not type of FunctionDataTupleCreator :" + this.tupleCreator);
        }
        return (FunctionDataTupleCreator)this.tupleCreator;
    }
}

