/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.tuple.creator.impl;

import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qlangtech.tis.sql.parser.ColName;
import com.qlangtech.tis.sql.parser.TisGroupBy;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.sql.parser.tuple.creator.IDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.IDataTupleCreatorVisitor;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.ColRef;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.IScriptGenerateContext;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.TableTupleCreator;
import com.qlangtech.tis.sql.parser.visitor.BlockScriptBuffer;
import com.qlangtech.tis.sql.parser.visitor.FuncFormat;
import com.qlangtech.tis.sql.parser.visitor.FunctionGenerateScriptVisitor;
import com.qlangtech.tis.sql.parser.visitor.FunctionVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class FunctionDataTupleCreator
implements IDataTupleCreator {
    public final Map<ColName, IDataTupleCreator> params;
    private final int refTableSourceCount;
    private final Expression expression;
    private final ColRef colRef;
    private Optional<TisGroupBy> groupBy = Optional.empty();

    public FunctionDataTupleCreator(Expression expression, ColRef colRef) {
        this.expression = expression;
        this.colRef = colRef;
        HashMap p = Maps.newHashMap();
        FunctionVisitor functionVisitor = new FunctionVisitor(this.getColRef(), p, new FuncFormat(), false);
        functionVisitor.process((Node)this.expression, null);
        this.params = Collections.unmodifiableMap(p);
        HashSet mediaTabRef = Sets.newHashSet();
        TableTupleCreator tab = null;
        for (IDataTupleCreator tuple : this.params.values()) {
            tab = (TableTupleCreator)tuple;
            mediaTabRef.add(tab.getMediaTabRef());
        }
        this.refTableSourceCount = mediaTabRef.size();
    }

    @Override
    public int refTableSourceCount() {
        return this.refTableSourceCount;
    }

    @Override
    public void generateGroovyScript(BlockScriptBuffer rr, IScriptGenerateContext context, boolean processAggregationResult) {
        FunctionGenerateScriptVisitor functionVisitor = new FunctionGenerateScriptVisitor(this.colRef, this.params, rr, context, processAggregationResult);
        functionVisitor.process((Node)this.expression, null);
        functionVisitor.getFuncFormat();
    }

    @Override
    public EntityName getEntityName() {
        Iterator paramsIt = this.params.entrySet().stream().map(c -> ((IDataTupleCreator)c.getValue()).getEntityName() + "." + ((ColName)c.getKey()).getName()).iterator();
        StringBuffer buffer = new StringBuffer();
        if (this.groupBy.isPresent()) {
            buffer.append("{");
        }
        buffer.append("func(" + Joiner.on((String)",").join(paramsIt) + ")");
        if (this.groupBy.isPresent()) {
            buffer.append(",groupby[" + Joiner.on((String)",").join(this.groupBy.get().getGroups().stream().map(r -> r.getTabTuple().getEntityName() + "." + r.getColname()).iterator()) + "]}");
        }
        return EntityName.createFuncEntity((StringBuffer)buffer);
    }

    public final Optional<TisGroupBy> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(TisGroupBy groupBy) {
        this.groupBy = Optional.of(groupBy);
    }

    @Override
    public void accept(IDataTupleCreatorVisitor visitor) {
        visitor.visit(this);
    }

    public Map<ColName, IDataTupleCreator> getParams() {
        return this.params;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public ColRef getColRef() {
        return this.colRef;
    }

    public String toString() {
        return "FunctionDataTuple";
    }
}

