/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.tuple.creator.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.sql.parser.ColName;
import com.qlangtech.tis.sql.parser.meta.NodeType;
import com.qlangtech.tis.sql.parser.tuple.creator.IDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.TableTupleCreator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ColRef {
    private ListMap colRefMap = new ListMap();
    private Map<String, IDataTupleCreator> baseRefMap = Maps.newHashMap();

    public Set<Map.Entry<String, IDataTupleCreator>> getBaseRefEntities() {
        return this.baseRefMap.entrySet();
    }

    public IDataTupleCreator createBaseRefIfNull(String baseRef) {
        IDataTupleCreator tupleCreator = null;
        tupleCreator = this.baseRefMap.get(baseRef);
        if (tupleCreator == null) {
            tupleCreator = new TableTupleCreator(baseRef, NodeType.JOINER_SQL);
            this.baseRefMap.put(baseRef, tupleCreator);
        }
        return tupleCreator;
    }

    public int getBaseRefSize() {
        return this.baseRefMap.size();
    }

    public IDataTupleCreator getTupleCreator(String alias) {
        return this.baseRefMap.get(alias);
    }

    public Set<String> getBaseRefKeys() {
        return this.baseRefMap.keySet();
    }

    public ListMap getColRefMap() {
        return this.colRefMap;
    }

    public static class ListMap {
        private final Map<ColName, IDataTupleCreator> colRefMap = Maps.newHashMap();
        private final List<ColName> cols = Lists.newArrayList();

        public void put(ColName col, IDataTupleCreator tuple) {
            this.colRefMap.put(col, tuple);
            this.cols.add(col);
        }

        public Collection<IDataTupleCreator> values() {
            return this.colRefMap.values();
        }

        public Set<Map.Entry<ColName, IDataTupleCreator>> entrySet() {
            return this.colRefMap.entrySet();
        }

        public int size() {
            return this.colRefMap.size();
        }

        public IDataTupleCreator get(ColName col) {
            return this.colRefMap.get(col);
        }

        public List<ColName> keySet() {
            return this.cols;
        }
    }
}

