/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.stream.generate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.TableAlias;
import com.qlangtech.tis.datax.TableAliasMapper;
import com.qlangtech.tis.datax.impl.DataxProcessor;
import com.qlangtech.tis.manage.IBasicAppSource;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.manage.common.incr.StreamContextConstant;
import com.qlangtech.tis.realtime.transfer.UnderlineUtils;
import com.qlangtech.tis.sql.parser.TisGroupBy;
import com.qlangtech.tis.sql.parser.er.ERRules;
import com.qlangtech.tis.sql.parser.er.IERRules;
import com.qlangtech.tis.sql.parser.er.PrimaryTableMeta;
import com.qlangtech.tis.sql.parser.meta.TabExtraMeta;
import com.qlangtech.tis.sql.parser.stream.generate.FacadeContext;
import com.qlangtech.tis.sql.parser.stream.generate.MapDataMethodCreator;
import com.qlangtech.tis.sql.parser.stream.generate.MergeData;
import com.qlangtech.tis.sql.parser.stream.generate.StreamCodeContext;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.sql.parser.tuple.creator.IStreamIncrGenerateStrategy;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.FunctionDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.PropGetter;
import com.qlangtech.tis.sql.parser.visitor.FuncFormat;
import com.qlangtech.tis.sql.parser.visitor.IBlockToString;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamComponentCodeGeneratorFlink
extends StreamCodeContext {
    private static final Logger logger = LoggerFactory.getLogger(StreamComponentCodeGeneratorFlink.class);
    private final IBasicAppSource streamIncrGenerateStrategy;
    private final List<FacadeContext> daoFacadeList;
    private final Map<EntityName, MapDataMethodCreator> mapDataMethodCreatorMap = Maps.newHashMap();
    private static final VelocityEngine velocityEngine;

    public StreamComponentCodeGeneratorFlink(DataXName collectionName, long timestamp, List<FacadeContext> daoFacadeList, IBasicAppSource streamIncrGenerateStrategy) {
        super(collectionName, timestamp);
        Objects.requireNonNull(streamIncrGenerateStrategy, "streamIncrGenerateStrategy can not be null");
        this.streamIncrGenerateStrategy = streamIncrGenerateStrategy;
        this.daoFacadeList = daoFacadeList;
    }

    private List<TableAlias> getTabTriggerLinker() {
        return (List)this.streamIncrGenerateStrategy.accept((IBasicAppSource.IAppSourceVisitor)new IBasicAppSource.IAppSourceVisitor<List<TableAlias>>(){

            public List<TableAlias> visit(DataxProcessor processor) {
                ArrayList aliases = Lists.newArrayList();
                TableAliasMapper tabAlias = processor.getTabAlias(null, true);
                tabAlias.forEach((key, alia) -> aliases.add(alia));
                if (CollectionUtils.isEmpty((Collection)aliases)) {
                    throw new IllegalStateException("pipeline:" + processor.identityValue() + " relevant aliases can not be empty");
                }
                return aliases;
            }
        });
    }

    private IERRules getERRule() {
        ERRules erRules = new ERRules(){

            @Override
            public List<PrimaryTableMeta> getPrimaryTabs() {
                TabExtraMeta tabMeta = new TabExtraMeta();
                PrimaryTableMeta ptab = new PrimaryTableMeta("tabName", tabMeta);
                return Collections.singletonList(ptab);
            }
        };
        return erRules;
    }

    public void build() throws Exception {
        MergeData mergeData = new MergeData(this.collectionName, this.mapDataMethodCreatorMap, this.getTabTriggerLinker(), this.getERRule(), this.daoFacadeList, (IStreamIncrGenerateStrategy)this.streamIncrGenerateStrategy);
        this.mergeGenerate(this.streamIncrGenerateStrategy.decorateMergeData((IStreamIncrGenerateStrategy.IStreamTemplateData)mergeData));
    }

    public void generateConfigFiles() throws Exception {
        MergeData mergeData = new MergeData(this.collectionName, this.mapDataMethodCreatorMap, Collections.emptyList(), this.getERRule(), this.daoFacadeList, (IStreamIncrGenerateStrategy)this.streamIncrGenerateStrategy);
        File parentDir = new File(this.getSpringConfigFilesDir(), "com/qlangtech/tis/realtime/transfer/" + this.collectionName);
        FileUtils.forceMkdir((File)parentDir);
        this.mergeGenerate(mergeData, IStreamIncrGenerateStrategy.IStreamTemplateResource.createClasspathResource((String)"app-context.xml.vm", (boolean)true), new File(parentDir, "app-context.xml"));
        this.mergeGenerate(mergeData, IStreamIncrGenerateStrategy.IStreamTemplateResource.createClasspathResource((String)"field-transfer.xml.vm", (boolean)true), new File(parentDir, "field-transfer.xml"));
    }

    public File getSpringConfigFilesDir() {
        return new File(StreamContextConstant.getStreamScriptRootDir(this.collectionName, this.timestamp), "scriptconfig");
    }

    private MapDataMethodCreator addMapDataMethodCreator(EntityName entityName, TisGroupBy groups, Set<String> relevantCols) {
        MapDataMethodCreator creator = this.mapDataMethodCreatorMap.get(entityName);
        if (creator == null) {
            creator = new MapDataMethodCreator(entityName, groups, (IStreamIncrGenerateStrategy)this.streamIncrGenerateStrategy, relevantCols);
            this.mapDataMethodCreatorMap.put(entityName, creator);
        }
        return creator;
    }

    private void generateCreateGroupResultScript(FuncFormat rr, PropGetter propGetter, TisGroupBy groups) {
        if (propGetter.isLastFunctInChain()) {
            rr.startLine("var result:Any = null");
        }
        final AtomicBoolean hasBreak = new AtomicBoolean();
        rr.startLine(new IBlockToString(){

            public String toString() {
                return hasBreak.get() ? "breakable {" : "";
            }
        });
        rr.methodBody("for ((k:GroupKey, v:GroupValues)  <- " + groups.getGroupAggrgationName() + ")", r -> {
            PropGetter pgetter = propGetter;
            if (propGetter.isLastFunctInChain()) {
                rr.startLine("result = ");
                hasBreak.set(true);
                propGetter.getGroovyScript(rr, true);
                rr.startLine("break");
                rr.returnLine();
            } else {
                boolean shallCallableProcess;
                PropGetter prev;
                for (prev = propGetter.getPrev(); prev != null && !(prev.getTupleCreator() instanceof FunctionDataTupleCreator); prev = prev.getPrev()) {
                }
                boolean bl = shallCallableProcess = prev != null && prev.shallCallableProcess();
                if (shallCallableProcess) {
                    rr.startLine("putMediaResult(\"" + pgetter.getOutputColName().getAliasName() + "\", //");
                } else {
                    rr.startLine("v.putMediaData( // \n");
                    rr.startLine("\"").append((Object)propGetter.getOutputColName().getAliasName()).append((Object)"\" // \n");
                    rr.startLine(", //\n");
                }
                propGetter.getGroovyScript(rr, true);
                if (shallCallableProcess) {
                    rr.startLine(") // end putMediaResult");
                    hasBreak.set(true);
                    rr.startLine("break");
                } else {
                    rr.startLine(") // end putMediaData\n");
                }
            }
        });
        rr.startLine(new IBlockToString(){

            public String toString() {
                return hasBreak.get() ? "} //end breakable" : "";
            }
        });
        if (propGetter.isLastFunctInChain()) {
            rr.startLine(" result //return");
        }
        rr.returnLine();
    }

    private VelocityContext createContext(IStreamIncrGenerateStrategy.IStreamTemplateData mergeData) {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("config", (Object)mergeData);
        return velocityContext;
    }

    private void mergeGenerate(IStreamIncrGenerateStrategy.IStreamTemplateData mergeData) throws IOException {
        IStreamIncrGenerateStrategy.IStreamTemplateResource tplResource = this.streamIncrGenerateStrategy.getFlinkStreamGenerateTplResource();
        Objects.requireNonNull(tplResource, "tplResource can not be null");
        this.mergeGenerate(mergeData, tplResource, this.getIncrScriptMainFile());
    }

    private void mergeGenerate(IStreamIncrGenerateStrategy.IStreamTemplateData mergeData, IStreamIncrGenerateStrategy.IStreamTemplateResource tplResource, File createdFile) {
        OutputStreamWriter writer = null;
        try {
            VelocityContext context = this.createContext(mergeData);
            FileUtils.forceMkdir((File)this.incrScriptDir);
            writer = new OutputStreamWriter((OutputStream)FileUtils.openOutputStream((File)createdFile), TisUTF8.get());
            if (tplResource instanceof IStreamIncrGenerateStrategy.StringTemplateResource) {
                try (Reader reader = ((IStreamIncrGenerateStrategy.StringTemplateResource)tplResource).getContentReader();){
                    velocityEngine.evaluate((Context)context, (Writer)writer, "tis", reader);
                }
            } else if (tplResource instanceof IStreamIncrGenerateStrategy.ClasspathTemplateResource) {
                Template tpl = velocityEngine.getTemplate(((IStreamIncrGenerateStrategy.ClasspathTemplateResource)tplResource).getTplPath(), TisUTF8.getName());
                tpl.merge((Context)context, (Writer)writer);
            }
            writer.flush();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public final File getIncrScriptMainFile() {
        return new File(this.incrScriptDir, UnderlineUtils.getJavaName((String)this.collectionName) + "Listener.scala");
    }

    static {
        try {
            velocityEngine = new VelocityEngine();
            Properties prop = new Properties();
            prop.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogChute");
            prop.setProperty("resource.loader", "classpath");
            prop.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
            velocityEngine.init(prop);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

