/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.stream.generate;

import com.google.common.collect.Maps;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.manage.common.incr.StreamContextConstant;
import com.qlangtech.tis.realtime.transfer.UnderlineUtils;
import com.qlangtech.tis.sql.parser.TisGroupBy;
import com.qlangtech.tis.sql.parser.stream.generate.FacadeContext;
import com.qlangtech.tis.sql.parser.stream.generate.MapDataMethodCreator;
import com.qlangtech.tis.sql.parser.stream.generate.MergeData;
import com.qlangtech.tis.sql.parser.stream.generate.StreamCodeContext;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.sql.parser.tuple.creator.IStreamIncrGenerateStrategy;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.FunctionDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.PropGetter;
import com.qlangtech.tis.sql.parser.visitor.FuncFormat;
import com.qlangtech.tis.sql.parser.visitor.IBlockToString;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamComponentCodeGenerator
extends StreamCodeContext {
    private static final Logger logger = LoggerFactory.getLogger(StreamComponentCodeGenerator.class);
    private final IStreamIncrGenerateStrategy streamIncrGenerateStrategy;
    private final boolean excludeFacadeDAOSupport;
    private final List<FacadeContext> daoFacadeList;
    private final Map<EntityName, MapDataMethodCreator> mapDataMethodCreatorMap = Maps.newHashMap();
    private static final VelocityEngine velocityEngine;

    public StreamComponentCodeGenerator(DataXName collectionName, long timestamp, List<FacadeContext> daoFacadeList, IStreamIncrGenerateStrategy streamIncrGenerateStrategy) {
        this(collectionName, timestamp, daoFacadeList, streamIncrGenerateStrategy, false);
    }

    public StreamComponentCodeGenerator(DataXName collectionName, long timestamp, List<FacadeContext> daoFacadeList, IStreamIncrGenerateStrategy streamIncrGenerateStrategy, boolean excludeFacadeDAOSupport) {
        super(collectionName, timestamp);
        Objects.requireNonNull(streamIncrGenerateStrategy, "streamIncrGenerateStrategy can not be null");
        this.streamIncrGenerateStrategy = streamIncrGenerateStrategy;
        this.daoFacadeList = daoFacadeList;
        this.excludeFacadeDAOSupport = excludeFacadeDAOSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFunctionCallScript(FuncFormat rr, PropGetter propGetter) {
        rr.startLine("//===================================");
        AtomicBoolean isFirstReturn = new AtomicBoolean(true);
        IBlockToString returnVal = new IBlockToString(){

            public String toString() {
                return "";
            }
        };
        try {
            if (!propGetter.isLastFunctInChain()) {
                rr.startLine("putMediaResult(\"" + propGetter.getOutputColName().getAliasName() + "\", //");
                propGetter.getGroovyScript(rr, false);
                rr.startLine(")");
                return;
            }
            rr.startLine(returnVal);
            if (propGetter.shallCallableProcess()) {
                propGetter.getGroovyScript(rr, false);
            } else if (propGetter.isLastFunctInChain() && !propGetter.isGroupByFunction() && propGetter.isNextGroupByFunction()) {
                isFirstReturn.set(false);
                PropGetter nextGroup = propGetter.getNextGroupByPropGetter();
                if (nextGroup == null) {
                    throw new IllegalStateException("NextGroupByPropGetter can not be null");
                }
                rr.startLine("var result:Any = null");
                rr.startLine("breakable {");
                rr.methodBody("for((k:GroupKey, v:GroupValues) <- " + nextGroup.getFunctionDataTuple().getGroupBy().get().getGroupAggrgationName() + ")", r -> {
                    r.append((Object)"result = ");
                    propGetter.getGroovyScript(r, true);
                    rr.startLine("break");
                });
                rr.startLine(" }");
                rr.startLine("result");
            } else {
                propGetter.getGroovyScript(rr, false);
            }
        }
        finally {
            rr.startLine("//===================================");
        }
    }

    public void build() throws Exception {
        PrintStream traversesAllNodeOut = new PrintStream(new File("./traversesAllNode.txt"));
    }

    public File getSpringConfigFilesDir() {
        return new File(StreamContextConstant.getStreamScriptRootDir(this.collectionName, this.timestamp), "scriptconfig");
    }

    private MapDataMethodCreator addMapDataMethodCreator(EntityName entityName, TisGroupBy groups, Set<String> relevantCols) {
        MapDataMethodCreator creator = this.mapDataMethodCreatorMap.get(entityName);
        if (creator == null) {
            creator = new MapDataMethodCreator(entityName, groups, this.streamIncrGenerateStrategy, relevantCols);
            this.mapDataMethodCreatorMap.put(entityName, creator);
        }
        return creator;
    }

    private void generateCreateGroupResultScript(FuncFormat rr, PropGetter propGetter, TisGroupBy groups) {
        if (propGetter.isLastFunctInChain()) {
            rr.startLine("var result:Any = null");
        }
        final AtomicBoolean hasBreak = new AtomicBoolean();
        rr.startLine(new IBlockToString(){

            public String toString() {
                return hasBreak.get() ? "breakable {" : "";
            }
        });
        rr.methodBody("for ((k:GroupKey, v:GroupValues)  <- " + groups.getGroupAggrgationName() + ")", r -> {
            PropGetter pgetter = propGetter;
            if (propGetter.isLastFunctInChain()) {
                rr.startLine("result = ");
                hasBreak.set(true);
                propGetter.getGroovyScript(rr, true);
                rr.startLine("break");
                rr.returnLine();
            } else {
                boolean shallCallableProcess;
                PropGetter prev;
                for (prev = propGetter.getPrev(); prev != null && !(prev.getTupleCreator() instanceof FunctionDataTupleCreator); prev = prev.getPrev()) {
                }
                boolean bl = shallCallableProcess = prev != null && prev.shallCallableProcess();
                if (shallCallableProcess) {
                    rr.startLine("putMediaResult(\"" + pgetter.getOutputColName().getAliasName() + "\", //");
                } else {
                    rr.startLine("v.putMediaData( // \n");
                    rr.startLine("\"").append((Object)propGetter.getOutputColName().getAliasName()).append((Object)"\" // \n");
                    rr.startLine(", //\n");
                }
                propGetter.getGroovyScript(rr, true);
                if (shallCallableProcess) {
                    rr.startLine(") // end putMediaResult");
                    hasBreak.set(true);
                    rr.startLine("break");
                } else {
                    rr.startLine(") // end putMediaData\n");
                }
            }
        });
        rr.startLine(new IBlockToString(){

            public String toString() {
                return hasBreak.get() ? "} //end breakable" : "";
            }
        });
        if (propGetter.isLastFunctInChain()) {
            rr.startLine(" result //return");
        }
        rr.returnLine();
    }

    private VelocityContext createContext(MergeData mergeData) {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("config", (Object)mergeData);
        return velocityContext;
    }

    private void mergeGenerate(MergeData mergeData) {
        this.mergeGenerate(mergeData, "/com/qlangtech/tis/classtpl/mq_listener_scala.vm", this.getIncrScriptMainFile());
    }

    private void mergeGenerate(MergeData mergeData, String vmClasspath, File createdFile) {
        OutputStreamWriter writer = null;
        try {
            VelocityContext context = this.createContext(mergeData);
            FileUtils.forceMkdir((File)this.incrScriptDir);
            writer = new OutputStreamWriter((OutputStream)FileUtils.openOutputStream((File)createdFile), TisUTF8.get());
            Template tpl = velocityEngine.getTemplate(vmClasspath, TisUTF8.getName());
            tpl.merge((Context)context, (Writer)writer);
            writer.flush();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public final File getIncrScriptMainFile() {
        return new File(this.incrScriptDir, StreamComponentCodeGenerator.getIncrScriptClassName(this.collectionName) + ".scala");
    }

    public static String getIncrScriptClassName(String appname) {
        return UnderlineUtils.getJavaName((String)appname) + "Listener";
    }

    static {
        try {
            velocityEngine = new VelocityEngine();
            Properties prop = new Properties();
            prop.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogChute");
            prop.setProperty("resource.loader", "classpath");
            prop.setProperty("classpath.resource.loader.class", ClasspathResourceLoader.class.getName());
            velocityEngine.init(prop);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

