/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.stream.generate;

import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.incr.StreamContextConstant;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class StreamCodeContext {
    protected final String collectionName;
    protected final long timestamp;
    protected final File incrScriptDir;
    protected final boolean incrScriptDirCreated;

    public StreamCodeContext(DataXName collectionName, long timestamp) {
        this.collectionName = collectionName.getPipelineName();
        this.timestamp = timestamp;
        try {
            this.incrScriptDir = StreamCodeContext.getScalaStreamScriptDir(this.collectionName, this.timestamp);
            this.incrScriptDirCreated = this.incrScriptDir.exists();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public File getIncrScriptDir() {
        return this.incrScriptDir;
    }

    public boolean isIncrScriptDirCreated() {
        return this.incrScriptDirCreated;
    }

    public static File getScalaStreamScriptDir(String collectionName, long timestamp) throws Exception {
        File dir = new File(StreamContextConstant.getStreamScriptRootDir(collectionName, timestamp), "/src/main/scala/" + StringUtils.replace((String)Config.getGenerateParentPackage(), (String)".", (String)"/") + "/" + collectionName);
        return dir;
    }
}

