/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.stream.generate;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qlangtech.tis.datax.TableAlias;
import com.qlangtech.tis.sql.parser.er.IERRules;
import com.qlangtech.tis.sql.parser.er.PrimaryTableMeta;
import com.qlangtech.tis.sql.parser.er.TabFieldProcessor;
import com.qlangtech.tis.sql.parser.er.TableRelation;
import com.qlangtech.tis.sql.parser.stream.generate.FacadeContext;
import com.qlangtech.tis.sql.parser.stream.generate.FlatTableRelation;
import com.qlangtech.tis.sql.parser.stream.generate.MapDataMethodCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.sql.parser.tuple.creator.IStreamIncrGenerateStrategy;
import com.qlangtech.tis.sql.parser.visitor.IBlockToString;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MergeData
implements IStreamIncrGenerateStrategy.IStreamTemplateData {
    private final String collection;
    private final IStreamIncrGenerateStrategy streamIncrGenerateStrategy;
    private final Map<EntityName, MapDataMethodCreator> mapDataMethodCreatorMap;
    private final List<TableAlias> tabTriggers;
    private final List<FacadeContext> facadeContextList;
    private final Set<PrimaryTableMeta> primaryTableNames;
    private final IERRules erRules;
    private final Map<String, IBlockToString> globalScripts = Maps.newHashMap();
    private final Stack<FlatTableRelation> unprocessedTableRelations = new Stack();

    public MergeData(String collection, Map<EntityName, MapDataMethodCreator> mapDataMethodCreatorMap, List<TableAlias> tabTriggers, IERRules erRules, List<FacadeContext> facadeContextList, IStreamIncrGenerateStrategy streamIncrGenerateStrategy) {
        this.streamIncrGenerateStrategy = streamIncrGenerateStrategy;
        this.collection = collection;
        this.mapDataMethodCreatorMap = mapDataMethodCreatorMap;
        this.tabTriggers = tabTriggers;
        if (facadeContextList == null) {
            throw new IllegalArgumentException("param facadeContextList can not be null");
        }
        this.facadeContextList = facadeContextList;
        this.erRules = erRules;
        Objects.requireNonNull(erRules, "erRules can not be null");
        List<PrimaryTableMeta> primaryTabs = this.erRules.getPrimaryTabs();
        HashSet primaryTablesName = Sets.newHashSet(primaryTabs);
        if (primaryTablesName.size() < 1) {
            throw new IllegalStateException("primaryTableName is not illegal");
        }
        this.primaryTableNames = primaryTablesName;
    }

    public boolean isFacadeDAOSupport() {
        return !this.streamIncrGenerateStrategy.isExcludeFacadeDAOSupport();
    }

    public void pushRel(TableRelation rel, boolean child2Parent) {
        System.out.println(rel.toString() + ",child2Parent" + child2Parent + "=====================");
        this.unprocessedTableRelations.push(new FlatTableRelation(rel, child2Parent));
    }

    public List<TabFieldProcessor> getTabFieldProcessors() {
        return this.erRules.getTabFieldProcessors();
    }

    public Stack<FlatTableRelation> getUnprocessedTableRelations() {
        return this.unprocessedTableRelations;
    }

    public void addGlobalScript(String methodToken, IBlockToString script) {
        this.globalScripts.put(methodToken, script);
    }

    public Collection<IBlockToString> getGlobalScripts() {
        return this.globalScripts.values();
    }

    public Optional<TableRelation> getFirstParent(String tabName) {
        return this.erRules.getFirstParent(tabName);
    }

    public List<TableRelation> getChildTabReference(String tabName) {
        return this.erRules.getChildTabReference(EntityName.parse((String)tabName));
    }

    public Set<PrimaryTableMeta> getPrimaryTableNames() {
        return this.primaryTableNames;
    }

    public String getPTableDBPKName(String tabName) {
        Optional<PrimaryTableMeta> p = this.getPrimaryTableMetaOption(tabName);
        if (!p.isPresent()) {
            throw new IllegalStateException("tabName:" + tabName + " is not one of the primayTab");
        }
        PrimaryTableMeta ptabMeta = p.get();
        return ptabMeta.getDBPrimayKeyName().getName();
    }

    public String getPTableRouterKeysName(String tabName) {
        Optional<PrimaryTableMeta> p = this.getPrimaryTableMetaOption(tabName);
        if (!p.isPresent()) {
            throw new IllegalStateException("tabName:" + tabName + " is not one of the primayTab");
        }
        return p.get().createPKPlayloadParams(new FlatTableRelation[0]).toString();
    }

    public boolean isPrimaryTable(String tabName) {
        Optional<PrimaryTableMeta> p = this.getPrimaryTableMetaOption(tabName);
        return p.isPresent();
    }

    private Optional<PrimaryTableMeta> getPrimaryTableMetaOption(String tabName) {
        return this.primaryTableNames.stream().filter(r -> StringUtils.equals((String)r.getTabName(), (String)tabName)).findFirst();
    }

    public List<FacadeContext> getFacadeContextList() {
        return this.facadeContextList;
    }

    public List<TableAlias> getDumpTables() {
        if (CollectionUtils.isEmpty(this.tabTriggers)) {
            throw new IllegalStateException("tabTriggers can not be empty");
        }
        return this.tabTriggers;
    }

    public String getSharedId(EntityName e) {
        Optional<PrimaryTableMeta> ptmeta = this.getPrimaryTableMetaOption(e.getTabName());
        if (ptmeta.isPresent()) {
            return ptmeta.get().getSharedKey();
        }
        Optional<TableRelation> firstParent = this.getFirstParent(e.getTabName());
        if (firstParent.isPresent() && (ptmeta = this.getPrimaryTableMetaOption(firstParent.get().getParent().getName())).isPresent()) {
            return ptmeta.get().getSharedKey();
        }
        List<TableRelation> childTabRefs = this.getChildTabReference(e.getTabName());
        for (TableRelation childRef : childTabRefs) {
            ptmeta = this.getPrimaryTableMetaOption(childRef.getChild().getName());
            if (!ptmeta.isPresent()) continue;
            return ptmeta.get().getSharedKey();
        }
        throw new IllegalStateException("can not find shareId with table:" + e.getTabName());
    }

    public boolean isTriggerIgnore(EntityName entityName) {
        return this.erRules.isTriggerIgnore(entityName);
    }

    public Collection<MapDataMethodCreator> getMapDataMethodCreatorList() {
        return this.mapDataMethodCreatorMap.values();
    }

    public Collection<EntityName> getEntitiesList() {
        return this.mapDataMethodCreatorMap.keySet();
    }

    public String getCollection() {
        return this.collection;
    }
}

