/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.stream.generate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.qlangtech.tis.sql.parser.TisGroupBy;
import com.qlangtech.tis.sql.parser.er.IERRules;
import com.qlangtech.tis.sql.parser.er.JoinerKey;
import com.qlangtech.tis.sql.parser.er.LinkKeys;
import com.qlangtech.tis.sql.parser.er.PrimaryTableMeta;
import com.qlangtech.tis.sql.parser.er.TabCardinality;
import com.qlangtech.tis.sql.parser.er.TableRelation;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.sql.parser.tuple.creator.IStreamIncrGenerateStrategy;
import com.qlangtech.tis.sql.parser.visitor.FuncFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class MapDataMethodCreator {
    private final EntityName entityName;
    private final TisGroupBy groups;
    private final Set<String> relefantCols;
    private final IStreamIncrGenerateStrategy streamIncrGenerateStrategy;

    public MapDataMethodCreator(EntityName entityName, TisGroupBy groups, IStreamIncrGenerateStrategy streamIncrGenerateStrategy, Set<String> relefantCols) {
        this.entityName = entityName;
        this.groups = groups;
        this.relefantCols = relefantCols;
        this.streamIncrGenerateStrategy = streamIncrGenerateStrategy;
    }

    public String getMapDataMethodName() {
        return "map" + this.entityName.capitalizeEntityName() + "Data";
    }

    public String getGenerateMapDataMethodBody() {
        IERRules erRule = null;
        FuncFormat funcFormat = new FuncFormat();
        funcFormat.appendLine("val " + this.entityName.entities() + "ThreadLocal : ThreadLocal[Map[GroupKey, GroupValues]]  = addThreadLocalVal()");
        funcFormat.returnLine();
        funcFormat.methodBody("private def " + this.getMapDataMethodName() + "( " + this.entityName.getJavaEntityName() + " : IRowValueGetter) : scala.collection.mutable.Map[GroupKey, GroupValues] =", r -> {
            r.startLine((Object)("var result :scala.collection.mutable.Map[GroupKey, GroupValues] = " + this.entityName.entities() + "ThreadLocal.get()"));
            r.startLine((Object)this.entityName.buildDefineRowMapListLiteria());
            r.methodBody((Object)"if (result != null)", m -> m.appendLine((Object)" return result"));
            if (this.groups.getGroups().size() < 1) {
                throw new IllegalStateException("groups.getGroups().size() can not small than 1");
            }
            TableRelation parentRel = null;
            Optional<PrimaryTableMeta> ptab = erRule.isPrimaryTable(this.entityName.getTabName());
            if (ptab.isPresent()) {
                PrimaryTableMeta p = ptab.get();
                parentRel = new TableRelation();
                parentRel.setCardinality(TabCardinality.ONE_N.getToken());
                parentRel.setJoinerKeys(p.getPrimaryKeyNames().stream().map(rr -> new JoinerKey(rr.getName(), rr.getName())).collect(Collectors.toList()));
            } else {
                Optional<TableRelation> firstParentRel = erRule.getFirstParent(this.entityName.getTabName());
                if (!firstParentRel.isPresent()) {
                    throw new IllegalStateException("first parent table can not be null ,child table:" + this.entityName);
                }
                parentRel = firstParentRel.get();
            }
            if (!parentRel.isCardinalityEqual(TabCardinality.ONE_N)) {
                throw new IllegalStateException("rel" + parentRel + " execute aggreate mush be an rel cardinality:" + TabCardinality.ONE_N);
            }
            ArrayList linkKeys = Lists.newArrayList();
            try {
                TisGroupBy.TisColumn col = null;
                for (LinkKeys linkKey : parentRel.getCurrentTableRelation(true).getTailerKeys()) {
                    col = new TisGroupBy.TisColumn(linkKey.getHeadLinkKey());
                    linkKeys.add(col);
                    r.appendLine((Object)("val " + col.getJavaVarName() + ":String = " + this.entityName.getJavaEntityName() + ".getColumn(\"" + col.getColname() + "\")"));
                }
            }
            catch (Exception e2) {
                throw new RuntimeException(parentRel.toString(), e2);
            }
            r.appendLine((Object)this.entityName.buildDefineCriteriaEqualLiteria());
            r.startLine((Object)this.entityName.buildCreateCriteriaLiteria());
            for (TisGroupBy.TisColumn g : linkKeys) {
                r.append((Object)g.buildPropCriteriaEqualLiteria());
            }
            HashSet selCols = Sets.newHashSet();
            selCols.addAll(this.relefantCols);
            this.groups.getGroups().stream().forEach(e -> selCols.add(e.getColname()));
            r.startLine((Object)this.entityName.buildAddSelectorColsLiteria((Set)selCols));
            r.startLine((Object)this.entityName.buildExecuteQueryDAOLiteria());
            r.startLine((Object)"result = scala.collection.mutable.Map[GroupKey, GroupValues]()");
            r.startLine((Object)"var vals : Option[GroupValues] = null");
            r.startLine((Object)"var groupKey: GroupKey = null");
            r.buildRowMapTraverseLiteria(this.entityName, m -> {
                m.startLine((Object)"groupKey = GroupKey.createCacheKey(").append((Object)this.groups.getGroups().stream().map(rr -> "\"" + rr.getColname() + "\",r.getColumn(\"" + rr.getColname() + "\")").collect(Collectors.joining(",")));
                m.append((Object)")").returnLine();
                m.appendLine((Object)"vals = result.get(groupKey)");
                m.appendLine((Object)"if (vals.isEmpty) {");
                m.appendLine((Object)"  result +=(groupKey.clone() -> new GroupValues(r)) ");
                m.appendLine((Object)"}else{");
                m.appendLine((Object)" vals.get.addVal(r)");
                m.appendLine((Object)"}");
            });
            r.appendLine((Object)(this.entityName.entities() + "ThreadLocal.set(result);"));
            r.appendLine((Object)"return result;");
        });
        return funcFormat.toString();
    }
}

