/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.stream.generate;

import com.qlangtech.tis.sql.parser.TisGroupBy;
import com.qlangtech.tis.sql.parser.er.LinkKeys;
import com.qlangtech.tis.sql.parser.er.PrimaryTableMeta;
import com.qlangtech.tis.sql.parser.er.TabCardinality;
import com.qlangtech.tis.sql.parser.er.TableRelation;
import com.qlangtech.tis.sql.parser.meta.DependencyNode;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.sql.parser.visitor.FuncFormat;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class FlatTableRelation {
    private final TableRelation rel;
    private final boolean child2Parent;
    private EntityName headerEntity;
    private EntityName tailerEntity;

    public FlatTableRelation(TableRelation rel, boolean child2Parent) {
        this.rel = rel;
        this.child2Parent = child2Parent;
    }

    public TableRelation getRel() {
        return this.rel;
    }

    public boolean isChild2Parent() {
        return this.child2Parent;
    }

    private String buildQueryHeaderByTailerInfoMethodName() {
        EntityName tailerEntity = this.getTailerEntity();
        EntityName headEntity = this.getHeaderEntity();
        return "query" + headEntity.javaPropTableName() + "By" + tailerEntity.javaPropTableName();
    }

    public FuncFormat buildQueryHeaderByTailerInfo(Set<String> extraHeaderColKeys) {
        EntityName tailerEntity = this.getTailerEntity();
        EntityName headEntity = this.getHeaderEntity();
        String methodToken = "private def " + this.buildQueryHeaderByTailerInfoMethodName() + "(" + this.getJoinerKeysQueryMethodParamsLiteria() + ") : " + (this.isHeaderMulti() ? "List[RowMap]" : "RowMap") + " =";
        FuncFormat r = new FuncFormat();
        r.methodBody(methodToken, m -> {
            m.startLine((Object)headEntity.buildDefineRowMapListLiteria());
            m.startLine((Object)headEntity.buildDefineCriteriaEqualLiteria());
            m.returnLine();
            m.startLine((Object)headEntity.buildCreateCriteriaLiteria());
            this.getHeaderKeys().stream().forEach(mm -> {
                TisGroupBy.TisColumn col = new TisGroupBy.TisColumn(mm.getHeadLinkKey());
                m.append((Object)col.buildPropCriteriaEqualLiteria());
            });
            Set selCols = this.getHeaderKeys().stream().map(link -> link.getHeadLinkKey()).collect(Collectors.toSet());
            selCols.addAll(extraHeaderColKeys);
            m.startLine((Object)headEntity.buildAddSelectorColsLiteria(selCols));
            m.startLine((Object)headEntity.buildExecuteQueryDAOLiteria());
            if (this.isHeaderMulti()) {
                m.startLine((Object)("return " + headEntity.entities()));
            } else {
                m.methodBody((Object)("for ( ( r:RowMap) <- " + headEntity.entities() + ".asScala)"), rt -> rt.startLine((Object)"return r"));
                m.startLine((Object)"null");
            }
        });
        return r;
    }

    public FuncFormat buildInvokeQueryHeaderByTailerInfo() {
        FuncFormat r = new FuncFormat();
        String paramsList = this.getHeaderKeys().stream().map(m -> {
            TisGroupBy.TisColumn col = new TisGroupBy.TisColumn(m.getHeadLinkKey());
            r.appendLine("val " + col.getJavaVarName() + " = row.getColumn(\"" + m.getTailerLinkKey() + "\")");
            return col.getJavaVarName();
        }).collect(Collectors.joining(","));
        EntityName headerEntity = this.getHeaderEntity();
        r.startLine("val " + (this.isHeaderMulti() ? headerEntity.entities() + ": List[RowMap] " : headerEntity.getJavaEntityName() + ": RowMap ") + " = this." + this.buildQueryHeaderByTailerInfoMethodName() + "(" + paramsList + ") ");
        return r;
    }

    public FuncFormat buildInvokeQueryHeaderByTailerInfoResultProcess(PrimaryTableMeta primary, FlatTableRelation preTableRelation) {
        FuncFormat f = new FuncFormat();
        EntityName headerEntity = this.getHeaderEntity();
        f.appendLine("val " + headerEntity.getJavaEntityName() + "Meta : AliasList = tabColumnMetaMap.get(\"" + headerEntity.getTabName() + "\");");
        String createCompositePKLiteria = primary.createCompositePK(headerEntity.getJavaEntityName() + "Meta", this.isHeaderMulti() ? "r" : headerEntity.getJavaEntityName(), true, preTableRelation);
        if (this.isHeaderMulti()) {
            f.buildRowMapTraverseLiteria(headerEntity, mm -> mm.startLine((Object)("pushPojo2Queue(" + createCompositePKLiteria + ", row)")).append((Object)"/*gencode3*/"));
        } else {
            f.methodBody("if(" + headerEntity.getJavaEntityName() + " != null)", mm -> mm.startLine((Object)("return " + createCompositePKLiteria)).append((Object)"/*gencode4*/"));
        }
        f.startLine(" null");
        return f;
    }

    private String buidQueryHeaderByTailerInfoReturnValName() {
        return this.isHeaderMulti() ? this.getHeaderEntity().entities() : this.getHeaderEntity().getJavaEntityName();
    }

    public boolean isLinkable(FlatTableRelation next) {
        EntityName nextEntityName;
        DependencyNode currForeig = this.getTailer();
        DependencyNode nextPrimary = next.getHeader();
        EntityName currEntityName = currForeig.parseEntityName();
        if (!currEntityName.equals((Object)(nextEntityName = nextPrimary.parseEntityName()))) {
            throw new IllegalStateException("curr foreign:" + currEntityName + " next primary:" + nextEntityName + "  must be equal");
        }
        return CollectionUtils.isEqualCollection((Collection)this.getTailerKeys().stream().map(r -> r.getHeadLinkKey()).collect(Collectors.toList()), (Collection)next.getHeaderKeys().stream().map(r -> r.getHeadLinkKey()).collect(Collectors.toList()));
    }

    public TableRelation.FinalLinkKey getFinalLinkKey(PrimaryTableMeta primary, FlatTableRelation next) {
        TableRelation.FinalLinkKey currFinalLinkKey = FlatTableRelation.getFinalLinkKey(primary.getDBPrimayKeyName().getName(), this, next);
        return currFinalLinkKey;
    }

    public static TableRelation.FinalLinkKey getFinalLinkKey(String primaryColName, FlatTableRelation ... tabRels) {
        for (FlatTableRelation tabRel : tabRels) {
            String tmpPrimaryColName = primaryColName;
            Optional<LinkKeys> headerLinkKey = tabRel.getHeaderKeys().stream().filter(r -> StringUtils.equals((String)r.getHeadLinkKey(), (String)tmpPrimaryColName)).findFirst();
            if (!headerLinkKey.isPresent()) {
                return new TableRelation.FinalLinkKey(false, primaryColName, tabRel);
            }
            primaryColName = headerLinkKey.get().getTailerLinkKey();
        }
        return new TableRelation.FinalLinkKey(primaryColName);
    }

    private DependencyNode getHeader() {
        return this.child2Parent ? this.rel.getParent() : this.rel.getChild();
    }

    public EntityName getHeaderEntity() {
        if (this.headerEntity == null) {
            this.headerEntity = this.getHeader().parseEntityName();
        }
        return this.headerEntity;
    }

    public EntityName getTailerEntity() {
        if (this.tailerEntity == null) {
            this.tailerEntity = this.getTailer().parseEntityName();
        }
        return this.tailerEntity;
    }

    public String toString() {
        return "header:" + this.getHeaderEntity() + ",tailer:" + this.getTailerEntity();
    }

    public boolean isHeaderMulti() {
        if (this.rel.isCardinalityEqual(TabCardinality.ONE_ONE)) {
            return false;
        }
        if (this.rel.isCardinalityEqual(TabCardinality.ONE_N)) {
            return !this.child2Parent;
        }
        throw new IllegalStateException("un recgnize carinality " + this.rel.getCardinality());
    }

    public String getJoinerKeysQueryMethodParamsLiteria() {
        String paramsList = this.getTailerKeys().stream().map(jk -> {
            TisGroupBy.TisColumn col = new TisGroupBy.TisColumn(jk.getTailerLinkKey());
            return col.getJavaVarName() + " : String";
        }).collect(Collectors.joining(","));
        return paramsList;
    }

    public final String getJoinerKeysQueryMethodToken() {
        String methodToken = "private def query" + this.getHeader().parseEntityName().javaPropTableName() + "By" + this.getTailer().parseEntityName().javaPropTableName() + "(" + this.getJoinerKeysQueryMethodParamsLiteria() + ") : " + (this.isHeaderMulti() ? "List[RowMap]" : "RowMap") + " =";
        return methodToken;
    }

    public List<LinkKeys> getHeaderKeys() {
        return this.getLinkKeys(!this.child2Parent);
    }

    public List<LinkKeys> getTailerKeys() {
        return this.getLinkKeys(this.child2Parent);
    }

    private List<LinkKeys> getLinkKeys(boolean child2Parent) {
        return this.rel.getJoinerKeys().stream().map(r -> child2Parent ? new LinkKeys(r.getChildKey(), r.getParentKey()) : new LinkKeys(r.getParentKey(), r.getChildKey())).collect(Collectors.toList());
    }

    private DependencyNode getTailer() {
        return this.child2Parent ? this.rel.getChild() : this.rel.getParent();
    }
}

