/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.er;

import com.google.common.collect.Lists;
import com.qlangtech.tis.sql.parser.TisGroupBy;
import com.qlangtech.tis.sql.parser.er.JoinerKey;
import com.qlangtech.tis.sql.parser.er.LinkKeys;
import com.qlangtech.tis.sql.parser.er.PrimaryTableMeta;
import com.qlangtech.tis.sql.parser.er.TabCardinality;
import com.qlangtech.tis.sql.parser.meta.DependencyNode;
import com.qlangtech.tis.sql.parser.meta.PrimaryLinkKey;
import com.qlangtech.tis.sql.parser.stream.generate.FlatTableRelation;
import com.qlangtech.tis.sql.parser.stream.generate.MergeData;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.sql.parser.visitor.FuncFormat;
import com.qlangtech.tis.sql.parser.visitor.IBlockToString;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class TableRelation {
    private DependencyNode parent;
    private DependencyNode child;
    private List<JoinerKey> joinerKeys = Lists.newArrayList();
    private TabCardinality cardinality;
    private String id;

    public TableRelation(String id, DependencyNode parent, DependencyNode child, TabCardinality cardinality) {
        this.id = id;
        this.parent = parent;
        this.child = child;
        this.cardinality = cardinality;
        if (parent == null) {
            throw new IllegalArgumentException("param parent can not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("param child can not be null");
        }
        if (cardinality == null) {
            throw new IllegalArgumentException("param cardinality can not be null");
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TableRelation() {
    }

    public TableRelation addJoinerKey(JoinerKey joinerKey) {
        this.joinerKeys.add(joinerKey);
        return this;
    }

    public TableRelation addJoinerKey(String parentKey, String childKey) {
        return this.addJoinerKey(new JoinerKey(parentKey, childKey));
    }

    public TableRelation addJoinerKey(String joinKey) {
        return this.addJoinerKey(new JoinerKey(joinKey, joinKey));
    }

    public DependencyNode getParent() {
        return this.parent;
    }

    public DependencyNode getChild() {
        return this.child;
    }

    public String getCardinality() {
        return this.cardinality.getToken();
    }

    public void setCardinality(String val) {
        this.cardinality = TabCardinality.parse(val);
    }

    public boolean isCardinalityEqual(TabCardinality cardinality) {
        return cardinality == this.cardinality;
    }

    public void setParent(DependencyNode parent) {
        this.parent = parent;
    }

    public void setChild(DependencyNode child) {
        this.child = child;
    }

    public List<JoinerKey> getJoinerKeys() {
        return this.joinerKeys;
    }

    public void setJoinerKeys(List<JoinerKey> joinerKeys) {
        this.joinerKeys = joinerKeys;
    }

    public String createParentPKLiteria(MergeData context) {
        Stack<FlatTableRelation> unprocessed = context.getUnprocessedTableRelations();
        FlatTableRelation un = null;
        try {
            Object object;
            FlatTableRelation currentTableRelation = this.getCurrentTableRelation(true);
            PrimaryTableMeta primary = this.getPrimaryTableMeta(context, currentTableRelation.getHeaderEntity());
            LinkKeys pkJoinerKey = null;
            for (LinkKeys lk : currentTableRelation.getHeaderKeys()) {
                if (!StringUtils.equals((String)lk.getHeadLinkKey(), (String)primary.getDBPrimayKeyName().getName())) continue;
                pkJoinerKey = lk;
            }
            if (!unprocessed.empty()) {
                Object object2;
                un = unprocessed.pop();
                if (!unprocessed.empty()) {
                    throw new IllegalStateException("un process rel can not exceed 2,but now size:" + unprocessed.size() + "pre:" + un.toString() + ",others:" + unprocessed.stream().map(r -> r.toString()).collect(Collectors.joining(",")));
                }
                if (currentTableRelation.isLinkable(un)) {
                    object2 = primary.createCompositePK(currentTableRelation, un) + "/*gencode1*/";
                    return object2;
                }
                object2 = this.createSelectParentByChild(context, currentTableRelation, un, primary);
                return object2;
            }
            FinalLinkKey finalLinkKey = FlatTableRelation.getFinalLinkKey(primary.getDBPrimayKeyName().getName(), currentTableRelation);
            if (finalLinkKey.success) {
                object = "return " + primary.createCompositePK(currentTableRelation) + "/*gencode2*/";
                return object;
            }
            object = this.createSelectParentByChild(context, currentTableRelation, currentTableRelation, primary);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("parent:" + this.getParent().parseEntityName() + ",child:" + this.getChild().parseEntityName(), e);
        }
        finally {
            context.getUnprocessedTableRelations().clear();
        }
    }

    public FlatTableRelation getCurrentTableRelation(boolean child2Parent) {
        return new FlatTableRelation(this, child2Parent);
    }

    public String createSelectParentByChild(MergeData context, FlatTableRelation currentTableRelation, FlatTableRelation nextRelation, PrimaryTableMeta primary) {
        String methodToken = nextRelation.getJoinerKeysQueryMethodToken();
        context.addGlobalScript(methodToken, (IBlockToString)nextRelation.buildQueryHeaderByTailerInfo(currentTableRelation.getTailerKeys().stream().map(rr -> rr.getHeadLinkKey()).collect(Collectors.toSet())));
        FuncFormat f = nextRelation.buildInvokeQueryHeaderByTailerInfo();
        FuncFormat p = nextRelation.buildInvokeQueryHeaderByTailerInfoResultProcess(primary, currentTableRelation);
        f.appendLine((Object)p);
        return f.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createChildPKLiteria(MergeData context) {
        try {
            DependencyNode child = this.getChild();
            EntityName parentEntity = this.getParent().parseEntityName();
            EntityName childEntity = child.parseEntityName();
            PrimaryTableMeta primary = this.getPrimaryTableMeta(context, childEntity);
            FuncFormat r = new FuncFormat();
            r.startLine("// create by TableRelation.createChildPKLiteria()");
            r.startLine("val primaryColMeta = tabColumnMetaMap.get(\"" + primary.getTabName() + "\")");
            r.startLine("if (primaryColMeta == null) {");
            r.startLine("    throw new IllegalStateException(\"tableName: " + primary.getTabName() + " is not exist in tabColumnMetaMap\")");
            r.startLine("}");
            r.startLine("val pcol = primaryColMeta.getColMeta(\"" + primary.getDBPrimayKeyName().getName() + "\")");
            FlatTableRelation currentTableRelation = this.getCurrentTableRelation(false);
            String methodToken = currentTableRelation.getJoinerKeysQueryMethodToken();
            context.addGlobalScript(methodToken, (IBlockToString)currentTableRelation.buildQueryHeaderByTailerInfo(Collections.emptySet()));
            Stack<FlatTableRelation> unprocessedTableRelationStack = context.getUnprocessedTableRelations();
            String paramsList = null;
            if (!unprocessedTableRelationStack.empty()) {
                FlatTableRelation unprocessedTableRelation = unprocessedTableRelationStack.pop();
                paramsList = unprocessedTableRelation.getRel().getJoinerKeys().stream().map(m -> {
                    TisGroupBy.TisColumn col = new TisGroupBy.TisColumn(m.getParentKey());
                    r.appendLine(col.buildDefineParam());
                    return col.getJavaVarName();
                }).collect(Collectors.joining(","));
            } else {
                paramsList = this.getJoinerKeys().stream().map(m -> {
                    TisGroupBy.TisColumn col = new TisGroupBy.TisColumn(m.getParentKey());
                    r.appendLine(col.buildDefineParam());
                    return col.getJavaVarName();
                }).collect(Collectors.joining(","));
            }
            boolean isMulti = this.cardinality == TabCardinality.ONE_N;
            r.startLine("val " + (isMulti ? childEntity.entities() + ": List[RowMap] " : childEntity.getJavaEntityName() + ": RowMap ") + " = this.query" + childEntity.javaPropTableName() + "By" + parentEntity.javaPropTableName() + "(" + paramsList + ") ");
            if (isMulti) {
                r.buildRowMapTraverseLiteria(childEntity, mm -> mm.startLine((Object)("pushPojo2Queue(" + primary.createCompositePK("primaryColMeta", "r", new FlatTableRelation[0]) + ", row)")));
            } else {
                r.methodBody("if(" + childEntity.getJavaEntityName() + " != null)", mm -> mm.startLine((Object)("return " + primary.createCompositePK("primaryColMeta", childEntity.getJavaEntityName(), new FlatTableRelation[0]))));
            }
            r.startLine(" null /*gencode20200730*/");
            String string = r.toString();
            return string;
        }
        finally {
            context.getUnprocessedTableRelations().clear();
        }
    }

    private JoinerKey getPrimaryJoinerKey(PrimaryTableMeta primary, boolean parentKey) {
        String compareTabName;
        String string = compareTabName = parentKey ? this.parent.getName() : this.child.getName();
        if (!StringUtils.equals((String)primary.getTabName(), (String)compareTabName)) {
            throw new IllegalStateException("primary.getTabName:" + primary.getTabName() + " shall equal tabname:" + compareTabName);
        }
        PrimaryLinkKey dbPrimayKey = primary.getDBPrimayKeyName();
        Optional<JoinerKey> joinerKey = this.getJoinerKeys().stream().filter(r -> dbPrimayKey.getName().equals(parentKey ? r.getParentKey() : r.getChildKey())).findFirst();
        if (!joinerKey.isPresent()) {
            throw new IllegalStateException("primary table:" + primary + " can not find joiner Keys in :" + this.linkKeysToString());
        }
        return joinerKey.get();
    }

    private String linkKeysToString() {
        return this.getJoinerKeys().stream().map(r -> r.toString()).collect(Collectors.joining(","));
    }

    private PrimaryTableMeta getPrimaryTableMeta(MergeData context, EntityName tab) {
        Set<PrimaryTableMeta> primaryTabs = context.getPrimaryTableNames();
        Optional<PrimaryTableMeta> primary = primaryTabs.stream().filter(r -> StringUtils.equals((String)tab.getTabName(), (String)r.getTabName())).findFirst();
        if (!primary.isPresent()) {
            throw new IllegalStateException("table:" + tab.getTabName() + " is not one of primary tab");
        }
        return primary.get();
    }

    public String toString() {
        return "parent:" + this.getParent().parseEntityName() + ",child:" + this.getChild().parseEntityName() + ",linkKeys:" + this.linkKeysToString();
    }

    public static class FinalLinkKey {
        final boolean success;
        public final String linkKeyName;
        public final FlatTableRelation interruptedTableRelation;

        public FinalLinkKey(String linkKeyName) {
            this(true, linkKeyName, null);
        }

        public FinalLinkKey(boolean success, String linkKeyName, FlatTableRelation interruptedTableRelation) {
            this.success = success;
            this.linkKeyName = linkKeyName;
            this.interruptedTableRelation = interruptedTableRelation;
        }
    }
}

