/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.er;

import com.qlangtech.tis.sql.parser.er.TableMeta;
import com.qlangtech.tis.sql.parser.er.TableRelation;
import com.qlangtech.tis.sql.parser.meta.PrimaryLinkKey;
import com.qlangtech.tis.sql.parser.meta.TabExtraMeta;
import com.qlangtech.tis.sql.parser.stream.generate.FlatTableRelation;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class PrimaryTableMeta
extends TableMeta {
    private final List<PrimaryLinkKey> primaryKeyNames;

    public PrimaryTableMeta(String tabName, TabExtraMeta tabExtraMeta) {
        super(tabName, tabExtraMeta.getSharedKey());
        this.primaryKeyNames = tabExtraMeta.getPrimaryIndexColumnNames();
    }

    public List<PrimaryLinkKey> getPrimaryKeyNames() {
        if (this.primaryKeyNames == null) {
            throw new IllegalStateException("primaryKeyNames can not be null");
        }
        long pkCount = this.primaryKeyNames.stream().filter(r -> r.isPk()).count();
        if (pkCount != 1L) {
            throw new IllegalStateException("table:" + this.getTabName() + ",db pk shall be just one,but current is:" + pkCount);
        }
        return this.primaryKeyNames;
    }

    public boolean isPK(String colName) {
        return this.getPrimaryKeyNames().stream().filter(cname -> StringUtils.equals((String)cname.getName(), (String)colName)).count() > 0L;
    }

    public PrimaryLinkKey getDBPrimayKeyName() {
        return this.getPrimaryKeyNames().stream().filter(r -> r.isPk()).findFirst().get();
    }

    public List<PrimaryLinkKey> getPayloadRouterKeys() {
        return this.getPrimaryKeyNames().stream().filter(r -> !r.isPk()).collect(Collectors.toList());
    }

    public StringBuffer createPKPlayloadParams(FlatTableRelation ... tabRels) {
        return this.createPKPlayloadParams("row", tabRels);
    }

    public StringBuffer createPKPlayloadParams(String valToken, FlatTableRelation ... tabRels) {
        List<PrimaryLinkKey> payloadRouterKeys = this.getPayloadRouterKeys();
        StringBuffer buffer = new StringBuffer();
        for (PrimaryLinkKey routerKey : payloadRouterKeys) {
            TableRelation.FinalLinkKey finalLinkKey = FlatTableRelation.getFinalLinkKey(routerKey.getName(), tabRels);
            buffer.append(",\"").append(routerKey.getName()).append("\"," + valToken + ".getColumn(\"").append(finalLinkKey.linkKeyName).append("\")");
        }
        return buffer;
    }

    public String createCompositePK(String colTransferToken, String valToken, FlatTableRelation ... tabRels) {
        return this.createCompositePK(colTransferToken, valToken, false, tabRels);
    }

    public String createCompositePK(String colTransferToken, String valToken, boolean force, FlatTableRelation ... tabRels) {
        if (tabRels.length > 1) {
            EntityName first = tabRels[0].getHeaderEntity();
            if (!StringUtils.equals((String)first.getTabName(), (String)this.getTabName())) {
                throw new IllegalArgumentException("first table name shall be '" + this.getTabName() + "' but now is '" + first + "'");
            }
            int i = 0;
            while (i + 1 < tabRels.length) {
                if (!tabRels[i].isLinkable(tabRels[i + 1])) {
                    throw new IllegalStateException("pre:" + tabRels[i] + "\nnext:" + tabRels[i + 1] + " is not linkable");
                }
                ++i;
            }
        }
        PrimaryLinkKey pk = this.getDBPrimayKeyName();
        TableRelation.FinalLinkKey finalLinkKey = FlatTableRelation.getFinalLinkKey(pk.getName(), tabRels);
        if (force || finalLinkKey.success) {
            String pkGetterLiteria = EntityName.createColValLiteria((String)colTransferToken, (String)finalLinkKey.linkKeyName, (String)valToken);
            return " new CompositePK(" + pkGetterLiteria + " " + this.createPKPlayloadParams(valToken, tabRels).toString() + ")";
        }
        throw new IllegalStateException("header:" + finalLinkKey.interruptedTableRelation.getHeaderEntity() + ",tailer:" + finalLinkKey.interruptedTableRelation.getTailerEntity() + " can not find key:" + pk.getName() + ",cols:" + finalLinkKey.interruptedTableRelation.getHeaderKeys().stream().map(r -> "[" + r.getHeadLinkKey() + "->" + r.getTailerLinkKey() + "]").collect(Collectors.joining(",")));
    }

    public String createCompositePK(FlatTableRelation ... tabRels) {
        return this.createCompositePK("columnMeta", "row", tabRels);
    }

    public String toString() {
        return "PrimaryTableMeta{tabName='" + this.getTabName() + "', primaryKeyName='" + this.primaryKeyNames + "'}";
    }
}

