/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser.er;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.datax.StoreResourceTypeConstants;
import com.qlangtech.tis.fullbuild.indexbuild.IDumpTable;
import com.qlangtech.tis.manage.common.CenterResource;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.plugin.ds.ColumnMetaData;
import com.qlangtech.tis.plugin.ds.DBIdentity;
import com.qlangtech.tis.plugin.ds.DataSourceFactory;
import com.qlangtech.tis.plugin.ds.PostedDSProp;
import com.qlangtech.tis.sql.parser.SqlTaskNode;
import com.qlangtech.tis.sql.parser.SqlTaskNodeMeta;
import com.qlangtech.tis.sql.parser.er.IERRules;
import com.qlangtech.tis.sql.parser.er.IPrimaryTabFinder;
import com.qlangtech.tis.sql.parser.er.PrimaryTableMeta;
import com.qlangtech.tis.sql.parser.er.TabCardinality;
import com.qlangtech.tis.sql.parser.er.TabFieldProcessor;
import com.qlangtech.tis.sql.parser.er.TableMeta;
import com.qlangtech.tis.sql.parser.er.TableRelation;
import com.qlangtech.tis.sql.parser.er.TimeCharacteristic;
import com.qlangtech.tis.sql.parser.meta.DependencyNode;
import com.qlangtech.tis.sql.parser.meta.PrimaryLinkKey;
import com.qlangtech.tis.sql.parser.meta.TabExtraMeta;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class ERRules
implements IPrimaryTabFinder,
IERRules {
    public static final String ER_RULES_FILE_NAME = "er_rules.yaml";
    private static final Yaml yaml;
    private TimeCharacteristic timeCharacteristic = TimeCharacteristic.EventTime;
    private List<TableRelation> relationList = Lists.newArrayList();
    private List<DependencyNode> dumpNodes = Lists.newArrayList();
    private Map<String, DependencyNode> dumpNodesMap;
    private List<String> ignoreIncrTriggerEntities;
    private List<PrimaryTableMeta> primaryTabs;
    private List<TabFieldProcessor> processors = null;
    private Map<EntityName, TabFieldProcessor> processorMap;

    public static void createErRule(String topologyName, DependencyNode node, ColumnMetaData pkMeta) throws Exception {
        Objects.requireNonNull(pkMeta, "param pkMeta can not be null");
        node.setExtraSql(null);
        TabExtraMeta extraMeta = new TabExtraMeta();
        extraMeta.setSharedKey(pkMeta.getKey());
        extraMeta.setMonitorTrigger(true);
        ArrayList primaryIndexColumnName = Lists.newArrayList();
        PrimaryLinkKey pk = new PrimaryLinkKey();
        pk.setName(pkMeta.getKey());
        pk.setPk(true);
        primaryIndexColumnName.add(pk);
        extraMeta.setPrimaryIndexColumnNames((List)primaryIndexColumnName);
        extraMeta.setPrimaryIndexTab(true);
        node.setExtraMeta(extraMeta);
        ERRules erRules = new ERRules();
        erRules.addDumpNode(node);
        erRules.setTimeCharacteristic(TimeCharacteristic.ProcessTime);
        ERRules.write(topologyName, erRules);
    }

    public static void createDefaultErRule(SqlTaskNodeMeta.SqlDataFlowTopology topology) throws Exception {
        DependencyNode dumpNode = topology.getFirstDumpNode();
        DataSourceFactory dsStore = TIS.getDataBasePlugin((PostedDSProp)new PostedDSProp(DBIdentity.parseId((String)dumpNode.getDbName())));
        List cols = dsStore.getTableMetadata(false, null, dumpNode.parseEntityName());
        Optional<ColumnMetaData> firstPK = cols.stream().filter(col -> col.isPk()).findFirst();
        if (!firstPK.isPresent()) {
            throw new IllegalStateException("table:" + dumpNode.parseEntityName() + " can not find relevant PK cols");
        }
        ERRules.createErRule(topology.getName(), dumpNode, firstPK.get());
    }

    private DependencyNode getDumpNode(EntityName tabName) {
        DependencyNode result;
        if (this.dumpNodesMap == null) {
            this.dumpNodesMap = this.dumpNodes.stream().collect(Collectors.toMap(r -> r.getName(), r -> r));
        }
        if ((result = this.dumpNodesMap.get(tabName.getTabName())) == null) {
            throw new IllegalStateException("can not find table:" + tabName + " in " + this.dumpNodes.stream().map(r -> String.valueOf(r.parseEntityName())).collect(Collectors.joining(",")));
        }
        return result;
    }

    public static void write(String topology, ERRules erRules) throws Exception {
        File parent = new File(SqlTaskNode.parent, topology);
        FileUtils.forceMkdir((File)parent);
        FileUtils.write((File)new File(parent, ER_RULES_FILE_NAME), (CharSequence)ERRules.serialize(erRules), (String)TisUTF8.getName(), (boolean)false);
    }

    public static boolean ruleExist(String topology) {
        return ERRules.getErRuleFile(topology).exists();
    }

    private static File getErRuleFile(String topology) {
        String topologyPath = topology + File.separator + ER_RULES_FILE_NAME;
        return (File)CenterResource.copyFromRemote2Local((String)(StoreResourceTypeConstants.getDataFlowRelativeDir() + File.separator + topologyPath), (boolean)true).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serialize(ERRules rules) {
        Yaml yaml = ERRules.yaml;
        synchronized (yaml) {
            return ERRules.yaml.dump((Object)rules);
        }
    }

    public void addDumpNode(DependencyNode node) {
        this.dumpNodes.add(node);
    }

    public List<DependencyNode> getDumpNodes() {
        return this.dumpNodes;
    }

    public void setDumpNodes(List<DependencyNode> dumpNodes) {
        this.dumpNodes = dumpNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ERRules deserialize(String rulesStr) {
        Yaml yaml = ERRules.yaml;
        synchronized (yaml) {
            return (ERRules)ERRules.yaml.loadAs(rulesStr, ERRules.class);
        }
    }

    public static Optional<ERRules> getErRule(String topology) {
        if (!ERRules.ruleExist(topology)) {
            return Optional.empty();
        }
        File erRuleFile = ERRules.getErRuleFile(topology);
        try {
            return Optional.of(ERRules.deserialize(FileUtils.readFileToString((File)erRuleFile, (Charset)TisUTF8.get())));
        }
        catch (Exception e) {
            throw new RuntimeException("topology:" + topology + ",file path:" + erRuleFile.getAbsolutePath(), e);
        }
    }

    public void setRelationList(List<TableRelation> relationList) {
        this.relationList = relationList;
    }

    public void addRelation(TableRelation relation) {
        this.relationList.add(relation);
    }

    public List<TableRelation> getRelationList() {
        return this.relationList;
    }

    @Override
    public List<TableRelation> getAllParent(EntityName entityName) {
        ArrayList parentRefs = Lists.newArrayList();
        TableRelation resultRel = null;
        for (TableRelation relation : this.getRelationList()) {
            DependencyNode child = relation.getChild();
            if (!StringUtils.equals((String)child.getName(), (String)entityName.getTabName())) continue;
            resultRel = relation;
            parentRefs.add(resultRel);
        }
        return parentRefs;
    }

    @Override
    public TimeCharacteristic getTimeCharacteristic() {
        return this.timeCharacteristic;
    }

    public void setTimeCharacteristic(TimeCharacteristic timeCharacteristic) {
        this.timeCharacteristic = timeCharacteristic;
    }

    @Override
    public Optional<PrimaryTableMeta> isPrimaryTable(String tabName) {
        List<PrimaryTableMeta> primaryTableNames = this.getPrimaryTabs();
        Optional<PrimaryTableMeta> hasPrimaryParent = primaryTableNames.stream().filter(r -> StringUtils.equals((String)tabName, (String)r.getTabName())).findFirst();
        return hasPrimaryParent;
    }

    @Override
    public Optional<TableRelation> getFirstParent(String tabName) {
        TableRelation resultRel = null;
        Object hasPrimaryParent = null;
        for (TableRelation relation : this.getRelationList()) {
            DependencyNode child = relation.getChild();
            if (!StringUtils.equals((String)child.getName(), (String)tabName)) continue;
            resultRel = relation;
            if (!this.isPrimaryTable(relation.getParent().getName()).isPresent()) continue;
            return Optional.of(relation);
        }
        if (resultRel != null) {
            return Optional.of(resultRel);
        }
        return Optional.empty();
    }

    @Override
    public List<TableRelation> getChildTabReference(EntityName tabName) {
        ArrayList childRefs = Lists.newArrayList();
        for (TableRelation relation : this.getRelationList()) {
            if (!StringUtils.equals((String)relation.getParent().getName(), (String)tabName.getTabName())) continue;
            childRefs.add(relation);
        }
        childRefs.sort((r1, r2) -> {
            Optional<TableMeta> r1p = this.getPrimaryTab((IDumpTable)r1.getChild().parseEntityName());
            Optional<TableMeta> r2p = this.getPrimaryTab((IDumpTable)r2.getChild().parseEntityName());
            return (r2p.isPresent() ? 1 : 0) - (r1p.isPresent() ? 1 : 0);
        });
        return childRefs;
    }

    @JSONField(serialize=false)
    public List<String> getIgnoreIncrTriggerEntities() {
        if (this.ignoreIncrTriggerEntities == null) {
            this.ignoreIncrTriggerEntities = this.getDumpNodes().stream().filter(d -> d.getExtraMeta() != null && !d.getExtraMeta().isMonitorTrigger()).map(d -> d.getName()).collect(Collectors.toList());
        }
        return this.ignoreIncrTriggerEntities;
    }

    @Override
    public boolean isTimestampVerColumn(EntityName tableName, String colName) {
        return StringUtils.equals((String)this.getTimestampVerColumn(tableName), (String)colName);
    }

    @Override
    public boolean hasSetTimestampVerColumn(EntityName tableName) {
        DependencyNode dumpNode = this.getDumpNode(tableName);
        TabExtraMeta extraMeta = dumpNode.getExtraMeta();
        return extraMeta == null && StringUtils.isNotEmpty((String)extraMeta.getTimeVerColName());
    }

    @Override
    public String getTimestampVerColumn(EntityName tableName) {
        if (this.isTriggerIgnore(tableName)) {
            throw new IllegalStateException("tab:" + tableName + " is not monitor in incr process");
        }
        DependencyNode dumpNode = this.getDumpNode(tableName);
        TabExtraMeta extraMeta = dumpNode.getExtraMeta();
        if (extraMeta == null || StringUtils.isEmpty((String)extraMeta.getTimeVerColName())) {
            throw new IllegalStateException("table:" + tableName + " can not find 'timeVerColName' prop");
        }
        return extraMeta.getTimeVerColName();
    }

    @Override
    @JSONField(serialize=false)
    public List<TabFieldProcessor> getTabFieldProcessors() {
        if (this.processors == null) {
            this.processors = this.getDumpNodes().stream().filter(d -> d.getExtraMeta() != null && d.getExtraMeta().getColTransfers().size() > 0).map(d -> new TabFieldProcessor(d.parseEntityName(), d.getExtraMeta().getColTransfers())).collect(Collectors.toList());
        }
        return this.processors;
    }

    @JSONField(serialize=false)
    public Map<EntityName, TabFieldProcessor> getTabFieldProcessorMap() {
        if (this.processorMap == null) {
            this.processorMap = this.getTabFieldProcessors().stream().collect(Collectors.toMap(r -> r.tabName, r -> r));
        }
        return this.processorMap;
    }

    @Override
    @JSONField(serialize=false)
    public List<PrimaryTableMeta> getPrimaryTabs() {
        if (this.primaryTabs == null) {
            this.primaryTabs = this.getDumpNodes().stream().filter(d -> d.getExtraMeta() != null && d.getExtraMeta().isPrimaryIndexTab()).map(d -> new PrimaryTableMeta(d.getName(), d.getExtraMeta())).collect(Collectors.toList());
        }
        return this.primaryTabs;
    }

    @Override
    public Optional<TableMeta> getPrimaryTab(IDumpTable entityName) {
        Optional<TableMeta> first = this.getPrimaryTabs().stream().filter(p -> StringUtils.equals((String)p.getTabName(), (String)entityName.getTableName())).map(r -> r).findFirst();
        return first;
    }

    @Override
    public boolean isTriggerIgnore(EntityName entityName) {
        return this.getIgnoreIncrTriggerEntities().contains(entityName.getTabName());
    }

    public static TableRelation $(String id, SqlTaskNodeMeta.SqlDataFlowTopology topology, String parent, String child, TabCardinality c) {
        if (StringUtils.isEmpty((String)id)) {
            throw new IllegalArgumentException("param id can not be null");
        }
        Map<String, DependencyNode> dumpNodesMap = topology.getDumpNodesMap();
        return new TableRelation(id, dumpNodesMap.get(parent), dumpNodesMap.get(child), c);
    }

    static {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setIndent(4);
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        dumperOptions.setPrettyFlow(false);
        dumperOptions.setSplitLines(true);
        dumperOptions.setLineBreak(DumperOptions.LineBreak.UNIX);
        dumperOptions.setWidth(1000000);
        yaml = new Yaml((BaseConstructor)new Constructor(new LoaderOptions()), new Representer(dumperOptions){

            protected Node representScalar(Tag tag, String value, DumperOptions.ScalarStyle style) {
                if (Tag.STR == tag && value.length() > 100) {
                    style = DumperOptions.ScalarStyle.FOLDED;
                }
                return super.representScalar(tag, value, style);
            }

            protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
                if (propertyValue == null) {
                    return null;
                }
                return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
            }
        });
        yaml.addTypeDescription(new TypeDescription(TableRelation.class, Tag.MAP, TableRelation.class));
        yaml.addTypeDescription(new TypeDescription(ERRules.class, Tag.MAP, ERRules.class));
        yaml.addTypeDescription(new TypeDescription(DependencyNode.class, Tag.MAP, DependencyNode.class));
    }
}

