/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser;

import com.google.common.collect.Lists;
import com.qlangtech.tis.realtime.transfer.UnderlineUtils;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.TableTupleCreator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class TisGroupBy {
    private List<TisGroup> groups = Lists.newArrayList();
    private TisGroup last = null;

    public boolean add(TisGroup e) {
        this.last = e;
        return this.groups.add(e);
    }

    public String getGroupsLiteria() {
        return this.linkGroupKeys(false);
    }

    public String getGroupKeyAsParamsLiteria() {
        return this.linkGroupKeys(true);
    }

    private String linkGroupKeys(boolean addQuotes) {
        return this.groups.stream().map(r -> (addQuotes ? "\"" : "") + r.getColname() + (addQuotes ? "\"" : "")).collect(Collectors.joining(","));
    }

    public String getGroupAggrgationName() {
        return this.last.getTabTuple().getEntityName().entities();
    }

    public List<TisGroup> getGroups() {
        return this.groups;
    }

    public static class TisGroup
    extends TisColumn {
        private final String tabRef;
        private TableTupleCreator tabTuple;
        boolean tupleSetted;

        public TisGroup(String tabRef, String colname) {
            super(colname);
            this.tabRef = tabRef;
        }

        public TableTupleCreator getTabTuple() {
            if (this.tabTuple == null) {
                throw new IllegalStateException("tabRef:" + this.tabRef + ",col:" + this.getColname() + " relevant tabletuple can not be null");
            }
            return this.tabTuple;
        }

        public void setTabTuple(TableTupleCreator tabTuple) {
            this.tabTuple = tabTuple;
            this.tupleSetted = true;
        }

        public boolean isTupleSetted() {
            return this.tupleSetted;
        }

        public String getTabRef() {
            return this.tabRef;
        }
    }

    public static class TisColumn {
        protected final String colname;

        public TisColumn(String colname) {
            if (StringUtils.isBlank((String)colname)) {
                throw new IllegalArgumentException("colname can not be null");
            }
            this.colname = colname;
        }

        public String getColname() {
            return this.colname;
        }

        public String getJavaVarName() {
            return UnderlineUtils.removeUnderline((String)this.colname).toString();
        }

        public String buildDefineParam() {
            return "val " + this.getJavaVarName() + " = row.getColumn(\"" + this.colname + "\")";
        }

        public String buildDefineGetPkRouterVar() {
            return "val " + this.getJavaVarName() + " = pk.getRouterVal(\"" + this.colname + "\")";
        }

        public String buildPropCriteriaEqualLiteria() {
            return this.buildPropCriteriaEqualLiteria(this.getJavaVarName());
        }

        public String buildPropCriteriaEqualLiteria(String pkVar) {
            return ".and" + StringUtils.capitalize((String)this.getJavaVarName()) + "EqualTo(" + pkVar + ")";
        }
    }
}

