/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser;

import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.WhenClause;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.common.utils.Assert;
import com.qlangtech.tis.sql.parser.ColName;
import com.qlangtech.tis.sql.parser.SqlTaskNode;
import com.qlangtech.tis.sql.parser.SqlTaskNodeMeta;
import com.qlangtech.tis.sql.parser.ValueOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;

public class TestGroupBySqlParser {
    public static void main(String[] args) throws Exception {
        List<SqlTaskNode> taskNodes = SqlTaskNodeMeta.getSqlDataFlowTopology("totalpay").parseTaskNodes();
        SqlTaskNode terminatorNode = null;
        terminatorNode.parse(true);
    }

    public void process(Query query, Rewriter rewriter) {
        QuerySpecification body = (QuerySpecification)query.getQueryBody();
        Select select = body.getSelect();
        if (body.getLimit().isPresent()) {
            // empty if block
        }
        ArrayList groupIds = Lists.newArrayList();
        Optional gby = body.getGroupBy();
        if (gby.isPresent()) {
            GroupBy group = (GroupBy)gby.get();
            for (GroupingElement ge : group.getGroupingElements()) {
                ge.enumerateGroupingSets().forEach(e -> e.stream().forEach(r -> groupIds.add(r)));
            }
        }
        Optional from = body.getFrom();
        SingleColumn single = null;
        rewriter.append("SELECT ");
        int itemSize = select.getSelectItems().size();
        int i = 0;
        for (SelectItem col : select.getSelectItems()) {
            if (col instanceof SingleColumn) {
                single = (SingleColumn)col;
                this.processExpression(single.getExpression(), rewriter);
                Optional alias = single.getAlias();
                if (alias.isPresent()) {
                    rewriter.addColumnReference(((Identifier)alias.get()).getValue(), single.getExpression(), (Optional<Relation>)from);
                    rewriter.append(" AS ").append(alias.get());
                } else {
                    DereferenceExpression deref = null;
                    if (single.getExpression() instanceof DereferenceExpression) {
                        deref = (DereferenceExpression)single.getExpression();
                        rewriter.addColumnReference(deref.getField().getValue(), (Expression)deref, (Optional<Relation>)from);
                    } else if (single.getExpression() instanceof Identifier) {
                        if (!from.isPresent()) {
                            throw new IllegalStateException("have not set from \n" + query.toString());
                        }
                        rewriter.addColumnReference(new ColName(((Identifier)single.getExpression()).getValue()), null, (Optional<Relation>)from);
                    } else {
                        throw new IllegalStateException("illegal type " + single.getExpression() + "," + single.getExpression().getClass());
                    }
                }
            }
            if (i++ >= itemSize - 1) continue;
            rewriter.append(",");
        }
        Relation rel = null;
        if (!from.isPresent()) {
            throw new IllegalStateException("have not set from \n" + query.toString());
        }
        rel = (Relation)from.get();
        rewriter.newline().append("FROM ");
        this.processRelation(rel, rewriter);
        Optional w = body.getWhere();
        Expression where = null;
        if (w.isPresent()) {
            where = (Expression)w.get();
            rewriter.newline().append("WHERE ");
            this.processExpression(where, rewriter);
        }
        for (int ii = 0; ii < groupIds.size(); ++ii) {
            this.processExpression((Expression)groupIds.get(ii), rewriter);
            if (ii >= groupIds.size() - 1) continue;
            rewriter.append(",");
        }
    }

    private void processExpression(Expression expression, Rewriter rewriter) {
        if (expression instanceof ArithmeticBinaryExpression) {
            ArithmeticBinaryExpression arithmeticBinaryExpression = (ArithmeticBinaryExpression)expression;
            rewriter.append("(");
            this.processExpression(arithmeticBinaryExpression.getLeft(), rewriter);
            ArithmeticBinaryExpression.Operator operator = arithmeticBinaryExpression.getOperator();
            rewriter.append(operator.getValue());
            this.processExpression(arithmeticBinaryExpression.getRight(), rewriter);
            rewriter.append(")");
        } else if (expression instanceof Cast) {
            Cast cast = (Cast)expression;
            rewriter.append("CAST(");
            this.processExpression(cast.getExpression(), rewriter);
            rewriter.append(",").append(cast.getType()).append(")");
        } else if (expression instanceof LogicalBinaryExpression) {
            this.process((LogicalBinaryExpression)expression, rewriter);
        } else if (expression instanceof ComparisonExpression) {
            this.process((ComparisonExpression)expression, rewriter);
        } else if (expression instanceof CoalesceExpression) {
            this.process((CoalesceExpression)expression, rewriter);
        } else if (expression instanceof FunctionCall) {
            this.process((FunctionCall)expression, rewriter);
        } else if (expression instanceof SearchedCaseExpression) {
            SearchedCaseExpression e = (SearchedCaseExpression)expression;
            this.process(e, rewriter);
        } else if (expression instanceof StringLiteral) {
            rewriter.append(expression);
        } else if (expression instanceof SubscriptExpression) {
            SubscriptExpression subscript = (SubscriptExpression)expression;
            this.processExpression(subscript.getBase(), rewriter);
            rewriter.append("[");
            this.processExpression(subscript.getIndex(), rewriter);
            rewriter.append("]");
        } else if (expression instanceof DereferenceExpression) {
            DereferenceExpression dereference = (DereferenceExpression)expression;
            this.processExpression(dereference.getBase(), rewriter);
            rewriter.append(".").append(dereference.getField());
        } else if (expression instanceof Identifier) {
            rewriter.append(expression);
        } else if (expression instanceof LongLiteral) {
            LongLiteral longLiteral = (LongLiteral)expression;
            rewriter.append(longLiteral.getValue());
        } else {
            throw new IllegalStateException("illegal:" + expression.getClass() + ",expression:" + expression + ",loc:colnum:" + ((NodeLocation)expression.getLocation().get()).getColumnNumber() + ",line:" + ((NodeLocation)expression.getLocation().get()).getLineNumber());
        }
    }

    private void process(ComparisonExpression where, Rewriter rewriter) {
        Expression left = where.getLeft();
        if (left instanceof FunctionCall) {
            this.process((FunctionCall)left, rewriter);
        } else {
            rewriter.append(left);
        }
        rewriter.append(where.getOperator().getValue()).append(where.getRight());
        TestGroupBySqlParser.popAiasedTableRelation(rewriter);
    }

    private void process(LogicalBinaryExpression where, Rewriter rewriter) {
        rewriter.append(where);
        TestGroupBySqlParser.popAiasedTableRelation(rewriter);
    }

    private void process(CoalesceExpression expression, Rewriter rewriter) {
        rewriter.append(" COALESCE(");
        int operandSize = expression.getOperands().size();
        int index = 0;
        for (Expression operand : expression.getOperands()) {
            this.processExpression(operand, rewriter);
            if (index++ >= operandSize - 1) continue;
            rewriter.append(",");
        }
        rewriter.append(")");
    }

    private void process(FunctionCall expression, Rewriter rewriter) {
        QualifiedName name = expression.getName();
        rewriter.append(name.toString()).append("(");
        List exps = expression.getArguments();
        int argsize = exps.size();
        int index = 0;
        for (Expression arg : exps) {
            this.processExpression(arg, rewriter);
            if (index++ >= argsize - 1) continue;
            rewriter.append(",");
        }
        rewriter.append(")");
    }

    private void process(SearchedCaseExpression expression, Rewriter rewriter) {
        rewriter.append("CASE ");
        for (WhenClause when : expression.getWhenClauses()) {
            rewriter.append("WHEN ");
            this.processExpression(when.getOperand(), rewriter);
            rewriter.append(" THEN ").append(when.getResult());
        }
        Optional dft = expression.getDefaultValue();
        if (dft.isPresent()) {
            rewriter.append(" ELSE ").append(dft.get());
        }
        rewriter.append(" END");
    }

    private static void popAiasedTableRelation(Rewriter rewriter) {
        AliasedRelation aliasRelation = null;
        while (!rewriter.stack.isEmpty()) {
            aliasRelation = (AliasedRelation)rewriter.stack.pop();
            rewriter.append(" AND ").append(aliasRelation.getAlias().getValue()).append(".pt='").append("201901222222").append("'");
        }
    }

    private void processRelation(Relation rel, Rewriter rewriter) {
        Table tab = null;
        Join join = null;
        JoinCriteria jc = null;
        if (rel instanceof Join) {
            join = (Join)rel;
            this.processRelation(join.getLeft(), rewriter.deeper());
            rewriter.newline();
            Join.Type t = join.getType();
            switch (t) {
                case LEFT: {
                    rewriter.append(" LEFT JOIN ");
                    break;
                }
                case RIGHT: {
                    rewriter.append(" RIGHT JOIN ");
                    break;
                }
                case INNER: {
                    rewriter.append(" INNER JOIN ");
                    break;
                }
                default: {
                    throw new IllegalStateException("join type " + t + " is not allow " + rel.getLocation().get());
                }
            }
            this.processRelation(join.getRight(), rewriter.deeper());
            if (join.getCriteria().isPresent()) {
                jc = (JoinCriteria)join.getCriteria().get();
                if (jc instanceof JoinOn) {
                    rewriter.append(" ON (");
                    Assert.assertEquals((int)1, (int)jc.getNodes().size());
                    for (Node n : jc.getNodes()) {
                        rewriter.append(n);
                    }
                    TestGroupBySqlParser.popAiasedTableRelation(rewriter);
                    rewriter.append(")");
                }
            } else {
                Assert.fail((String)("invalid type:" + jc));
            }
            return;
        }
        AliasedRelation aliasRelation = null;
        if (rel instanceof AliasedRelation) {
            aliasRelation = (AliasedRelation)rel;
            if (aliasRelation.getRelation() instanceof Table) {
                tab = (Table)aliasRelation.getRelation();
                rewriter.append(tab.getName());
                rewriter.stack.push(aliasRelation);
            } else {
                this.processRelation(aliasRelation.getRelation(), rewriter.deeper());
            }
            rewriter.append(" AS ").append(aliasRelation.getAlias().getValue());
            return;
        }
        TableSubquery subQuery = null;
        if (rel instanceof TableSubquery) {
            subQuery = (TableSubquery)rel;
            rewriter.newline().append("(");
            this.process(subQuery.getQuery(), rewriter);
            rewriter.newline().append(")");
            return;
        }
        if (rel instanceof Table) {
            Table t = (Table)rel;
            rewriter.append(t.getName());
            return;
        }
        throw new IllegalStateException("illegal:" + rel.getClass() + ",rel:" + rel + ",loc:colnum:" + ((NodeLocation)rel.getLocation().get()).getColumnNumber() + ",line:" + ((NodeLocation)rel.getLocation().get()).getLineNumber());
    }

    private static class JoinVisitor
    extends DefaultTraversalVisitor<Node, Void> {
        private Map<String, Table> aliasMap = Maps.newHashMap();

        private JoinVisitor() {
        }

        protected Node visitAliasedRelation(AliasedRelation node, Void context) {
            if (node.getRelation() instanceof Table) {
                this.aliasMap.put(node.getAlias().getValue(), (Table)node.getRelation());
                return null;
            }
            if (node.getRelation() instanceof Table) {
                this.aliasMap.put(node.getAlias().getValue(), (Table)node.getRelation());
                return null;
            }
            return (Node)super.visitAliasedRelation(node, (Object)context);
        }
    }

    private static class DereferenceVisitor
    extends DefaultTraversalVisitor<Node, Void> {
        private final Map<String, Table> fieldBaseRef = Maps.newHashMap();
        private Map<String, Table> aliasTableMap;

        public DereferenceVisitor(Map<String, Table> aliasTableMap) {
            this.aliasTableMap = aliasTableMap;
        }

        protected Node visitDereferenceExpression(DereferenceExpression node, Void context) {
            if (node.getBase() instanceof Identifier) {
                Identifier id = (Identifier)node.getBase();
                Table t = this.aliasTableMap.get(id.getValue());
                if (t == null) {
                    throw new IllegalStateException("id:" + id.getValue() + " can not find relevant table");
                }
                this.fieldBaseRef.put(node.getField().getValue(), t);
            }
            return (Node)super.visitDereferenceExpression(node, (Object)context);
        }
    }

    public static class Rewriter {
        private final StringBuffer rewriter;
        final int stackDeep;
        private final Stack<Object> stack;
        private final Map<ColName, ValueOperator> columnTracer;

        public Rewriter(StringBuffer rewriter, int stackDeep, Stack<Object> stack, Map<ColName, ValueOperator> columnTracer) {
            this.rewriter = rewriter;
            this.stackDeep = stackDeep;
            this.stack = stack;
            this.columnTracer = columnTracer;
        }

        public Rewriter newline() {
            this.rewriter.append("\n");
            for (int i = 0; i < this.stackDeep; ++i) {
                this.rewriter.append(" ");
            }
            return this;
        }

        public Rewriter append(Object content) {
            this.rewriter.append(content);
            return this;
        }

        public Rewriter deeper() {
            return new Rewriter(this.rewriter, this.stackDeep + 2, this.stack, this.columnTracer);
        }

        public Rewriter newRewriter() {
            return Rewriter.create(this.columnTracer);
        }

        public static Rewriter create(Map<ColName, ValueOperator> columnTracer) {
            return new Rewriter(new StringBuffer(), 0, new Stack<Object>(), columnTracer);
        }

        public void addColumnReference(String colName, Expression expression, Optional<Relation> from) {
            DereferenceExpression deref = null;
            if (expression instanceof DereferenceExpression) {
                deref = (DereferenceExpression)expression;
                this.addColumnReference(new ColName(deref.getField().getValue(), colName), deref.getBase(), from);
                return;
            }
            SearchedCaseExpression caseExp = null;
            if (expression instanceof SearchedCaseExpression) {
                caseExp = (SearchedCaseExpression)expression;
                ColName c = new ColName(colName);
                DereferenceVisitor dereferenceVisitor = new DereferenceVisitor(this.getAliasTable(from.get()));
                caseExp.accept((AstVisitor)dereferenceVisitor, null);
                ArrayList params = Lists.newArrayList();
                return;
            }
            throw new IllegalStateException("colName:" + colName + "," + expression.toString() + "\n" + expression.getClass());
        }

        public void addColumnReference(ColName colName, Expression expression, Optional<Relation> from) {
            if (expression instanceof Identifier) {
                return;
            }
            throw new IllegalStateException(expression.toString() + "\n" + expression.getClass());
        }

        private ValueOperator getFromTableName(ColName outputName, Identifier id, Relation rel) {
            return null;
        }

        private Map<String, Table> getAliasTable(Relation rel) {
            Table aliasRelation2;
            if (rel instanceof AliasedRelation) {
                AliasedRelation aliasRelation2 = (AliasedRelation)rel;
                return this.getAliasTable(aliasRelation2.getRelation());
            }
            if (rel instanceof Table) {
                aliasRelation2 = (Table)rel;
            }
            if (rel instanceof TableSubquery) {
                aliasRelation2 = (TableSubquery)rel;
            }
            Join join = null;
            if (rel instanceof Join) {
                join = (Join)rel;
                JoinVisitor visitor = new JoinVisitor();
                join.accept((AstVisitor)visitor, null);
                return visitor.aliasMap;
            }
            return Collections.emptyMap();
        }
    }
}

