/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.exec.ExecutePhaseRange;
import com.qlangtech.tis.fullbuild.indexbuild.IDumpTable;
import com.qlangtech.tis.fullbuild.indexbuild.IPartionableWarehouse;
import com.qlangtech.tis.fullbuild.indexbuild.ITabPartition;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.order.center.IAppSourcePipelineController;
import com.qlangtech.tis.order.center.IJoinTaskContext;
import com.qlangtech.tis.plugin.ds.ColumnMetaData;
import com.qlangtech.tis.plugin.ds.DBIdentity;
import com.qlangtech.tis.plugin.ds.DataSourceFactory;
import com.qlangtech.tis.plugin.ds.DataType;
import com.qlangtech.tis.plugin.ds.JDBCTypes;
import com.qlangtech.tis.plugin.ds.PostedDSProp;
import com.qlangtech.tis.powerjob.IDAGSessionSpec;
import com.qlangtech.tis.powerjob.IDataFlowTopology;
import com.qlangtech.tis.sql.parser.ColName;
import com.qlangtech.tis.sql.parser.DAGSessionSpec;
import com.qlangtech.tis.sql.parser.DumpNodes;
import com.qlangtech.tis.sql.parser.FormatContext;
import com.qlangtech.tis.sql.parser.IAliasTable;
import com.qlangtech.tis.sql.parser.ISqlTask;
import com.qlangtech.tis.sql.parser.SelectColsMetaGetter;
import com.qlangtech.tis.sql.parser.SqlRewriter;
import com.qlangtech.tis.sql.parser.SqlStringBuilder;
import com.qlangtech.tis.sql.parser.SqlTaskNode;
import com.qlangtech.tis.sql.parser.TabPartitions;
import com.qlangtech.tis.sql.parser.TopologyDir;
import com.qlangtech.tis.sql.parser.er.ERRules;
import com.qlangtech.tis.sql.parser.er.IPrimaryTabFinder;
import com.qlangtech.tis.sql.parser.exception.TisSqlFormatException;
import com.qlangtech.tis.sql.parser.meta.ColumnTransfer;
import com.qlangtech.tis.sql.parser.meta.DependencyNode;
import com.qlangtech.tis.sql.parser.meta.NodeType;
import com.qlangtech.tis.sql.parser.meta.Position;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.TableTupleCreator;
import com.qlangtech.tis.sql.parser.utils.DefaultDumpNodeMapContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class SqlTaskNodeMeta
implements ISqlTask {
    public static final ThreadLocal<Yaml> yaml = new ThreadLocal<Yaml>(){

        @Override
        protected Yaml initialValue() {
            DumperOptions dumperOptions = new DumperOptions();
            dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            dumperOptions.setIndent(4);
            dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
            dumperOptions.setAnchorGenerator(n -> "a");
            dumperOptions.setPrettyFlow(false);
            dumperOptions.setSplitLines(true);
            dumperOptions.setLineBreak(DumperOptions.LineBreak.UNIX);
            dumperOptions.setWidth(1000000);
            Yaml y = new Yaml((BaseConstructor)new Constructor(new LoaderOptions()), new Representer(dumperOptions){

                protected Node representScalar(Tag tag, String value, DumperOptions.ScalarStyle style) {
                    if (Tag.STR == tag && value.length() > 100) {
                        style = DumperOptions.ScalarStyle.FOLDED;
                    }
                    return super.representScalar(tag, value, style);
                }

                protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
                    if (propertyValue == null) {
                        return null;
                    }
                    if (DependencyNode.class.equals((Object)property.getType())) {
                        return null;
                    }
                    return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
                }
            }, dumperOptions);
            y.addTypeDescription(new TypeDescription(DependencyNode.class, Tag.MAP, DependencyNode.class));
            y.addTypeDescription(new TypeDescription(SqlTaskNodeMeta.class, Tag.MAP, SqlTaskNodeMeta.class));
            y.addTypeDescription(new TypeDescription(DumpNodes.class, Tag.MAP, DumpNodes.class));
            return y;
        }
    };
    private static final String FILE_NAME_DEPENDENCY_TABS = "dependency_tabs.yaml";
    private static final String FILE_NAME_PROFILE = "profile.json";
    public static final String KEY_PROFILE_TIMESTAMP = "timestamp";
    public static final String KEY_PROFILE_TOPOLOGY = "topology";
    public static final String KEY_PROFILE_ID = "id";
    private static final SqlParser sqlParser = new SqlParser();
    private String id;
    private String exportName;
    private String type;
    private Position position;
    private String sql;
    private List<DependencyNode> dependencies = Lists.newArrayList();

    public static Optional<TisSqlFormatException> validateSql(String sql, List<DependencyNode> dependencyNodes) {
        SqlTaskNodeMeta taskNodeMeta = new SqlTaskNodeMeta();
        taskNodeMeta.setSql(sql);
        DftJoinTaskContext tskContext = new DftJoinTaskContext(ExecutePhaseRange.fullRange());
        try {
            String pt = "20200703113848";
            ITabPartition p = () -> pt;
            Map<IDumpTable, ITabPartition> tabPartition = dependencyNodes.stream().collect(Collectors.toMap(r -> EntityName.parse((String)r.getName()), r -> p));
            taskNodeMeta.setDependencies(dependencyNodes);
            taskNodeMeta.getRewriteSql("testTaskName", new MockDumpPartition(tabPartition), IPartionableWarehouse.createForNoWriterForTableName(), () -> new IPrimaryTabFinder(){}, tskContext, false);
            return Optional.empty();
        }
        catch (Throwable e) {
            int indexOf = ExceptionUtils.indexOfType((Throwable)e, TisSqlFormatException.class);
            if (indexOf > -1) {
                TisSqlFormatException ex = (TisSqlFormatException)ExceptionUtils.getThrowables((Throwable)e)[indexOf];
                return Optional.of(ex);
            }
            throw e;
        }
    }

    public ISqlTask.RewriteSql getColMetaGetterSql(TabPartitions tabPartitions, IPartionableWarehouse dumpTableNameRewriter) {
        IJoinTaskContext joinContext = this.getTplContext();
        Optional<List<Expression>> parameters = Optional.empty();
        SqlStringBuilder builder = new SqlStringBuilder();
        SelectColsMetaGetter rewriter = new SelectColsMetaGetter(builder, () -> new IPrimaryTabFinder(){}, tabPartitions, this.dependencies, parameters, joinContext, dumpTableNameRewriter);
        try {
            Statement state = this.getSqlStatement();
            rewriter.process((com.facebook.presto.sql.tree.Node)state, new FormatContext(0));
        }
        catch (TisSqlFormatException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return new ISqlTask.RewriteSql(this.getSql(), builder.toString(), rewriter.outputCols, null);
    }

    private IJoinTaskContext getTplContext() {
        IJoinTaskContext taskContext = new IJoinTaskContext(){

            public String getIndexName() {
                return null;
            }

            public String getJavaMemSpec() {
                return null;
            }

            public boolean isDryRun() {
                return false;
            }

            public boolean hasIndexName() {
                return false;
            }

            public int getTaskId() {
                return 0;
            }

            public int getIndexShardCount() {
                return 1;
            }

            public <T> T getAttribute(String key) {
                return null;
            }

            public void setAttribute(String key, Object v) {
            }

            public <T> T getAttribute(String key, Supplier<T> creator) {
                return null;
            }

            public IAppSourcePipelineController getPipelineController() {
                return null;
            }

            public ExecutePhaseRange getExecutePhaseRange() {
                return ExecutePhaseRange.fullRange();
            }

            public String getString(String key) {
                return null;
            }

            public boolean getBoolean(String key) {
                return false;
            }

            public int getInt(String key) {
                return 0;
            }

            public long getLong(String key) {
                return 0L;
            }

            public long getPartitionTimestampWithMillis() {
                throw new UnsupportedOperationException();
            }
        };
        return taskContext;
    }

    public ISqlTask.RewriteSql getRewriteSql(String taskName, TabPartitions dumpPartition, IPartionableWarehouse dumpTableNameRewriter, Supplier<IPrimaryTabFinder> erRules, IJoinTaskContext joinContext, boolean isFinalNode) {
        if (dumpPartition.size() < 1) {
            throw new IllegalStateException("taskName:" + taskName + " dumpPartition set size can not small than 1");
        }
        Optional<List<Expression>> parameters = Optional.empty();
        SqlStringBuilder builder = new SqlStringBuilder();
        SqlRewriter rewriter = new SqlRewriter(builder, dumpPartition, this.dependencies, erRules, parameters, isFinalNode, joinContext, dumpTableNameRewriter);
        try {
            Statement state = this.getSqlStatement();
            rewriter.process((com.facebook.presto.sql.tree.Node)state, new FormatContext(0));
        }
        catch (TisSqlFormatException e) {
            throw e;
        }
        catch (Exception e) {
            String dp = dumpPartition.toString();
            throw new IllegalStateException("task:" + taskName + ",isfinalNode:" + isFinalNode + ",dump tabs pt:" + dp + "\n" + e.getMessage(), e);
        }
        SqlRewriter.AliasTable primaryTable = rewriter.getPrimayTable();
        if (primaryTable == null) {
            throw new IllegalStateException("task:" + taskName + " has not find primary table");
        }
        return new ISqlTask.RewriteSql(this.getSql(), builder.toString(), IDumpTable.appendPreservedPsCols((List)rewriter.outputCols), (IAliasTable)rewriter.getPrimayTable());
    }

    private Statement getSqlStatement() {
        String sql = this.getSql();
        try {
            return sqlParser.createStatement(sql, new ParsingOptions());
        }
        catch (ParsingException e) {
            throw new TisSqlFormatException(e.getErrorMessage(), Optional.of(sql), Optional.of(new NodeLocation(e.getLineNumber(), e.getColumnNumber())));
        }
    }

    public static String processBigContent(String content) {
        LineIterator lIt = null;
        String line = null;
        StringBuffer result = new StringBuffer();
        try (StringReader reader = new StringReader(SqlTaskNodeMeta.processFileContent(content));){
            lIt = IOUtils.lineIterator((Reader)reader);
            while (lIt.hasNext()) {
                line = lIt.next();
                if (!StringUtils.startsWith((String)line, (String)" ")) {
                    result.append(" ");
                }
                result.append(line).append("\n");
            }
        }
        return StringUtils.trimToEmpty((String)result.toString());
    }

    private static String processFileContent(String content) {
        return content.replace("\r\n", "\n");
    }

    public static void persistence(SqlDataFlowTopology topology, File parent) throws Exception {
        if (!parent.exists()) {
            throw new IllegalStateException("parent not exist:" + parent.getAbsolutePath());
        }
        if (topology.profile == null || StringUtils.isEmpty((String)topology.getName()) || topology.getTimestamp() < 1L || topology.getDataflowId() < 1L) {
            throw new IllegalArgumentException("param topology's prop name timestamp or dataflowid neither can be null");
        }
        Pattern PatternjoinNode = Pattern.compile("[\\da-z]+\\-[\\da-z]+\\-[\\da-z]+\\-[\\da-z]+\\-[\\da-z]+\\.yaml");
        Map<String, AtomicBoolean> oldNodeFileStats = Arrays.stream(parent.list((dir, name) -> PatternjoinNode.matcher(name).matches())).collect(Collectors.toMap(filename -> filename, filename -> new AtomicBoolean()));
        for (ISqlTask process : topology.getParseNodes()) {
            String nodeFileName = process.getId() + ".yaml";
            AtomicBoolean hasProcess = oldNodeFileStats.get(nodeFileName);
            if (hasProcess != null) {
                hasProcess.set(true);
            }
            try (OutputStreamWriter output = new OutputStreamWriter(FileUtils.openOutputStream((File)new File(parent, nodeFileName)));){
                SqlTaskNodeMeta.persistSqlTask(output, process);
            }
        }
        oldNodeFileStats.entrySet().forEach(e -> {
            if (!((AtomicBoolean)e.getValue()).get()) {
                FileUtils.deleteQuietly((File)new File(parent, (String)e.getKey()));
            }
        });
        try (OutputStreamWriter output = new OutputStreamWriter(FileUtils.openOutputStream((File)new File(parent, FILE_NAME_DEPENDENCY_TABS)));){
            yaml.get().dump((Object)new DumpNodes(topology.getDumpNodes()), (Writer)output);
        }
        output = new OutputStreamWriter((OutputStream)FileUtils.openOutputStream((File)new File(parent, FILE_NAME_PROFILE)), TisUTF8.get());
        try {
            JSONObject profile = new JSONObject();
            profile.put(KEY_PROFILE_TIMESTAMP, (Object)topology.getTimestamp());
            profile.put(KEY_PROFILE_TOPOLOGY, (Object)topology.getName());
            profile.put(KEY_PROFILE_ID, (Object)topology.getDataflowId());
            IOUtils.write((String)profile.toJSONString(), (Writer)output);
        }
        finally {
            output.close();
        }
    }

    public static void persistSqlTask(Writer writer, ISqlTask process) throws IOException {
        if (StringUtils.isEmpty((String)process.getId())) {
            throw new IllegalStateException(process.getExportName() + " relevant node property id can not be null ");
        }
        yaml.get().dump((Object)process, writer);
    }

    public static SqlDataFlowTopology getSqlDataFlowTopology(String topologyName) throws Exception {
        SqlDataFlowTopology result = SqlTaskNodeMeta.getSqlDataFlowTopology(SqlTaskNodeMeta.getTopologyDir(topologyName));
        ERRules.getErRule(topologyName);
        return result;
    }

    public static TopologyDir getTopologyDir(String topologyName) {
        if (StringUtils.isEmpty((String)topologyName)) {
            throw new IllegalArgumentException("param topologyName can not be null");
        }
        File wfDir = SqlTaskNode.parent;
        wfDir = new File(wfDir, topologyName);
        try {
            FileUtils.forceMkdir((File)wfDir);
        }
        catch (IOException e) {
            throw new RuntimeException("wfDir:" + wfDir.getAbsolutePath(), e);
        }
        return new TopologyDir(wfDir, topologyName);
    }

    public static TopologyProfile getTopologyProfile(String topologyName) throws Exception {
        TopologyDir topologyDir = SqlTaskNodeMeta.getTopologyDir(topologyName);
        return SqlTaskNodeMeta.getTopologyProfile(topologyDir.synchronizeRemoteRes(FILE_NAME_PROFILE));
    }

    public static SqlDataFlowTopology getSqlDataFlowTopology(TopologyDir topologyDir) throws Exception {
        SqlDataFlowTopology topology = new SqlDataFlowTopology();
        List<File> subFiles = topologyDir.synchronizeSubRemoteRes();
        if (subFiles.size() < 1) {
            throw new IllegalStateException("subFiles size can not small than 1,file:" + topologyDir.dir);
        }
        File dependencyTabFile = new File(topologyDir.dir, FILE_NAME_DEPENDENCY_TABS);
        if (!dependencyTabFile.exists()) {
            return topology;
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)FileUtils.openInputStream((File)dependencyTabFile), TisUTF8.get());){
            DumpNodes dumpTabs = (DumpNodes)yaml.get().loadAs((Reader)reader, DumpNodes.class);
            topology.addDumpTab(dumpTabs.getDumps());
        }
        catch (Exception e) {
            throw new RuntimeException(dependencyTabFile.getAbsolutePath(), e);
        }
        Iterator fit = FileUtils.iterateFiles((File)topologyDir.dir, (String[])new String[]{"yaml"}, (boolean)false);
        File next = null;
        while (fit.hasNext()) {
            next = (File)fit.next();
            if ("er_rules.yaml".equals(next.getName()) || FILE_NAME_DEPENDENCY_TABS.equals(next.getName())) continue;
            SqlTaskNodeMeta sqlTaskNodeMeta = SqlTaskNodeMeta.deserializeTaskNode(next);
            topology.addNodeMeta(sqlTaskNodeMeta);
        }
        topology.setProfile(SqlTaskNodeMeta.getTopologyProfile(new File(topologyDir.dir, FILE_NAME_PROFILE)));
        return topology;
    }

    public static TopologyProfile getTopologyProfile(File profileFile) throws Exception {
        if (!profileFile.exists()) {
            throw new IllegalStateException("profile not exist:" + profileFile.getAbsolutePath());
        }
        try (FileInputStream r = FileUtils.openInputStream((File)profileFile);){
            JSONObject j = JSON.parseObject((String)IOUtils.toString((InputStream)r, (Charset)TisUTF8.get()));
            TopologyProfile profile = new TopologyProfile();
            profile.setDataflowId(j.getLong(KEY_PROFILE_ID));
            profile.setName(j.getString(KEY_PROFILE_TOPOLOGY));
            profile.setTimestamp(j.getLong(KEY_PROFILE_TIMESTAMP));
            TopologyProfile topologyProfile = profile;
            return topologyProfile;
        }
    }

    public static SqlTaskNodeMeta deserializeTaskNode(File file) {
        SqlTaskNodeMeta sqlTaskNodeMeta;
        InputStreamReader scriptReader = new InputStreamReader((InputStream)FileUtils.openInputStream((File)file), TisUTF8.get());
        try {
            sqlTaskNodeMeta = SqlTaskNodeMeta.deserializeTaskNode(scriptReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)scriptReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(file.getAbsolutePath(), e);
            }
        }
        ((Reader)scriptReader).close();
        return sqlTaskNodeMeta;
    }

    public static SqlTaskNodeMeta deserializeTaskNode(Reader scriptReader) throws Exception {
        SqlTaskNodeMeta sqlTaskNodeMeta = null;
        sqlTaskNodeMeta = (SqlTaskNodeMeta)yaml.get().loadAs(scriptReader, SqlTaskNodeMeta.class);
        return sqlTaskNodeMeta;
    }

    public static SqlTaskNodeMeta deserializeTaskNode(ISqlTask.SqlTaskCfg sqlTskCfg) {
        SqlTaskNodeMeta taskNode = new SqlTaskNodeMeta();
        taskNode.setSql(sqlTskCfg.getSqlScript());
        taskNode.setId(sqlTskCfg.getId());
        taskNode.setExportName(sqlTskCfg.getExportName());
        return taskNode;
    }

    public List<DependencyNode> getDependencies() {
        return this.dependencies;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDependencies(List<DependencyNode> required) {
        this.dependencies = required;
    }

    public void addDependency(DependencyNode required) {
        this.dependencies.add(required);
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getExportName() {
        return this.exportName;
    }

    public void setExportName(String exportName) {
        this.exportName = exportName;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public String getType() {
        return this.type;
    }

    @JSONField(serialize=false)
    public NodeType getNodeType() {
        try {
            return NodeType.parse((String)this.type);
        }
        catch (NodeType.NodeTypeParseException e) {
            throw new RuntimeException(e);
        }
    }

    public void setType(String type) {
        this.type = type;
    }

    private static class DftJoinTaskContext
    implements IJoinTaskContext {
        private final ExecutePhaseRange executePhaseRange;

        public boolean isDryRun() {
            return false;
        }

        public DftJoinTaskContext(ExecutePhaseRange executePhaseRange) {
            this.executePhaseRange = executePhaseRange;
        }

        public String getJavaMemSpec() {
            return null;
        }

        public String getIndexName() {
            return null;
        }

        public boolean hasIndexName() {
            return false;
        }

        public int getTaskId() {
            return 0;
        }

        public int getIndexShardCount() {
            return 0;
        }

        public <T> T getAttribute(String key) {
            return null;
        }

        public void setAttribute(String key, Object v) {
        }

        public <T> T getAttribute(String key, Supplier<T> creator) {
            return null;
        }

        public IAppSourcePipelineController getPipelineController() {
            throw new UnsupportedOperationException();
        }

        public ExecutePhaseRange getExecutePhaseRange() {
            return this.executePhaseRange;
        }

        public String getString(String key) {
            return null;
        }

        public boolean getBoolean(String key) {
            return false;
        }

        public int getInt(String key) {
            return 0;
        }

        public long getLong(String key) {
            return 0L;
        }

        public long getPartitionTimestampWithMillis() {
            throw new UnsupportedOperationException();
        }
    }

    public static class HiveColTransfer {
        public static HiveColTransfer instance = new HiveColTransfer();

        public String transfer(String base, String field, ColumnTransfer transfer) {
            try {
                Method method = HiveColTransfer.class.getMethod(transfer.getTransfer(), String.class, String.class, ColumnTransfer.class);
                return (String)method.invoke((Object)instance, base, field, transfer);
            }
            catch (Exception e) {
                throw new RuntimeException("base:" + base + ",field:" + field + "," + transfer.toString(), e);
            }
        }

        public String dateYYYYmmdd(String base, String field, ColumnTransfer transfer) {
            String param = this.getParam(base, field, transfer);
            return "regexp_replace(" + param + ",'-','') as " + transfer.getColKey();
        }

        public String dateYYYYMMddHHmmss(String base, String field, ColumnTransfer transfer) {
            String param = this.getParam(base, field, transfer);
            return "from_unixtime(int(" + param + "), 'yyyyMMddHHmmss') as " + transfer.getColKey();
        }

        private String getParam(String base, String field, ColumnTransfer transfer) {
            return StringUtils.replace((String)transfer.getParam(), (String)"value", (String)(base + "." + field));
        }
    }

    private static class RefCountTaskNode {
        private final AtomicInteger refCount = new AtomicInteger();
        private final SqlTaskNodeMeta taskNode;

        public RefCountTaskNode(SqlTaskNodeMeta taskNode) {
            this.taskNode = taskNode;
        }

        public void incr() {
            this.refCount.incrementAndGet();
        }
    }

    public static class SqlDataFlowTopology
    implements IDataFlowTopology {
        private TopologyProfile profile = new TopologyProfile();
        private List<SqlTaskNodeMeta> nodeMetas = Lists.newArrayList();
        private List<DependencyNode> dumpNodes = Lists.newArrayList();
        private Map<String, DependencyNode> dumpNodesMap;
        private DAGSessionSpec sessionSpec;
        private List<SqlTaskNode> allNodes = null;

        public static SqlDataFlowTopology deserialize(String jsonContent) {
            return (SqlDataFlowTopology)JSON.parseObject((String)jsonContent, SqlDataFlowTopology.class);
        }

        public boolean isSingleTableModel() {
            return this.isSingleDumpTableDependency() && this.nodeMetas.size() < 1;
        }

        public boolean isSingleDumpTableDependency() {
            return this.dumpNodes.size() < 2;
        }

        @JSONField(serialize=false)
        public long getTimestamp() {
            return this.profile.getTimestamp();
        }

        @JSONField(serialize=false)
        public String getName() {
            if (this.profile == null) {
                throw new IllegalStateException("profile can not be null");
            }
            return this.profile.getName();
        }

        @JSONField(serialize=false)
        public long getDataflowId() {
            return this.profile.dataflowId;
        }

        public void setProfile(TopologyProfile profile) {
            this.profile = profile;
        }

        public TopologyProfile getProfile() {
            return this.profile;
        }

        @JSONField(serialize=false)
        public Map<String, DependencyNode> getDumpNodesMap() {
            if (this.dumpNodesMap == null) {
                this.dumpNodesMap = Maps.newHashMap();
                List<DependencyNode> dumpNodes = this.getDumpNodes();
                dumpNodes.stream().forEach(r -> {
                    this.dumpNodesMap.put(r.getName(), (DependencyNode)r);
                    r.setExtraSql(null);
                });
            }
            return this.dumpNodesMap;
        }

        @JSONField(serialize=false)
        public IDAGSessionSpec getDAGSessionSpec() {
            if (this.sessionSpec != null) {
                return this.sessionSpec;
            }
            this.sessionSpec = new DAGSessionSpec();
            for (DependencyNode dump : this.getDumpNodes()) {
                this.sessionSpec.getDpt(dump.getId());
            }
            for (SqlTaskNodeMeta pnode : this.getNodeMetas()) {
                DAGSessionSpec join = (DAGSessionSpec)this.sessionSpec.getDpt(pnode.getId());
                pnode.getDependencies().forEach(node -> join.addDpt((DAGSessionSpec)this.sessionSpec.getDpt(node.getId())));
            }
            return this.sessionSpec;
        }

        private Map<EntityName, List<TableTupleCreator>> createDumpNodesMap() {
            HashMap result = Maps.newHashMap();
            this.dumpNodes.stream().forEach(node -> {
                List tables = null;
                TableTupleCreator tupleCreator = null;
                EntityName entityName = EntityName.parse((String)(node.getDbName() + "." + node.getName()));
                tupleCreator = new TableTupleCreator(entityName.toString(), NodeType.DUMP);
                tables = (List)result.get(entityName);
                if (tables == null) {
                    tables = Lists.newArrayList();
                    result.put(entityName, tables);
                }
                tupleCreator.setRealEntityName(entityName);
                tables.add(tupleCreator);
            });
            return result;
        }

        public List<SqlTaskNode> parseTaskNodes() throws Exception {
            if (this.allNodes == null) {
                DefaultDumpNodeMapContext dumpNodsContext = new DefaultDumpNodeMapContext(this.createDumpNodesMap());
                this.allNodes = this.getNodeMetas().stream().map(m -> {
                    SqlTaskNode node = new SqlTaskNode(EntityName.parse((String)m.getExportName()), m.getNodeType(), dumpNodsContext);
                    node.setContent(m.getSql());
                    return node;
                }).collect(Collectors.toList());
                dumpNodsContext.setAllJoinNodes(this.allNodes);
            }
            return this.allNodes;
        }

        public TableTupleCreator parseFinalSqlTaskNode() throws Exception {
            SqlTaskNode task = this.getFinalTaskNode();
            return task.parse(true);
        }

        @JSONField(serialize=false)
        public List<ColumnMetaData> getFinalTaskNodeCols() throws Exception {
            if (this.isSingleTableModel()) {
                DependencyNode dumpNode = this.getDumpNodes().get(0);
                DataSourceFactory dbPlugin = TIS.getDataBasePlugin((PostedDSProp)new PostedDSProp(DBIdentity.parseId((String)dumpNode.getDbName())));
                List cols = dbPlugin.getTableMetadata(false, null, dumpNode.parseEntityName());
                return cols;
            }
            SqlTaskNode task = this.getFinalTaskNode();
            List<ColName> colNames = task.parse(false).getColsRefs().getColRefMap().keySet();
            AtomicInteger index = new AtomicInteger();
            return colNames.stream().map(c -> new ColumnMetaData(index.getAndIncrement(), c.getAliasName(), new DataType(JDBCTypes.VARCHAR), false)).collect(Collectors.toList());
        }

        private SqlTaskNode getFinalTaskNode() throws Exception {
            if (this.isSingleTableModel()) {
                DefaultDumpNodeMapContext dumpNodsContext = new DefaultDumpNodeMapContext(this.createDumpNodesMap());
                DependencyNode dumpNode = this.getFirstDumpNode();
                SqlTaskNode taskNode = new SqlTaskNode(EntityName.create((String)dumpNode.getDbName(), (String)dumpNode.getName()), NodeType.JOINER_SQL, dumpNodsContext);
                DataSourceFactory dbPlugin = TIS.getDataBasePlugin((PostedDSProp)new PostedDSProp(DBIdentity.parseId((String)dumpNode.getDbName())));
                taskNode.setContent(ColumnMetaData.buildExtractSQL((String)dumpNode.getName(), (boolean)true, (List)dbPlugin.getTableMetadata(false, null, dumpNode.parseEntityName())).toString());
                return taskNode;
            }
            List<SqlTaskNode> taskNodes = this.parseTaskNodes();
            SqlTaskNode task = null;
            String finalNodeName = this.getFinalNode().getExportName();
            Optional<SqlTaskNode> f = taskNodes.stream().filter(n -> finalNodeName.equals(n.getExportName().getTabName())).findFirst();
            if (!f.isPresent()) {
                String setStr = taskNodes.stream().map(n -> n.getExportName().getJavaEntityName()).collect(Collectors.joining(","));
                throw new IllegalStateException("finalNodeName:" + finalNodeName + " can not find node in[" + setStr + "]");
            }
            task = f.get();
            return task;
        }

        public DependencyNode getFirstDumpNode() {
            return null;
        }

        public void addNodeMeta(SqlTaskNodeMeta nodeMeta) {
            this.nodeMetas.add(nodeMeta);
        }

        public List<SqlTaskNodeMeta> getNodeMetas() {
            return this.nodeMetas;
        }

        public void addDumpTab(List<DependencyNode> ns) {
            this.dumpNodes.addAll(ns);
        }

        public void addDumpTab(DependencyNode ns) {
            this.dumpNodes.add(ns);
        }

        public void setNodeMetas(List<SqlTaskNodeMeta> nodeMetas) {
            this.nodeMetas = nodeMetas;
        }

        public void setDumpNodes(List<DependencyNode> dumpNodes) {
            this.dumpNodes = dumpNodes;
        }

        public List<ISqlTask> getParseNodes() {
            return Lists.newArrayList(this.getNodeMetas());
        }

        public List<DependencyNode> getDumpNodes() {
            return this.dumpNodes;
        }

        @JSONField(serialize=false)
        public SqlTaskNodeMeta getFinalNode() throws Exception {
            Collection<SqlTaskNodeMeta> finalNodes = this.getFinalNodes().values();
            if (finalNodes.size() != 1) {
                throw new IllegalStateException("finalNodes size must be 1,but now is:" + finalNodes.size() + ",nodes:[" + finalNodes.stream().map(r -> r.getExportName()).collect(Collectors.joining(",")) + "]");
            }
            Optional<SqlTaskNodeMeta> taskNode = finalNodes.stream().findFirst();
            if (!taskNode.isPresent()) {
                throw new IllegalStateException("final node shall be exist");
            }
            return taskNode.get();
        }

        public Map<String, SqlTaskNodeMeta> getFinalNodes() {
            HashMap exportNameRefs = Maps.newHashMap();
            for (SqlTaskNodeMeta sqlTaskNodeMeta : this.getNodeMetas()) {
                exportNameRefs.put(sqlTaskNodeMeta.getId(), new RefCountTaskNode(sqlTaskNodeMeta));
            }
            RefCountTaskNode refCount = null;
            for (SqlTaskNodeMeta meta : this.getNodeMetas()) {
                for (DependencyNode entry : meta.getDependencies()) {
                    refCount = (RefCountTaskNode)exportNameRefs.get(entry.getId());
                    if (refCount == null) continue;
                    refCount.incr();
                }
            }
            Map<String, SqlTaskNodeMeta> map = exportNameRefs.values().stream().filter(e -> e.refCount.get() < 1).map(r -> r.taskNode).collect(Collectors.toMap(n -> n.getExportName(), n -> n));
            return map;
        }
    }

    public static class TopologyProfile {
        private long timestamp;
        private String name;
        private long dataflowId;

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public long getDataflowId() {
            return this.dataflowId;
        }

        public void setDataflowId(long dataflowId) {
            this.dataflowId = dataflowId;
        }
    }

    private static class MockDumpPartition
    extends TabPartitions {
        public MockDumpPartition(Map<IDumpTable, ITabPartition> tabPartition) {
            super(tabPartition);
        }

        public int size() {
            return 2;
        }
    }
}

