/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser;

import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.TISStackableAstVisitor;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.datax.StoreResourceTypeConstants;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.plugin.ds.ColumnMetaData;
import com.qlangtech.tis.plugin.ds.DataType;
import com.qlangtech.tis.plugin.ds.JDBCTypes;
import com.qlangtech.tis.sql.parser.ColName;
import com.qlangtech.tis.sql.parser.IDumpNodeMapContext;
import com.qlangtech.tis.sql.parser.TisGroupBy;
import com.qlangtech.tis.sql.parser.meta.NodeType;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.sql.parser.tuple.creator.IDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.IDataTupleCreatorVisitor;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.ColRef;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.FunctionDataTupleCreator;
import com.qlangtech.tis.sql.parser.tuple.creator.impl.TableTupleCreator;
import com.qlangtech.tis.sql.parser.visitor.StreamTransformVisitor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class SqlTaskNode {
    public static File parent = new File(Config.getMetaCfgDir(), StoreResourceTypeConstants.getDataFlowRelativeDir());
    private Optional<TisGroupBy> groupBy = Optional.empty();
    private final IDumpNodeMapContext dumpNodesContext;
    public static final SqlParser parser = new SqlParser();
    private String content;
    private final Map<EntityName, SqlTaskNode> required = Maps.newHashMap();
    private final TaskNodeRecognizeVisitor taskNodeRecognizedVisitor;
    private final EntityName exportName;
    private final NodeType nodetype;
    private TableTupleCreator tupleCterator = null;

    public static List<ColumnMetaData> reflectTableCols(String sql) {
        if (StringUtils.isEmpty((String)sql)) {
            throw new IllegalArgumentException("param sql can not be null");
        }
        ArrayList result = Lists.newArrayList();
        Query query = SqlTaskNode.parseQuery(sql);
        StreamTransformVisitor v = new StreamTransformVisitor(null);
        query.accept((AstVisitor)v, new TISStackableAstVisitor.StackableAstVisitorContext<Integer>(1));
        ColRef colsRef = v.getColsRef();
        int index = 0;
        for (Map.Entry<ColName, IDataTupleCreator> entry : colsRef.getColRefMap().entrySet()) {
            result.add(new ColumnMetaData(index++, StringUtils.lowerCase((String)entry.getKey().getName()), new DataType(JDBCTypes.VARCHAR), false));
        }
        return result;
    }

    public SqlTaskNode(EntityName exportName, NodeType nodetype, IDumpNodeMapContext dumpNodesContext) {
        this.exportName = exportName;
        this.nodetype = nodetype;
        this.dumpNodesContext = dumpNodesContext;
        this.taskNodeRecognizedVisitor = new TaskNodeRecognizeVisitor(dumpNodesContext);
    }

    public EntityName getExportName() {
        return this.exportName;
    }

    public NodeType getNodetype() {
        return this.nodetype;
    }

    public void addRequired(String node) {
        if (StringUtils.isBlank((String)node)) {
            throw new IllegalArgumentException("param node can not be null");
        }
        EntityName ename = EntityName.parse((String)node);
        this.dumpNodesContext.accurateMatch(ename.getTabName());
        this.required.put(ename, null);
    }

    public void addRequired(EntityName node, SqlTaskNode taskNode) {
        if (node == null) {
            throw new IllegalArgumentException("param node can not be null");
        }
        if (taskNode == null) {
            throw new IllegalArgumentException("param taskNode can not be null");
        }
        this.required.put(node, taskNode);
    }

    public static Query parseQuery(String sql) {
        if (StringUtils.isBlank((String)sql)) {
            throw new NullPointerException("param sql can not be null");
        }
        Query query = (Query)parser.createStatement(sql, new ParsingOptions());
        return query;
    }

    public TableTupleCreator parse(boolean parseAllRefTab) {
        if (this.tupleCterator != null) {
            return this.tupleCterator;
        }
        this.tupleCterator = new TableTupleCreator(this.exportName.getTabName(), this.nodetype);
        this.tupleCterator.setRealEntityName(this.exportName);
        try {
            Query query = SqlTaskNode.parseQuery(this.getContent());
            StreamTransformVisitor v = new StreamTransformVisitor(this.dumpNodesContext);
            query.accept((AstVisitor)v, new TISStackableAstVisitor.StackableAstVisitorContext<Integer>(1));
            ColRef colsRefs = v.getColsRef();
            this.tupleCterator.setColsRefs(colsRefs);
            if (parseAllRefTab) {
                for (Map.Entry<String, IDataTupleCreator> entry : colsRefs.getBaseRefEntities()) {
                    entry.getValue().accept(this.taskNodeRecognizedVisitor);
                }
            }
            return this.tupleCterator;
        }
        catch (Exception e) {
            throw new RuntimeException("exportName:" + this.exportName, e);
        }
    }

    public Set<Map.Entry<EntityName, SqlTaskNode>> getRequired() {
        return this.required.entrySet();
    }

    public String getRequiredTabsSetLiteria() {
        return this.getRequired().stream().map(e -> String.valueOf(e.getKey())).collect(Collectors.joining(","));
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Optional<TisGroupBy> getGroupBy() {
        return this.groupBy;
    }

    public String toString() {
        return "SqlTaskNode:" + this.getExportName();
    }

    public static void main(String[] args) throws Exception {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SqlTaskNode)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return this.exportName.hashCode();
    }

    private static class TaskNodeRecognizeVisitor
    implements IDataTupleCreatorVisitor {
        private final IDumpNodeMapContext dumpNodesContext;

        public TaskNodeRecognizeVisitor(IDumpNodeMapContext dumpNodesContext) {
            this.dumpNodesContext = dumpNodesContext;
        }

        @Override
        public void visit(FunctionDataTupleCreator function) {
            for (IDataTupleCreator tupleCreator : function.getParams().values()) {
                tupleCreator.accept(this);
            }
        }

        @Override
        public void visit(TableTupleCreator tableTuple) {
            try {
                ColRef colRef = tableTuple.getColsRefs();
                if (colRef == null && tableTuple.getNodetype() == NodeType.JOINER_SQL) {
                    SqlTaskNode taskNode = this.dumpNodesContext.geTaskNode(tableTuple.getEntityName());
                    tableTuple.setColsRefs(taskNode.parse(true).getColsRefs());
                    taskNode.getGroupBy();
                    colRef = tableTuple.getColsRefs();
                    colRef.getBaseRefEntities().forEach(entry -> ((IDataTupleCreator)entry.getValue()).accept(this));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

