/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class SqlStringBuilder
implements Appendable {
    private List<Object> content = Lists.newArrayList();
    public static final ThreadLocal<RewriteProcessContext> inRewriteProcess = new ThreadLocal();

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        if (SqlStringBuilder.isInRewriteProcess()) {
            return this;
        }
        this.content.add(csq);
        return this;
    }

    public static boolean isInRewriteProcess() {
        return inRewriteProcess.get() != null;
    }

    public static RewriteProcessContext getProcessContext() {
        return inRewriteProcess.get();
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        if (SqlStringBuilder.isInRewriteProcess()) {
            return this;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(csq, start, end);
        this.content.add(builder);
        return this;
    }

    public SqlStringBuilder append(Object content) {
        if (SqlStringBuilder.isInRewriteProcess()) {
            return this;
        }
        this.content.add(content);
        return this;
    }

    public SqlStringBuilder append(String content) {
        if (SqlStringBuilder.isInRewriteProcess()) {
            return this;
        }
        this.content.add(content);
        return this;
    }

    public SqlStringBuilder appendIgnoreProcess(String content) {
        this.content.add(content);
        return this;
    }

    @Override
    public SqlStringBuilder append(char content) {
        if (SqlStringBuilder.isInRewriteProcess()) {
            return this;
        }
        this.content.add(Character.valueOf(content));
        return this;
    }

    public String getRawContent() {
        int[] index = new int[1];
        return this.buildContent(p -> {
            int n = index[0];
            index[0] = n + 1;
            return "callable" + n;
        });
    }

    public String toString() {
        return this.buildContent(p -> String.valueOf(p.call()));
    }

    private String buildContent(ICallableProcess p) {
        return this.content.stream().map(r -> {
            try {
                if (r instanceof Callable) {
                    return p.process((Callable)r);
                }
                return String.valueOf(r);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.joining());
    }

    public static class RewriteProcessContext {
        public Stack<String> tabAliasStack = new Stack();
    }

    static interface ICallableProcess {
        public String process(Callable var1) throws Exception;
    }
}

