/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser;

import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.google.common.collect.Lists;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.fullbuild.indexbuild.IDumpTable;
import com.qlangtech.tis.fullbuild.indexbuild.IPartionableWarehouse;
import com.qlangtech.tis.fullbuild.indexbuild.ITabPartition;
import com.qlangtech.tis.order.center.IJoinTaskContext;
import com.qlangtech.tis.sql.parser.ExpressionFormatter;
import com.qlangtech.tis.sql.parser.FormatContext;
import com.qlangtech.tis.sql.parser.FormatContextInLeftTabProcess;
import com.qlangtech.tis.sql.parser.IAliasTable;
import com.qlangtech.tis.sql.parser.SqlFormatter;
import com.qlangtech.tis.sql.parser.SqlStringBuilder;
import com.qlangtech.tis.sql.parser.TabPartitions;
import com.qlangtech.tis.sql.parser.er.IPrimaryTabFinder;
import com.qlangtech.tis.sql.parser.er.TableMeta;
import com.qlangtech.tis.sql.parser.exception.TisSqlFormatException;
import com.qlangtech.tis.sql.parser.meta.DependencyNode;
import com.qlangtech.tis.sql.parser.meta.NodeType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SqlRewriter
extends SqlFormatter.Formatter {
    public static final String ERROR_WithoutDefinePrimaryTableShareKey = "please check the Er rule of dataflow whether has set 'shardKey' or not";
    private final TabPartitions tabPartition;
    private final List<DependencyNode> dependencyNodes;
    private final IPartionableWarehouse dumpTableNameRewriter;
    final List<AliasTable> waitProcessAliasTabsSet = Lists.newArrayList();
    private AliasTable primayTable;
    private final boolean isFinal;
    private final IJoinTaskContext joinContext;

    public AliasTable getPrimayTable() {
        return this.primayTable;
    }

    @Override
    protected void setPrimayTable(AliasTable t) {
        this.primayTable = t;
    }

    public SqlRewriter(SqlStringBuilder builder, Map<IDumpTable, ITabPartition> tabPartition, List<DependencyNode> dependencies, Supplier<IPrimaryTabFinder> erRules, Optional<List<Expression>> parameters, boolean isFinal, IJoinTaskContext joinContext, IPartionableWarehouse dumpTableNameRewriter) {
        this(builder, new TabPartitions(tabPartition), dependencies, erRules, parameters, isFinal, joinContext, dumpTableNameRewriter);
    }

    public SqlRewriter(SqlStringBuilder builder, TabPartitions tabPartition, List<DependencyNode> dependencies, Supplier<IPrimaryTabFinder> erRules, Optional<List<Expression>> parameters, boolean isFinal, IJoinTaskContext joinContext, IPartionableWarehouse dumpTableNameRewriter) {
        super(builder, erRules, parameters);
        this.tabPartition = tabPartition;
        this.dependencyNodes = dependencies;
        this.isFinal = isFinal;
        Objects.requireNonNull(joinContext, "param joinContext can not be null");
        Objects.requireNonNull(joinContext.getExecutePhaseRange(), "executePhaseRange can not be null");
        this.joinContext = joinContext;
        this.dumpTableNameRewriter = dumpTableNameRewriter;
    }

    @Override
    protected String createPtPmodCols(AliasTable a) {
        if (this.isFinal) {
            Optional ptab = ((IPrimaryTabFinder)this.erRules.get()).getPrimaryTab(a.getTable());
            StringBuffer result = new StringBuffer(a.getAlias() + ".pt,");
            if (this.joinContext.getExecutePhaseRange().contains(FullbuildPhase.BUILD) && !TableMeta.hasValidPrimayTableSharedKey((Optional)ptab)) {
                throw new IllegalStateException(ERROR_WithoutDefinePrimaryTableShareKey);
            }
            if (ptab.isPresent()) {
                TableMeta tabMeta = (TableMeta)ptab.get();
                String shardKey = tabMeta.getSharedKey();
                if (StringUtils.isEmpty((String)shardKey)) {
                    throw new IllegalStateException(tabMeta.toString() + " has not set 'shardKey' ");
                }
                try {
                    Integer shardCount = this.joinContext.getIndexShardCount();
                    result.append("abs( hash( cast( ").append(a.getAlias()).append(".").append(shardKey).append(" as string)) % ").append(shardCount).append(" ) AS ").append("pmod");
                }
                catch (Exception e) {
                    throw new RuntimeException(tabMeta.toString(), e);
                }
            } else {
                result.append(a.getAlias()).append(".").append("pmod");
            }
            return result.toString();
        }
        return super.createPtPmodCols(a);
    }

    @Override
    protected Void visitSingleColumn(SingleColumn node, FormatContext indent) {
        return super.visitSingleColumn(node, indent);
    }

    @Override
    protected List<AliasTable> getWaitProcessAliasTabsSet() {
        return this.waitProcessAliasTabsSet;
    }

    @Override
    protected Void visitTable(Table tab, FormatContext indent) {
        String tableName = String.valueOf(tab.getName());
        QualifiedName tabName = tab.getName();
        TabPartitions.DumpTabPartition findTab = this.parseDumpTable(tabName);
        this.waitProcessAliasTabsSet.add(new AliasTable(tableName, findTab.tab, findTab.pt));
        this.processTable(findTab);
        return null;
    }

    private void processTable(TabPartitions.DumpTabPartition findTab) {
        IDumpTable t = findTab.tab;
        this.builder.append(t.getFullName());
    }

    @Override
    protected Void visitAliasedRelation(AliasedRelation node, FormatContext indent) {
        if (node.getRelation() instanceof Table) {
            Table tab = (Table)node.getRelation();
            TabPartitions.DumpTabPartition dumpTable = this.parseDumpTable(tab.getName());
            boolean primaryTable = indent instanceof FormatContextInLeftTabProcess;
            this.waitProcessAliasTabsSet.add(new AliasTable(node.getAlias().getValue(), dumpTable.tab, dumpTable.pt, false, primaryTable));
            this.processTable(dumpTable);
            this.builder.append(' ').append(ExpressionFormatter.formatExpression((Expression)node.getAlias(), this.parameters));
            SqlFormatter.appendAliasColumns(this.builder, node.getColumnNames());
            return null;
        }
        if (node.getRelation() instanceof TableSubquery) {
            SqlRewriter w = new SqlRewriter(new SqlStringBuilder(), this.tabPartition, this.dependencyNodes, (Supplier<IPrimaryTabFinder>)this.erRules, (Optional<List<Expression>>)this.parameters, false, this.joinContext, this.dumpTableNameRewriter);
            w.process((Node)node.getRelation(), new FormatContext(0));
            Optional subTable = w.getWaitProcessAliasTabsSet().stream().findFirst();
            if (!subTable.isPresent()) {
                throw new IllegalStateException("subtable:" + node.getAlias().getValue() + " can not find subtable");
            }
            this.waitProcessAliasTabsSet.add(new AliasTable(node.getAlias().getValue(), (AliasTable)subTable.get()));
            return super.visitAliasedRelation(node, indent);
        }
        throw new UnsupportedOperationException();
    }

    protected Void visitLogicalBinaryExpression(LogicalBinaryExpression node, FormatContext context) {
        if (SqlStringBuilder.isInRewriteProcess()) {
            this.process((Node)node.getLeft(), context);
            this.process((Node)node.getRight(), context);
        }
        return (Void)super.visitLogicalBinaryExpression(node, (Object)context);
    }

    @Override
    protected void processAppendPtWhere(Optional<Expression> where) {
        try {
            SqlStringBuilder.RewriteProcessContext processContext = new SqlStringBuilder.RewriteProcessContext();
            SqlStringBuilder.inRewriteProcess.set(processContext);
            if (where.isPresent()) {
                this.process((Node)where.get(), new FormatContext(9527));
            }
            if (this.hasAnyUnprocessedAliasTabsSet()) {
                if (where.isPresent()) {
                    this.builder.appendIgnoreProcess(" AND ");
                }
                this.builder.appendIgnoreProcess(this.getWaitProcessAliasTabsSet().stream().filter(r -> !r.isPtRewriterOver() && (!r.isSubQueryTable() || r.isPrimaryTable())).map(r -> {
                    r.setPtRewriter(true);
                    return r.getAliasPtCriteria();
                }).collect(Collectors.joining(" AND ")));
            }
        }
        finally {
            SqlStringBuilder.inRewriteProcess.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processJoinOn(JoinOn on) {
        try {
            SqlStringBuilder.RewriteProcessContext processContext = new SqlStringBuilder.RewriteProcessContext();
            SqlStringBuilder.inRewriteProcess.set(processContext);
            LogicalBinaryExpression logical = null;
            if (on.getExpression() instanceof LogicalBinaryExpression) {
                logical = (LogicalBinaryExpression)on.getExpression();
                this.process((Node)logical.getLeft(), new FormatContext(9527));
                this.process((Node)logical.getRight(), new FormatContext(9527));
                logical.getOperator();
            } else {
                this.process((Node)on.getExpression(), new FormatContext(9527));
            }
            this.processPTRewrite(processContext);
        }
        finally {
            SqlStringBuilder.inRewriteProcess.set(null);
        }
    }

    private void processPTRewrite(SqlStringBuilder.RewriteProcessContext processContext) {
        Optional<AliasTable> aliasOptional = null;
        AliasTable at = null;
        while (!processContext.tabAliasStack.isEmpty()) {
            String alias = processContext.tabAliasStack.pop();
            aliasOptional = this.getWaitProcessAliasTabsSet().stream().filter(r -> StringUtils.equals((String)r.getAlias(), (String)alias) && !r.isPtRewriterOver() && !r.isSubQueryTable() && !r.isPrimaryTable()).findFirst();
            if (!aliasOptional.isPresent()) continue;
            at = aliasOptional.get();
            this.builder.appendIgnoreProcess(" AND ").appendIgnoreProcess(at.getAliasPtCriteria());
            at.setPtRewriter(true);
        }
    }

    private TabPartitions.DumpTabPartition parseDumpTable(QualifiedName tabName) {
        List originalParts = tabName.getOriginalParts();
        Optional<Object> find = Optional.empty();
        if (originalParts.size() == 2) {
            String partDBName = (String)originalParts.get(0);
            String partTabName = (String)originalParts.get(1);
            find = this.findDumpPartition(partDBName, partTabName);
        } else if (originalParts.size() == 1) {
            String partTabName = (String)originalParts.get(0);
            find = this.findDumpPartition(null, partTabName);
        } else {
            throw new IllegalStateException("tabName:" + String.valueOf(tabName) + " is not illegal");
        }
        if (!find.isPresent()) {
            throw new TisSqlFormatException(String.valueOf(tabName) + " can not find tab in[" + this.tabPartition.joinFullNames() + "]", Optional.empty());
        }
        TabPartitions.DumpTabPartition findTab = (TabPartitions.DumpTabPartition)find.get();
        return findTab;
    }

    private Optional<TabPartitions.DumpTabPartition> findDumpPartition(String partDBName, String partTabName) {
        Optional find = Optional.empty();
        NodeType nodeType = null;
        if (this.dumpTableNameRewriter.noRewriteTabName()) {
            find = partDBName == null ? this.tabPartition.findTablePartition(partTabName) : this.tabPartition.findTablePartition(partDBName, partTabName);
        } else {
            boolean findDepNode = false;
            if (CollectionUtils.isEmpty(this.dependencyNodes)) {
                throw new IllegalArgumentException("param dependencies can not be empty");
            }
            for (DependencyNode depNode : this.dependencyNodes) {
                if (!StringUtils.equals((String)partTabName, (String)depNode.getName()) || partDBName != null && !StringUtils.equals((String)partDBName, (String)depNode.getDbName())) continue;
                findDepNode = true;
                nodeType = depNode.parseNodeType(false);
                if (nodeType == NodeType.DUMP) {
                    partTabName = this.dumpTableNameRewriter.appendTabPrefix(partTabName);
                }
                find = partDBName == null ? this.tabPartition.findTablePartition(partTabName) : this.tabPartition.findTablePartition(partDBName, partTabName);
                break;
            }
            if (!findDepNode) {
                throw new IllegalStateException(" have not find any match dependency node with:" + String.join((CharSequence)".", partDBName, partTabName) + " candidate nodes:" + this.dependencyNodes.stream().map(n -> String.valueOf(n)).collect(Collectors.joining(",")));
            }
        }
        return find;
    }

    public static class RewriterDumpTable
    implements IDumpTable {
        private final String dbname;
        private final String tabname;
        private final NodeType nodeType;

        private RewriterDumpTable(String dbname, String tabname, NodeType nodeType) {
            this.dbname = dbname;
            this.tabname = tabname;
            this.nodeType = nodeType;
        }

        public static RewriterDumpTable create(String dbname, String tabname, NodeType nodeType) {
            return new RewriterDumpTable(dbname, tabname, nodeType);
        }

        static RewriterDumpTable create(String tabname, NodeType nodeType) {
            return new RewriterDumpTable("tis", tabname, nodeType);
        }

        public boolean isDumpNode() {
            return this.nodeType == NodeType.DUMP;
        }

        public String getDbName() {
            return this.dbname;
        }

        public String getTableName() {
            return this.tabname;
        }

        public String getFullName() {
            return this.dbname + "." + this.tabname;
        }

        public int hashCode() {
            return this.getFullName().hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Objects.equals(this.getFullName(), ((RewriterDumpTable)o).getFullName());
        }

        public String toString() {
            return this.getFullName();
        }
    }

    public static class AliasTable
    implements IAliasTable {
        private final String alias;
        private final IDumpTable table;
        private final ITabPartition tabPartition;
        private boolean ptRewriter = false;
        private final boolean subQueryTable;
        private boolean selectPtAppendProcess = false;
        private boolean primaryTable;
        private AliasTable child;

        public AliasTable(String alias, IDumpTable table, ITabPartition tabPartition, boolean subQueryTable, boolean primaryTable) {
            this.table = table;
            this.alias = alias;
            if (tabPartition == null) {
                throw new IllegalStateException("alias:" + alias + ",table:" + table + " relevant partition can not be null");
            }
            this.tabPartition = tabPartition;
            this.subQueryTable = subQueryTable;
            this.primaryTable = primaryTable;
        }

        public boolean isPrimaryTable() {
            return this.primaryTable;
        }

        public String getPt() {
            return this.getTabPartition();
        }

        public AliasTable(String alias, IDumpTable table, ITabPartition tabPartition) {
            this(alias, table, tabPartition, false, false);
        }

        public AliasTable(String alias, AliasTable child) {
            this(alias, null, () -> {
                throw new UnsupportedOperationException("alias:" + alias + " not not support pt");
            }, true, false);
            this.setPtRewriter(true);
            this.child = child;
        }

        public boolean isPtRewriterOver() {
            return this.ptRewriter;
        }

        public void setPtRewriter(boolean ptRewriter) {
            this.ptRewriter = ptRewriter;
        }

        public boolean isSelectPtAppendProcess() {
            return this.selectPtAppendProcess;
        }

        public void makeSelectPtAppendProcess() {
            this.selectPtAppendProcess = true;
        }

        public boolean isSubQueryTable() {
            return this.subQueryTable;
        }

        public String getAliasPtCriteria() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getAlias()).append(".pt='").append(this.getTabPartition()).append("'");
            return buffer.toString();
        }

        public String getAlias() {
            return this.alias;
        }

        public IDumpTable getTable() {
            return this.table;
        }

        public String getTabPartition() {
            if (this.child != null) {
                return this.child.getTabPartition();
            }
            return this.tabPartition.getPt();
        }

        public AliasTable getChild() {
            return this.child;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("alias:").append(this.getAlias());
            buffer.append(",hasPtAppend:").append(this.selectPtAppendProcess);
            buffer.append(",hasProcess:").append(this.selectPtAppendProcess);
            if (this.subQueryTable) {
                return buffer.toString();
            }
            buffer.append(",table:").append(this.getTable()).append(",pt:").append(this.getTabPartition());
            return buffer.toString();
        }
    }
}

