/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser;

import com.facebook.presto.sql.TisExpressionFormatter;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainFormat;
import com.facebook.presto.sql.tree.ExplainOption;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.NaturalJoin;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SetPath;
import com.facebook.presto.sql.tree.ShowCatalogs;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Values;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.plugin.ds.ColMeta;
import com.qlangtech.tis.plugin.ds.DataType;
import com.qlangtech.tis.sql.parser.ExpressionFormatter;
import com.qlangtech.tis.sql.parser.FormatContext;
import com.qlangtech.tis.sql.parser.FormatContextInLeftTabProcess;
import com.qlangtech.tis.sql.parser.SqlRewriter;
import com.qlangtech.tis.sql.parser.SqlStringBuilder;
import com.qlangtech.tis.sql.parser.SqlTaskNodeMeta;
import com.qlangtech.tis.sql.parser.er.IPrimaryTabFinder;
import com.qlangtech.tis.sql.parser.er.TabFieldProcessor;
import com.qlangtech.tis.sql.parser.exception.TisSqlFormatException;
import com.qlangtech.tis.sql.parser.meta.ColumnTransfer;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public final class SqlFormatter {
    private static final String INDENT = "   ";
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-z_][a-z0-9_]*");

    private SqlFormatter() {
    }

    public static String formatSql(Node root, Optional<List<Expression>> parameters) {
        SqlStringBuilder builder = new SqlStringBuilder();
        new Formatter(builder, () -> new IPrimaryTabFinder(){}, parameters).process(root, new FormatContext(0));
        return builder.toString();
    }

    protected static void appendAliasColumns(SqlStringBuilder builder, List<Identifier> columns) {
        if (columns != null && !columns.isEmpty()) {
            String formattedColumns = columns.stream().map(name -> ExpressionFormatter.formatExpression((Expression)name, Optional.empty())).collect(Collectors.joining(", "));
            builder.append(" (").append(formattedColumns).append(')');
        }
    }

    public static class TableColumnTransferRewritFormatter
    extends Formatter {
        private final Map<String, EntityName> aliasTableMap;
        private final List<ColMeta> outputCols;

        public TableColumnTransferRewritFormatter(SqlStringBuilder builder, QueryFromTableFinder queryFromTableFinder, Supplier<IPrimaryTabFinder> erRules, List<ColMeta> outputCols) {
            super(builder, erRules, Optional.empty());
            this.aliasTableMap = queryFromTableFinder.getAliasTableMap();
            this.outputCols = outputCols;
        }

        @Override
        protected Void visitSingleColumn(SingleColumn node, FormatContext indent) {
            this.process((Node)node.getExpression(), new FormatContext(9527));
            ColMeta colMeta = null;
            if (node.getAlias().isPresent()) {
                this.builder.append(' ').append(ExpressionFormatter.formatExpression((Expression)node.getAlias().get(), this.parameters));
                colMeta = new ColMeta(String.valueOf(node.getAlias().get()), DataType.createVarChar((int)256), false);
            } else {
                Expression express = node.getExpression();
                String colName = (String)new AstVisitor<String, Void>(){

                    protected String visitDereferenceExpression(DereferenceExpression node, Void context) {
                        return this.visitIdentifier(node.getField(), context);
                    }

                    protected String visitIdentifier(Identifier node, Void context) {
                        return String.valueOf(node);
                    }
                }.process((Node)express);
                if (StringUtils.isEmpty((String)colName)) {
                    throw new TisSqlFormatException("\u5217\u5f15\u7528\u975e\u6cd5," + express + "\uff0c\u987b\u4f7f\u7528\u683c\u5f0f\u5982\uff1a'xxx as ccc'", express.getLocation());
                }
                colMeta = new ColMeta(colName, DataType.createVarChar((int)256), false);
            }
            this.outputCols.add(colMeta);
            return null;
        }

        @Override
        protected Void visitDereferenceExpression(DereferenceExpression node, FormatContext context) {
            Map.Entry tabExtraMeta;
            TabFieldProcessor extraMeta;
            Map columnTransferMap;
            ColumnTransfer cTransfer;
            if (!(node.getBase() instanceof Identifier)) {
                return super.visitDereferenceExpression(node, context);
            }
            Identifier base = (Identifier)node.getBase();
            Identifier field = node.getField();
            EntityName e = this.aliasTableMap.get(base.getValue());
            if (e == null) {
                throw new TisSqlFormatException("base ref:" + base.getValue() + " can not find relevant table entity in map,mapSize:" + this.aliasTableMap.size() + ",exist:" + this.aliasTableMap.entrySet().stream().map(entry -> "[" + (String)entry.getKey() + ":" + entry.getValue() + "]").collect(Collectors.joining(",")), node.getLocation());
            }
            Optional<Object> find = Optional.empty();
            if (!(e instanceof EntityName.SubTableQuery)) {
                find = ((IPrimaryTabFinder)this.erRules.get()).getTabFieldProcessorMap().entrySet().stream().filter(entry -> {
                    if (e.useDftDbName()) {
                        return StringUtils.equals((String)((EntityName)entry.getKey()).getTabName(), (String)e.getTabName());
                    }
                    return ((EntityName)entry.getKey()).equals((Object)e);
                }).findFirst();
            }
            if (find.isPresent() && (cTransfer = (ColumnTransfer)(columnTransferMap = (extraMeta = (TabFieldProcessor)(tabExtraMeta = (Map.Entry)find.get()).getValue()).colTransfersMap()).get(field.getValue())) != null) {
                this.builder.append(SqlTaskNodeMeta.HiveColTransfer.instance.transfer(base.getValue(), field.getValue(), cTransfer));
                return null;
            }
            return super.visitDereferenceExpression(node, context);
        }
    }

    public static class Formatter
    extends AstVisitor<Void, FormatContext> {
        protected final SqlStringBuilder builder;
        protected final Optional<List<Expression>> parameters;
        protected final List<ColMeta> outputCols = Lists.newArrayList();
        protected final Supplier<IPrimaryTabFinder> erRules;
        public static final int MAGIC_TOKEN_JOINON_PROCESS = 9527;

        public Formatter(SqlStringBuilder builder, Supplier<IPrimaryTabFinder> erRules, Optional<List<Expression>> parameters) {
            this.builder = builder;
            this.parameters = parameters;
            Objects.requireNonNull(erRules, "dumpNodeExtraMetaMap can not be null");
            this.erRules = erRules;
        }

        protected List<SqlRewriter.AliasTable> getWaitProcessAliasTabsSet() {
            return Collections.emptyList();
        }

        protected boolean hasAnyUnprocessedAliasTabsSet() {
            return this.getWaitProcessAliasTabsSet().stream().filter(r -> !r.isPtRewriterOver()).count() > 0L;
        }

        private Optional<SqlRewriter.AliasTable> getFirstUnprocessedAliasTab() {
            Optional<SqlRewriter.AliasTable> unprocessTabAlias = this.getWaitProcessAliasTabsSet().stream().filter(r -> {
                boolean result;
                boolean bl = result = !r.isSelectPtAppendProcess() && !r.isSubQueryTable();
                if (result) {
                    r.makeSelectPtAppendProcess();
                }
                return result;
            }).findFirst();
            if (unprocessTabAlias.isPresent()) {
                return unprocessTabAlias;
            }
            unprocessTabAlias = this.getWaitProcessAliasTabsSet().stream().filter(r -> {
                boolean result;
                boolean bl = result = !r.isSelectPtAppendProcess() && r.isSubQueryTable();
                if (result) {
                    r.makeSelectPtAppendProcess();
                }
                return result;
            }).findFirst();
            return unprocessTabAlias;
        }

        protected Void visitNode(Node node, FormatContext indent) {
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        protected Void visitExpression(Expression node, FormatContext indent) {
            if (indent.getIndent() != 9527) {
                Preconditions.checkArgument((indent.getIndent() == 0 ? 1 : 0) != 0, (Object)"visitExpression should only be called at root");
            }
            this.builder.append(ExpressionFormatter.formatExpression(node, this.parameters));
            return null;
        }

        protected Void visitComparisonExpression(ComparisonExpression node, FormatContext context) {
            if (SqlStringBuilder.isInRewriteProcess()) {
                this.process((Node)node.getLeft(), new FormatContext(9527));
                this.process((Node)node.getRight(), new FormatContext(9527));
            }
            return (Void)super.visitComparisonExpression(node, (Object)context);
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, FormatContext context) {
            if (SqlStringBuilder.isInRewriteProcess()) {
                SqlStringBuilder.RewriteProcessContext pcontext = SqlStringBuilder.getProcessContext();
                pcontext.tabAliasStack.push(String.valueOf(node.getBase()));
            }
            return (Void)super.visitDereferenceExpression(node, (Object)context);
        }

        protected Void visitQuery(Query node, FormatContext indent) {
            if (node.getWith().isPresent()) {
                throw new UnsupportedOperationException(String.valueOf(node.getWith()));
            }
            this.processRelation((Relation)node.getQueryBody(), indent);
            if (node.getOrderBy().isPresent()) {
                this.process((Node)node.getOrderBy().get(), indent);
            }
            if (node.getLimit().isPresent()) {
                this.append((int)indent.getIndent(), "LIMIT " + (String)node.getLimit().get()).append('\n');
            }
            return null;
        }

        protected void setPrimayTable(SqlRewriter.AliasTable primaryTable) {
        }

        protected Void visitQuerySpecification(QuerySpecification node, FormatContext context) {
            Optional<SqlRewriter.AliasTable> optAlias;
            int indent = context.getIndent();
            Optional from = node.getFrom();
            if (!from.isPresent()) {
                throw new IllegalStateException("querySpecification from mush present");
            }
            QueryFromTableFinder fromTableFinder = new QueryFromTableFinder();
            fromTableFinder.process((Node)from.get());
            new TableColumnTransferRewritFormatter(this.builder, fromTableFinder, this.erRules, (List<ColMeta>)(indent < 1 ? this.outputCols : Lists.newArrayList())).process((Node)node.getSelect(), context);
            SqlRewriter.AliasTable[] firstTableCriteria = new SqlRewriter.AliasTable[1];
            Callable<String> appendPtPmod = () -> {
                if (firstTableCriteria[0] == null) {
                    throw new IllegalStateException("can not find firstTableCriteria " + node);
                }
                SqlRewriter.AliasTable a = firstTableCriteria[0];
                return this.createPtPmodCols(a) + "\n";
            };
            if (this.shallCreatePtPmodCols()) {
                this.append(indent, ", ");
                this.builder.append(appendPtPmod);
            }
            if (node.getFrom().isPresent()) {
                this.append(indent, "FROM");
                this.builder.append('\n');
                this.append(indent, "  ");
                this.process((Node)node.getFrom().get(), context);
            }
            if (!(optAlias = this.getFirstUnprocessedAliasTab()).isPresent()) {
                throw new IllegalStateException("can not find firstTableCriteria " + node.getSelect());
            }
            firstTableCriteria[0] = optAlias.get();
            this.setPrimayTable(firstTableCriteria[0]);
            this.builder.append('\n');
            boolean hasWherePresent = false;
            if (node.getWhere().isPresent()) {
                this.append(indent, "WHERE " + ExpressionFormatter.formatExpression((Expression)node.getWhere().get(), this.parameters));
                hasWherePresent = true;
            }
            boolean hasPtRewritePresent = false;
            if (this.hasAnyUnprocessedAliasTabsSet()) {
                if (!hasWherePresent) {
                    this.append(indent, "WHERE ");
                }
                this.processAppendPtWhere(node.getWhere());
                hasPtRewritePresent = true;
            }
            if (hasWherePresent || hasPtRewritePresent) {
                this.append(indent, "\n");
            }
            if (node.getGroupBy().isPresent()) {
                this.append(indent, "GROUP BY " + (((GroupBy)node.getGroupBy().get()).isDistinct() ? " DISTINCT " : "") + TisExpressionFormatter.formatGroupBy(((GroupBy)node.getGroupBy().get()).getGroupingElements()));
                if (this.shallCreatePtPmodCols()) {
                    this.builder.append(',').append(appendPtPmod);
                }
            }
            if (node.getHaving().isPresent()) {
                this.append(indent, "HAVING " + ExpressionFormatter.formatExpression((Expression)node.getHaving().get(), this.parameters)).append('\n');
            }
            if (node.getOrderBy().isPresent()) {
                this.process((Node)node.getOrderBy().get(), context);
            }
            if (node.getLimit().isPresent()) {
                this.append(indent, "LIMIT " + (String)node.getLimit().get()).append('\n');
            }
            return null;
        }

        protected boolean shallCreatePtPmodCols() {
            return true;
        }

        protected String createPtPmodCols(SqlRewriter.AliasTable a) {
            return a.getAlias() + ".pt," + a.getAlias() + ".pmod";
        }

        protected void processAppendPtWhere(Optional<Expression> where) {
        }

        protected Void visitOrderBy(OrderBy node, FormatContext indent) {
            this.append((int)indent.getIndent(), TisExpressionFormatter.formatOrderBy(node, this.parameters)).append('\n');
            return null;
        }

        protected Void visitSelect(Select node, FormatContext indent) {
            this.append((int)indent.getIndent(), "SELECT");
            if (node.isDistinct()) {
                this.builder.append(" DISTINCT");
            }
            if (node.getSelectItems().size() > 1) {
                boolean first = true;
                for (SelectItem item : node.getSelectItems()) {
                    this.builder.append("\n").append(Formatter.indentString(indent.getIndent())).append(first ? "  " : ", ");
                    this.process((Node)item, indent);
                    first = false;
                }
            } else {
                this.builder.append(' ');
                this.process((Node)Iterables.getOnlyElement((Iterable)node.getSelectItems()), indent);
            }
            this.builder.append('\n');
            return null;
        }

        protected Void visitSingleColumn(SingleColumn node, FormatContext indent) {
            this.builder.append(ExpressionFormatter.formatExpression(node.getExpression(), this.parameters));
            if (node.getAlias().isPresent()) {
                this.builder.append(' ').append(ExpressionFormatter.formatExpression((Expression)node.getAlias().get(), this.parameters));
            }
            return null;
        }

        protected Void visitAllColumns(AllColumns node, FormatContext context) {
            this.builder.append(node.toString());
            return null;
        }

        protected Void visitTable(Table node, FormatContext indent) {
            this.builder.append(Formatter.formatName(node.getName()));
            return null;
        }

        protected Void visitJoin(Join node, FormatContext indent) {
            JoinCriteria criteria = node.getCriteria().orElse(null);
            Object type = node.getType().toString();
            if (criteria instanceof NaturalJoin) {
                type = "NATURAL " + (String)type;
            }
            this.process((Node)node.getLeft(), new FormatContextInLeftTabProcess(indent.getIndent()));
            this.builder.append('\n');
            if (node.getType() == Join.Type.IMPLICIT) {
                this.append((int)indent.getIndent(), ", ");
            } else {
                this.append((int)indent.getIndent(), (String)type).append(" JOIN ");
            }
            this.process((Node)node.getRight(), new FormatContext(indent.getIndent()));
            if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                if (criteria instanceof JoinUsing) {
                    JoinUsing using = (JoinUsing)criteria;
                    this.builder.append(" USING (").append(Joiner.on((String)", ").join((Iterable)using.getColumns())).append(")");
                } else if (criteria instanceof JoinOn) {
                    JoinOn on = (JoinOn)criteria;
                    this.builder.append(" ON (").append(ExpressionFormatter.formatExpression(on.getExpression(), this.parameters));
                    this.processJoinOn(on);
                    this.builder.append(")");
                } else if (!(criteria instanceof NaturalJoin)) {
                    throw new UnsupportedOperationException("unknown join criteria: " + criteria);
                }
            }
            return null;
        }

        protected void processJoinOn(JoinOn on) {
        }

        protected Void visitAliasedRelation(AliasedRelation node, FormatContext indent) {
            this.process((Node)node.getRelation(), indent);
            this.builder.append(' ').append(ExpressionFormatter.formatExpression((Expression)node.getAlias(), this.parameters));
            SqlFormatter.appendAliasColumns(this.builder, node.getColumnNames());
            return null;
        }

        protected Void visitSampledRelation(SampledRelation node, FormatContext indent) {
            this.process((Node)node.getRelation(), indent);
            this.builder.append(" TABLESAMPLE ").append(node.getType()).append(" (").append(node.getSamplePercentage()).append(')');
            return null;
        }

        protected Void visitValues(Values node, FormatContext indent) {
            this.builder.append(" VALUES ");
            boolean first = true;
            for (Expression row : node.getRows()) {
                this.builder.append("\n").append(Formatter.indentString(indent.getIndent())).append(first ? "  " : ", ");
                this.builder.append(ExpressionFormatter.formatExpression(row, this.parameters));
                first = false;
            }
            this.builder.append('\n');
            return null;
        }

        protected Void visitTableSubquery(TableSubquery node, FormatContext indent) {
            this.builder.append('(').append('\n');
            this.process((Node)node.getQuery(), new FormatContext(indent.getIndent() + 1));
            this.append((int)indent.getIndent(), ") ");
            return null;
        }

        protected Void visitUnion(Union node, FormatContext indent) {
            Iterator relations = node.getRelations().iterator();
            while (relations.hasNext()) {
                this.processRelation((Relation)relations.next(), indent);
                if (!relations.hasNext()) continue;
                this.builder.append("UNION ");
                if (node.isDistinct()) continue;
                this.builder.append("ALL ");
            }
            return null;
        }

        protected Void visitExcept(Except node, FormatContext indent) {
            this.processRelation(node.getLeft(), indent);
            this.builder.append("EXCEPT ");
            if (!node.isDistinct()) {
                this.builder.append("ALL ");
            }
            this.processRelation(node.getRight(), indent);
            return null;
        }

        protected Void visitIntersect(Intersect node, FormatContext indent) {
            Iterator relations = node.getRelations().iterator();
            while (relations.hasNext()) {
                this.processRelation((Relation)relations.next(), indent);
                if (!relations.hasNext()) continue;
                this.builder.append("INTERSECT ");
                if (node.isDistinct()) continue;
                this.builder.append("ALL ");
            }
            return null;
        }

        protected Void visitCreateView(CreateView node, FormatContext indent) {
            this.builder.append("CREATE ");
            if (node.isReplace()) {
                this.builder.append("OR REPLACE ");
            }
            this.builder.append("VIEW ").append(Formatter.formatName(node.getName())).append(" AS\n");
            this.process((Node)node.getQuery(), indent);
            return null;
        }

        protected Void visitDropView(DropView node, FormatContext context) {
            this.builder.append("DROP VIEW ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getName());
            return null;
        }

        protected Void visitExplain(Explain node, FormatContext indent) {
            this.builder.append("EXPLAIN ");
            if (node.isAnalyze()) {
                this.builder.append("ANALYZE ");
            }
            ArrayList<CallSite> options = new ArrayList<CallSite>();
            for (ExplainOption option : node.getOptions()) {
                if (option instanceof ExplainType) {
                    options.add((CallSite)((Object)("TYPE " + ((ExplainType)option).getType())));
                    continue;
                }
                if (option instanceof ExplainFormat) {
                    options.add((CallSite)((Object)("FORMAT " + ((ExplainFormat)option).getType())));
                    continue;
                }
                throw new UnsupportedOperationException("unhandled explain option: " + option);
            }
            try {
                if (!options.isEmpty()) {
                    this.builder.append("(");
                    Joiner.on((String)", ").appendTo((Appendable)this.builder, options);
                    this.builder.append(")");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.builder.append("\n");
            this.process((Node)node.getStatement(), indent);
            return null;
        }

        protected Void visitShowCatalogs(ShowCatalogs node, FormatContext context) {
            this.builder.append("SHOW CATALOGS");
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(TisExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        protected Void visitShowColumns(ShowColumns node, FormatContext context) {
            this.builder.append("SHOW COLUMNS FROM ").append(Formatter.formatName(node.getTable()));
            return null;
        }

        private String formatProperties(List<Property> properties) {
            if (properties.isEmpty()) {
                return "";
            }
            String propertyList = properties.stream().map(element -> SqlFormatter.INDENT + ExpressionFormatter.formatExpression((Expression)element.getName(), this.parameters) + " = " + ExpressionFormatter.formatExpression(element.getValue(), this.parameters)).collect(Collectors.joining(",\n"));
            return "\nWITH (\n" + propertyList + "\n)";
        }

        private static String formatName(String name) {
            if (NAME_PATTERN.matcher(name).matches()) {
                return name;
            }
            return "\"" + name.replace("\"", "\"\"") + "\"";
        }

        private static String formatName(QualifiedName name) {
            return name.getOriginalParts().stream().map(Formatter::formatName).collect(Collectors.joining("."));
        }

        protected Void visitDropTable(DropTable node, FormatContext context) {
            this.builder.append("DROP TABLE ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getTableName());
            return null;
        }

        protected Void visitRow(Row node, FormatContext indent) {
            this.builder.append("ROW(");
            boolean firstItem = true;
            for (Expression item : node.getItems()) {
                if (!firstItem) {
                    this.builder.append(", ");
                }
                this.process((Node)item, indent);
                firstItem = false;
            }
            this.builder.append(")");
            return null;
        }

        public Void visitSetPath(SetPath node, FormatContext indent) {
            this.builder.append("SET PATH ");
            this.builder.append(Joiner.on((String)", ").join((Iterable)node.getPathSpecification().getPath()));
            return null;
        }

        private void processRelation(Relation relation, FormatContext indent) {
            if (relation instanceof Table) {
                this.builder.append("TABLE ").append(((Table)relation).getName()).append('\n');
            } else {
                this.process((Node)relation, indent);
            }
        }

        private SqlStringBuilder append(int indent, String value) {
            return this.builder.append(Formatter.indentString(indent)).append(value);
        }

        private SqlStringBuilder append(int indent, Object value) {
            return this.builder.append(Formatter.indentString(indent)).append(value);
        }

        private static String indentString(int indent) {
            return Strings.repeat((String)SqlFormatter.INDENT, (int)indent);
        }
    }

    public static class QueryFromTableFinder
    extends AstVisitor<Void, Void> {
        private final Map<String, EntityName> aliasTableMap = Maps.newHashMap();

        public Map<String, EntityName> getAliasTableMap() {
            return this.aliasTableMap;
        }

        protected Void visitJoin(Join node, Void context) {
            this.process((Node)node.getLeft(), context);
            this.process((Node)node.getRight(), context);
            return null;
        }

        protected Void visitTable(Table node, Void context) {
            EntityName en = EntityName.parse((String)node.getName().toString());
            this.aliasTableMap.put(en.getTabName(), en);
            return null;
        }

        protected Void visitAliasedRelation(AliasedRelation node, Void context) {
            if (node.getRelation() instanceof Table) {
                Table table = (Table)node.getRelation();
                this.aliasTableMap.put(node.getAlias().getValue(), EntityName.parse((String)table.getName().toString()));
                return null;
            }
            if (node.getRelation() instanceof TableSubquery) {
                this.aliasTableMap.put(node.getAlias().getValue(), EntityName.createSubQueryTable());
                return null;
            }
            return (Void)super.visitAliasedRelation(node, (Object)context);
        }
    }
}

