/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser;

import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.AtTimeZone;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BinaryLiteral;
import com.facebook.presto.sql.tree.BindExpression;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CharLiteral;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Cube;
import com.facebook.presto.sql.tree.CurrentPath;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.CurrentUser;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.GroupingSets;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Rollup;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SimpleGroupBy;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.qlangtech.tis.sql.parser.SqlFormatter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ExpressionFormatter {
    private static final ThreadLocal<DecimalFormat> doubleFormatter = ThreadLocal.withInitial(() -> new DecimalFormat("0.###################E0###", new DecimalFormatSymbols(Locale.US)));

    private ExpressionFormatter() {
    }

    public static String formatExpression(Expression expression, Optional<List<Expression>> parameters) {
        return (String)new Formatter(parameters).process((Node)expression, null);
    }

    public static String formatQualifiedName(QualifiedName name) {
        return name.getParts().stream().map(ExpressionFormatter::formatIdentifier).collect(Collectors.joining("."));
    }

    public static String formatIdentifier(String s) {
        return s.replace("\"", "\"\"");
    }

    static String formatStringLiteral(String s) {
        s = s.replace("'", "''");
        if (CharMatcher.inRange((char)' ', (char)'~').matchesAllOf((CharSequence)s)) {
            return "'" + s + "'";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("U&'");
        PrimitiveIterator.OfInt iterator = s.codePoints().iterator();
        while (iterator.hasNext()) {
            int codePoint = iterator.nextInt();
            Preconditions.checkArgument((codePoint >= 0 ? 1 : 0) != 0, (String)"Invalid UTF-8 encoding in characters: %s", (Object)s);
            if (ExpressionFormatter.isAsciiPrintable(codePoint)) {
                char ch = (char)codePoint;
                if (ch == '\\') {
                    builder.append(ch);
                }
                builder.append(ch);
                continue;
            }
            if (codePoint <= 65535) {
                builder.append('\\');
                builder.append(String.format("%04X", codePoint));
                continue;
            }
            builder.append("\\+");
            builder.append(String.format("%06X", codePoint));
        }
        builder.append("'");
        return builder.toString();
    }

    static String formatOrderBy(OrderBy orderBy, Optional<List<Expression>> parameters) {
        return "ORDER BY " + ExpressionFormatter.formatSortItems(orderBy.getSortItems(), parameters);
    }

    static String formatSortItems(List<SortItem> sortItems, Optional<List<Expression>> parameters) {
        return Joiner.on((String)", ").join(sortItems.stream().map(ExpressionFormatter.sortItemFormatterFunction(parameters)).iterator());
    }

    static String formatGroupBy(List<GroupingElement> groupingElements) {
        return ExpressionFormatter.formatGroupBy(groupingElements, Optional.empty());
    }

    static String formatGroupBy(List<GroupingElement> groupingElements, Optional<List<Expression>> parameters) {
        ImmutableList.Builder resultStrings = ImmutableList.builder();
        for (GroupingElement groupingElement : groupingElements) {
            String result = "";
            if (groupingElement instanceof SimpleGroupBy) {
                ImmutableSet columns = ImmutableSet.copyOf((Collection)((SimpleGroupBy)groupingElement).getColumnExpressions());
                result = columns.size() == 1 ? ExpressionFormatter.formatExpression((Expression)Iterables.getOnlyElement((Iterable)columns), parameters) : ExpressionFormatter.formatGroupingSet((Set<Expression>)columns, parameters);
            } else if (groupingElement instanceof GroupingSets) {
                result = String.format("GROUPING SETS (%s)", Joiner.on((String)", ").join(((GroupingSets)groupingElement).getSets().stream().map(ExpressionFormatter::formatGroupingSet).iterator()));
            } else if (groupingElement instanceof Cube) {
                result = String.format("CUBE %s", ExpressionFormatter.formatGroupingSet(((Cube)groupingElement).getColumns()));
            } else if (groupingElement instanceof Rollup) {
                result = String.format("ROLLUP %s", ExpressionFormatter.formatGroupingSet(((Rollup)groupingElement).getColumns()));
            }
            resultStrings.add((Object)result);
        }
        return Joiner.on((String)", ").join((Iterable)resultStrings.build());
    }

    private static boolean isAsciiPrintable(int codePoint) {
        return codePoint < 127 && codePoint >= 32;
    }

    private static String formatGroupingSet(Set<Expression> groupingSet, Optional<List<Expression>> parameters) {
        return String.format("(%s)", Joiner.on((String)", ").join(groupingSet.stream().map(e -> ExpressionFormatter.formatExpression(e, parameters)).iterator()));
    }

    private static String formatGroupingSet(List<QualifiedName> groupingSet) {
        return String.format("(%s)", Joiner.on((String)", ").join(groupingSet));
    }

    private static Function<SortItem, String> sortItemFormatterFunction(Optional<List<Expression>> parameters) {
        return input -> {
            StringBuilder builder = new StringBuilder();
            builder.append(ExpressionFormatter.formatExpression(input.getSortKey(), parameters));
            switch (input.getOrdering()) {
                case ASCENDING: {
                    builder.append(" ASC");
                    break;
                }
                case DESCENDING: {
                    builder.append(" DESC");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown ordering: " + input.getOrdering());
                }
            }
            switch (input.getNullOrdering()) {
                case FIRST: {
                    builder.append(" NULLS FIRST");
                    break;
                }
                case LAST: {
                    builder.append(" NULLS LAST");
                    break;
                }
                case UNDEFINED: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown null ordering: " + input.getNullOrdering());
                }
            }
            return builder.toString();
        };
    }

    public static class Formatter
    extends AstVisitor<String, Void> {
        private final Optional<List<Expression>> parameters;

        public Formatter(Optional<List<Expression>> parameters) {
            this.parameters = parameters;
        }

        protected String visitNode(Node node, Void context) {
            throw new UnsupportedOperationException();
        }

        protected String visitRow(Row node, Void context) {
            return "ROW (" + Joiner.on((String)", ").join((Iterable)node.getItems().stream().map(child -> (String)this.process((Node)child, context)).collect(Collectors.toList())) + ")";
        }

        protected String visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException(String.format("not yet implemented: %s.visit%s", ((Object)((Object)this)).getClass().getName(), node.getClass().getSimpleName()));
        }

        protected String visitAtTimeZone(AtTimeZone node, Void context) {
            return (String)this.process((Node)node.getValue(), context) + " AT TIME ZONE " + (String)this.process((Node)node.getTimeZone(), context);
        }

        protected String visitCurrentUser(CurrentUser node, Void context) {
            return "CURRENT_USER";
        }

        protected String visitCurrentPath(CurrentPath node, Void context) {
            return "CURRENT_PATH";
        }

        protected String visitCurrentTime(CurrentTime node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append(node.getFunction().getName());
            if (node.getPrecision() != null) {
                builder.append('(').append(node.getPrecision()).append(')');
            }
            return builder.toString();
        }

        protected String visitExtract(Extract node, Void context) {
            return "EXTRACT(" + node.getField() + " FROM " + (String)this.process((Node)node.getExpression(), context) + ")";
        }

        protected String visitBooleanLiteral(BooleanLiteral node, Void context) {
            return String.valueOf(node.getValue());
        }

        protected String visitStringLiteral(StringLiteral node, Void context) {
            return ExpressionFormatter.formatStringLiteral(node.getValue());
        }

        protected String visitCharLiteral(CharLiteral node, Void context) {
            return "CHAR " + ExpressionFormatter.formatStringLiteral(node.getValue());
        }

        protected String visitBinaryLiteral(BinaryLiteral node, Void context) {
            return "X'" + node.toHexString() + "'";
        }

        protected String visitParameter(Parameter node, Void context) {
            if (this.parameters.isPresent()) {
                Preconditions.checkArgument((node.getPosition() < this.parameters.get().size() ? 1 : 0) != 0, (String)"Invalid parameter number %s.  Max value is %s", (int)node.getPosition(), (int)(this.parameters.get().size() - 1));
                return (String)this.process((Node)this.parameters.get().get(node.getPosition()), context);
            }
            return "?";
        }

        protected String visitArrayConstructor(ArrayConstructor node, Void context) {
            ImmutableList.Builder valueStrings = ImmutableList.builder();
            for (Expression value : node.getValues()) {
                valueStrings.add((Object)SqlFormatter.formatSql((Node)value, this.parameters));
            }
            return "ARRAY[" + Joiner.on((String)",").join((Iterable)valueStrings.build()) + "]";
        }

        protected String visitSubscriptExpression(SubscriptExpression node, Void context) {
            return SqlFormatter.formatSql((Node)node.getBase(), this.parameters) + "[" + SqlFormatter.formatSql((Node)node.getIndex(), this.parameters) + "]";
        }

        protected String visitLongLiteral(LongLiteral node, Void context) {
            return Long.toString(node.getValue());
        }

        protected String visitDoubleLiteral(DoubleLiteral node, Void context) {
            return doubleFormatter.get().format(node.getValue());
        }

        protected String visitDecimalLiteral(DecimalLiteral node, Void context) {
            return "DECIMAL '" + node.getValue() + "'";
        }

        protected String visitGenericLiteral(GenericLiteral node, Void context) {
            return node.getType() + " " + ExpressionFormatter.formatStringLiteral(node.getValue());
        }

        protected String visitTimeLiteral(TimeLiteral node, Void context) {
            return "TIME '" + node.getValue() + "'";
        }

        protected String visitTimestampLiteral(TimestampLiteral node, Void context) {
            return "TIMESTAMP '" + node.getValue() + "'";
        }

        protected String visitNullLiteral(NullLiteral node, Void context) {
            return "null";
        }

        protected String visitIntervalLiteral(IntervalLiteral node, Void context) {
            String sign = node.getSign() == IntervalLiteral.Sign.NEGATIVE ? "- " : "";
            StringBuilder builder = new StringBuilder().append("INTERVAL ").append(sign).append(" '").append(node.getValue()).append("' ").append(node.getStartField());
            if (node.getEndField().isPresent()) {
                builder.append(" TO ").append(node.getEndField().get());
            }
            return builder.toString();
        }

        protected String visitSubqueryExpression(SubqueryExpression node, Void context) {
            return "(" + SqlFormatter.formatSql((Node)node.getQuery(), this.parameters) + ")";
        }

        protected String visitExists(ExistsPredicate node, Void context) {
            return "(EXISTS " + SqlFormatter.formatSql((Node)node.getSubquery(), this.parameters) + ")";
        }

        protected String visitIdentifier(Identifier node, Void context) {
            if (!node.isDelimited()) {
                return node.getValue();
            }
            return "\"" + node.getValue().replace("\"", "\"\"") + "\"";
        }

        protected String visitLambdaArgumentDeclaration(LambdaArgumentDeclaration node, Void context) {
            return ExpressionFormatter.formatExpression((Expression)node.getName(), this.parameters);
        }

        protected String visitSymbolReference(SymbolReference node, Void context) {
            return ExpressionFormatter.formatIdentifier(node.getName());
        }

        protected String visitDereferenceExpression(DereferenceExpression node, Void context) {
            String baseString = (String)this.process((Node)node.getBase(), context);
            return baseString + "." + (String)this.process((Node)node.getField());
        }

        public String visitFieldReference(FieldReference node, Void context) {
            return ":input(" + node.getFieldIndex() + ")";
        }

        protected String visitFunctionCall(FunctionCall node, Void context) {
            StringBuilder builder = new StringBuilder();
            Object arguments = this.joinExpressions(node.getArguments());
            if (node.getArguments().isEmpty() && "count".equalsIgnoreCase(node.getName().getSuffix())) {
                arguments = "*";
            }
            if (node.getArguments().size() == 2 && "op_and".equalsIgnoreCase(node.getName().getSuffix())) {
                builder.append("(").append(Joiner.on((String)" & ").join(node.getArguments().stream().map(e -> (String)this.process((Node)e, null)).iterator())).append(")");
                return builder.toString();
            }
            if (node.isDistinct()) {
                arguments = "DISTINCT " + (String)arguments;
            }
            builder.append(ExpressionFormatter.formatQualifiedName(node.getName())).append('(').append((String)arguments);
            if (node.getOrderBy().isPresent()) {
                builder.append(' ').append(ExpressionFormatter.formatOrderBy((OrderBy)node.getOrderBy().get(), this.parameters));
            }
            builder.append(')');
            if (node.getFilter().isPresent()) {
                builder.append(" FILTER ").append(this.visitFilter((Expression)node.getFilter().get(), context));
            }
            if (node.getWindow().isPresent()) {
                builder.append(" OVER ").append(this.visitWindow((Window)node.getWindow().get(), context));
            }
            return builder.toString();
        }

        protected String visitLambdaExpression(LambdaExpression node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            Joiner.on((String)", ").appendTo(builder, (Iterable)node.getArguments());
            builder.append(") -> ");
            builder.append((String)this.process((Node)node.getBody(), context));
            return builder.toString();
        }

        protected String visitBindExpression(BindExpression node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("\"$INTERNAL$BIND\"(");
            for (Expression value : node.getValues()) {
                builder.append((String)this.process((Node)value, context) + ", ");
            }
            builder.append((String)this.process((Node)node.getFunction(), context) + ")");
            return builder.toString();
        }

        protected String visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            return this.formatBinaryExpression(node.getOperator().toString(), node.getLeft(), node.getRight());
        }

        protected String visitNotExpression(NotExpression node, Void context) {
            return "(NOT " + (String)this.process((Node)node.getValue(), context) + ")";
        }

        protected String visitComparisonExpression(ComparisonExpression node, Void context) {
            return this.formatBinaryExpression(node.getOperator().getValue(), node.getLeft(), node.getRight());
        }

        protected String visitIsNullPredicate(IsNullPredicate node, Void context) {
            return "(" + (String)this.process((Node)node.getValue(), context) + " IS NULL)";
        }

        protected String visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            return "(" + (String)this.process((Node)node.getValue(), context) + " IS NOT NULL)";
        }

        protected String visitNullIfExpression(NullIfExpression node, Void context) {
            return "NULLIF(" + (String)this.process((Node)node.getFirst(), context) + ", " + (String)this.process((Node)node.getSecond(), context) + ")";
        }

        protected String visitIfExpression(IfExpression node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("IF(").append((String)this.process((Node)node.getCondition(), context)).append(", ").append((String)this.process((Node)node.getTrueValue(), context));
            if (node.getFalseValue().isPresent()) {
                builder.append(", ").append((String)this.process((Node)node.getFalseValue().get(), context));
            }
            builder.append(")");
            return builder.toString();
        }

        protected String visitTryExpression(TryExpression node, Void context) {
            return "TRY(" + (String)this.process((Node)node.getInnerExpression(), context) + ")";
        }

        protected String visitCoalesceExpression(CoalesceExpression node, Void context) {
            return "COALESCE(" + this.joinExpressions(node.getOperands()) + ")";
        }

        protected String visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            String value = (String)this.process((Node)node.getValue(), context);
            switch (node.getSign()) {
                case MINUS: {
                    String separator = value.startsWith("-") ? " " : "";
                    return "-" + separator + value;
                }
                case PLUS: {
                    return "+" + value;
                }
            }
            throw new UnsupportedOperationException("Unsupported sign: " + node.getSign());
        }

        protected String visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            return this.formatBinaryExpression(node.getOperator().getValue(), node.getLeft(), node.getRight());
        }

        protected String visitLikePredicate(LikePredicate node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append('(').append((String)this.process((Node)node.getValue(), context)).append(" LIKE ").append((String)this.process((Node)node.getPattern(), context));
            node.getEscape().ifPresent(escape -> builder.append(" ESCAPE ").append((String)this.process((Node)escape, context)));
            builder.append(')');
            return builder.toString();
        }

        protected String visitAllColumns(AllColumns node, Void context) {
            if (node.getPrefix().isPresent()) {
                return node.getPrefix().get() + ".*";
            }
            return "*";
        }

        public String visitCast(Cast node, Void context) {
            return (node.isSafe() ? "TRY_CAST" : "CAST") + "(" + (String)this.process((Node)node.getExpression(), context) + " AS " + node.getType() + ")";
        }

        protected String visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            ImmutableList.Builder parts = ImmutableList.builder();
            parts.add((Object)"CASE");
            for (WhenClause whenClause : node.getWhenClauses()) {
                parts.add((Object)((String)this.process((Node)whenClause, context)));
            }
            node.getDefaultValue().ifPresent(value -> parts.add((Object)"ELSE").add((Object)((String)this.process((Node)value, context))));
            parts.add((Object)"END");
            return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
        }

        protected String visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            ImmutableList.Builder parts = ImmutableList.builder();
            parts.add((Object)"CASE").add((Object)((String)this.process((Node)node.getOperand(), context)));
            for (WhenClause whenClause : node.getWhenClauses()) {
                parts.add((Object)((String)this.process((Node)whenClause, context)));
            }
            node.getDefaultValue().ifPresent(value -> parts.add((Object)"ELSE").add((Object)((String)this.process((Node)value, context))));
            parts.add((Object)"END");
            return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
        }

        protected String visitWhenClause(WhenClause node, Void context) {
            return "WHEN " + (String)this.process((Node)node.getOperand(), context) + " THEN " + (String)this.process((Node)node.getResult(), context);
        }

        protected String visitBetweenPredicate(BetweenPredicate node, Void context) {
            return "(" + (String)this.process((Node)node.getValue(), context) + " BETWEEN " + (String)this.process((Node)node.getMin(), context) + " AND " + (String)this.process((Node)node.getMax(), context) + ")";
        }

        protected String visitInPredicate(InPredicate node, Void context) {
            return "(" + (String)this.process((Node)node.getValue(), context) + " IN " + (String)this.process((Node)node.getValueList(), context) + ")";
        }

        protected String visitInListExpression(InListExpression node, Void context) {
            return "(" + this.joinExpressions(node.getValues()) + ")";
        }

        private String visitFilter(Expression node, Void context) {
            return "(WHERE " + (String)this.process((Node)node, context) + ")";
        }

        public String visitWindow(Window node, Void context) {
            ArrayList<Object> parts = new ArrayList<Object>();
            if (!node.getPartitionBy().isEmpty()) {
                parts.add("PARTITION BY " + this.joinExpressions(node.getPartitionBy()));
            }
            if (node.getOrderBy().isPresent()) {
                parts.add(ExpressionFormatter.formatOrderBy((OrderBy)node.getOrderBy().get(), this.parameters));
            }
            if (node.getFrame().isPresent()) {
                parts.add((String)this.process((Node)node.getFrame().get(), context));
            }
            return "(" + Joiner.on((char)' ').join(parts) + ")";
        }

        public String visitWindowFrame(WindowFrame node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append(node.getType().toString()).append(' ');
            if (node.getEnd().isPresent()) {
                builder.append("BETWEEN ").append((String)this.process((Node)node.getStart(), context)).append(" AND ").append((String)this.process((Node)node.getEnd().get(), context));
            } else {
                builder.append((String)this.process((Node)node.getStart(), context));
            }
            return builder.toString();
        }

        public String visitFrameBound(FrameBound node, Void context) {
            switch (node.getType()) {
                case UNBOUNDED_PRECEDING: {
                    return "UNBOUNDED PRECEDING";
                }
                case PRECEDING: {
                    return (String)this.process((Node)node.getValue().get(), context) + " PRECEDING";
                }
                case CURRENT_ROW: {
                    return "CURRENT ROW";
                }
                case FOLLOWING: {
                    return (String)this.process((Node)node.getValue().get(), context) + " FOLLOWING";
                }
                case UNBOUNDED_FOLLOWING: {
                    return "UNBOUNDED FOLLOWING";
                }
            }
            throw new IllegalArgumentException("unhandled type: " + node.getType());
        }

        protected String visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, Void context) {
            return "(" + (String)this.process((Node)node.getValue(), context) + ' ' + node.getOperator().getValue() + ' ' + node.getQuantifier().toString() + ' ' + (String)this.process((Node)node.getSubquery(), context) + ")";
        }

        public String visitGroupingOperation(GroupingOperation node, Void context) {
            return "GROUPING (" + this.joinExpressions(node.getGroupingColumns()) + ")";
        }

        private String formatBinaryExpression(String operator, Expression left, Expression right) {
            return "(" + (String)this.process((Node)left, null) + " " + operator + " " + (String)this.process((Node)right, null) + ")";
        }

        private String joinExpressions(List<Expression> expressions) {
            return Joiner.on((String)", ").join(expressions.stream().map(e -> (String)this.process((Node)e, null)).iterator());
        }
    }
}

