/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser;

import com.google.common.collect.Maps;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.manage.common.incr.StreamContextConstant;
import com.qlangtech.tis.offline.DbScope;
import com.qlangtech.tis.plugin.ds.DBIdentity;
import com.qlangtech.tis.plugin.ds.DataSourceFactoryPluginStore;
import com.qlangtech.tis.plugin.ds.FacadeDataSource;
import com.qlangtech.tis.plugin.ds.PostedDSProp;
import com.qlangtech.tis.sql.parser.IDBNodeMeta;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class DBNode
implements IDBNodeMeta {
    private static final Logger logger = LoggerFactory.getLogger(DBNode.class);
    private final String dbName;
    private final int dbId;
    private long timestampVer;
    private static final Yaml yaml = new Yaml((BaseConstructor)new Constructor(new LoaderOptions()));

    public static void dump(List<DBNode> nodes, File f) throws Exception {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)FileUtils.openOutputStream((File)f), TisUTF8.get()){};){
            yaml.dump(nodes.stream().map(r -> {
                HashMap row = Maps.newHashMap();
                row.put("dbname", r.getDbName());
                row.put("dbid", r.getDbId());
                row.put("timestamp", new Long(r.getTimestampVer()));
                return row;
            }).collect(Collectors.toList()), (Writer)writer);
        }
    }

    public static void registerDependencyDbsFacadeConfig(String collection, long timestamp, DefaultListableBeanFactory factory) {
        try {
            Map<String, DataSourceFactoryPluginStore> dbConfigsMap = null;
            try (FileInputStream input = FileUtils.openInputStream((File)StreamContextConstant.getDbDependencyConfigMetaFile(collection, timestamp));){
                dbConfigsMap = DBNode.load(input).stream().collect(Collectors.toMap(db -> db.getDbName(), db -> TIS.getDataSourceFactoryPluginStore((PostedDSProp)new PostedDSProp(DBIdentity.parseId((String)db.getDbName()), DbScope.FACADE))));
                FacadeDataSource ds = null;
                for (Map.Entry<String, DataSourceFactoryPluginStore> entry : dbConfigsMap.entrySet()) {
                    ds = entry.getValue().createFacadeDataSource();
                    factory.registerSingleton(entry.getKey() + "Datasource", (Object)ds.dataSource);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<DBNode> load(InputStream inputstrea) throws Exception {
        try (InputStreamReader reader = new InputStreamReader(inputstrea, TisUTF8.get()){};){
            Object o = yaml.load((Reader)reader);
            List configMap = (List)o;
            List<DBNode> list = configMap.stream().map(r -> {
                String dbname = (String)r.get("dbname");
                Integer dbid = (Integer)r.get("dbid");
                DBNode db = new DBNode(dbname, dbid);
                db.setTimestampVer(Long.parseLong(String.valueOf(r.get("timestamp"))));
                return db;
            }).collect(Collectors.toList());
            return list;
        }
    }

    public DBNode(String dbName, int dbId) {
        if (StringUtils.isBlank((String)dbName)) {
            throw new IllegalArgumentException("param dbName can not be null");
        }
        if (dbId < 1) {
            throw new IllegalArgumentException("param dbId can not be null");
        }
        this.dbName = dbName;
        this.dbId = dbId;
    }

    public File getDaoDir() {
        return StreamContextConstant.getDAORootDir(this.getDbName(), this.getTimestampVer());
    }

    public long getTimestampVer() {
        return this.timestampVer;
    }

    public DBNode setTimestampVer(long timestampVer) {
        this.timestampVer = timestampVer;
        return this;
    }

    public String getDbName() {
        return this.dbName;
    }

    public int getDbId() {
        return this.dbId;
    }

    public String toString() {
        return "{dbName='" + this.dbName + "', dbId=" + this.dbId + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBNode dbNode = (DBNode)o;
        return this.dbId == dbNode.dbId;
    }

    public int hashCode() {
        return this.dbId;
    }
}

