/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qlangtech.tis.datax.DBDataXChildTask;
import com.qlangtech.tis.datax.DataXJobSubmit;
import com.qlangtech.tis.datax.IDataXBatchPost;
import com.qlangtech.tis.datax.IDataXGenerateCfgs;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.IDataxReader;
import com.qlangtech.tis.datax.IDataxWriter;
import com.qlangtech.tis.datax.impl.DataXCfgGenerator;
import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.fullbuild.indexbuild.IRemoteTaskPostTrigger;
import com.qlangtech.tis.fullbuild.indexbuild.IRemoteTaskPreviousTrigger;
import com.qlangtech.tis.fullbuild.indexbuild.IRemoteTaskTrigger;
import com.qlangtech.tis.fullbuild.indexbuild.RemoteTaskTriggers;
import com.qlangtech.tis.fullbuild.taskflow.TaskAndMilestone;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.powerjob.IDAGSessionSpec;
import com.qlangtech.tis.powerjob.SelectedTabTriggers;
import com.tis.hadoop.rpc.RpcServiceReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DAGSessionSpec
implements IDAGSessionSpec {
    Map<String, DAGSessionSpec> dptNodes = Maps.newHashMap();
    private static final String KEY_ROOT = "root";
    private final String id;
    List<DAGSessionSpec> attains = Lists.newArrayList();
    boolean milestone = false;
    private final Map<String, TaskAndMilestone> taskMap;

    public Set<String> getDptNodeNames() {
        return this.dptNodes.keySet();
    }

    public static SelectedTabTriggers buildTaskTriggers(IExecChainContext execChainContext, IDataxProcessor appSource, DataXJobSubmit submit, RpcServiceReference statusRpc, ISelectedTab entry, String dumpTaskId, IDAGSessionSpec dagSessionSpec, IDataXGenerateCfgs cfgFileNames) {
        SelectedTabTriggers tabTriggers = new SelectedTabTriggers(entry, appSource);
        RemoteTaskTriggers triggers = Objects.requireNonNull(execChainContext.getTskTriggers(), "triggers can not be null");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dumpTaskId)) {
            throw new IllegalArgumentException("param dumpTaskId can not be null");
        }
        IRemoteTaskTrigger jobTrigger = null;
        IDataxWriter writerr = appSource.getWriter(null, true);
        if (CollectionUtils.isEmpty((Collection)cfgFileNames.getDataXCfgFiles())) {
            throw new IllegalStateException("dataX cfgFileNames can not be empty");
        }
        IDAGSessionSpec dumpSpec = dagSessionSpec.getDpt(dumpTaskId).setMilestone();
        IDAGSessionSpec[] postSpec = new DAGSessionSpec[1];
        Pair preAndPost = IDataXBatchPost.process((IDataxProcessor)appSource, (ISelectedTab)entry, (batchPostTask, entryName) -> {
            IRemoteTaskPreviousTrigger preExec = null;
            IRemoteTaskPostTrigger postTaskTrigger = batchPostTask.createPostTask(execChainContext, entryName, entry, cfgFileNames);
            if (postTaskTrigger != null) {
                postSpec[0] = dumpSpec.getDpt(postTaskTrigger.getTaskName());
                triggers.addJoinPhaseTask((IRemoteTaskTrigger)postTaskTrigger);
                tabTriggers.setPostTrigger(postTaskTrigger);
            }
            if ((preExec = batchPostTask.createPreExecuteTask(execChainContext, entryName, entry)) != null) {
                dagSessionSpec.getDpt(preExec.getTaskName());
                triggers.addDumpPhaseTask((IRemoteTaskTrigger)preExec);
                tabTriggers.setPreTrigger(preExec);
            }
            return Pair.of((Object)preExec, (Object)postTaskTrigger);
        });
        List dataXCfgsOfTab = cfgFileNames.getDataXTaskDependencies(entry.getName());
        DataXJobSubmit.IDataXJobContext dataXJobContext = submit.createJobContext(execChainContext);
        Objects.requireNonNull(dataXJobContext, "dataXJobContext can not be null");
        ArrayList splitTabTriggers = Lists.newArrayList();
        for (DBDataXChildTask fileName : dataXCfgsOfTab) {
            jobTrigger = DAGSessionSpec.createDataXJob(dataXJobContext, submit, statusRpc, appSource, new DataXJobSubmit.TableDataXEntity(fileName, entry));
            IDAGSessionSpec childDumpSpec = DAGSessionSpec.getDumpSpec(postSpec[0], dumpSpec).getDpt(Objects.requireNonNull(jobTrigger, "jobTrigger can not be null").getTaskName());
            if (preAndPost.getKey() != null) {
                childDumpSpec.getDpt(((IRemoteTaskPreviousTrigger)preAndPost.getKey()).getTaskName());
            }
            triggers.addDumpPhaseTask(jobTrigger);
            splitTabTriggers.add(jobTrigger);
        }
        tabTriggers.setSplitTabTriggers(splitTabTriggers);
        return tabTriggers;
    }

    public static Pair<DAGSessionSpec, List<ISelectedTab>> createDAGSessionSpec(IExecChainContext execChainContext, RpcServiceReference statusRpc, IDataxProcessor appSource, DataXCfgGenerator.GenerateCfgs cfgFileNames, DataXJobSubmit submit) {
        IDataxReader reader = appSource.getReader(null);
        DAGSessionSpec sessionSpec = new DAGSessionSpec();
        List selectedTabs = reader.getSelectedTabs();
        int selectedTabCount = 0;
        for (ISelectedTab entry : selectedTabs) {
            if (!cfgFileNames.getTargetTabs().contains(entry.getName())) continue;
            ++selectedTabCount;
            DAGSessionSpec.buildTaskTriggers(execChainContext, appSource, submit, statusRpc, entry, entry.getName(), sessionSpec, (IDataXGenerateCfgs)cfgFileNames);
        }
        if (selectedTabCount < 1) {
            throw new IllegalStateException(selectedTabs.stream().map(tab -> tab.getName()).collect(Collectors.joining(",")) + " relevant selectedTabCount can not small than 1");
        }
        return Pair.of((Object)sessionSpec, (Object)selectedTabs);
    }

    protected static IRemoteTaskTrigger createDataXJob(DataXJobSubmit.IDataXJobContext execChainContext, DataXJobSubmit submit, RpcServiceReference statusRpc, IDataxProcessor appSource, DataXJobSubmit.TableDataXEntity fileName) {
        if (submit.getType() == DataXJobSubmit.InstanceType.DISTRIBUTE) {
            // empty if block
        }
        return submit.createDataXJob(execChainContext, statusRpc, appSource, fileName);
    }

    private static IDAGSessionSpec getDumpSpec(IDAGSessionSpec postSpec, IDAGSessionSpec dumpSpec) {
        if (postSpec != null) {
            return postSpec;
        }
        if (dumpSpec != null) {
            return dumpSpec;
        }
        throw new IllegalStateException("neither postSpec nor dumpSpec can be null");
    }

    public Map<String, TaskAndMilestone> getTaskMap() {
        return this.taskMap;
    }

    public IDAGSessionSpec setMilestone() {
        this.milestone = true;
        this.taskMap.put(this.id, TaskAndMilestone.createMilestone(this.id));
        return this;
    }

    public DAGSessionSpec(String id, Map<String, TaskAndMilestone> taskMap) {
        this.id = id;
        this.taskMap = taskMap;
    }

    public DAGSessionSpec() {
        this(KEY_ROOT, Maps.newHashMap());
    }

    public StringBuffer buildSpec() {
        return this.buildSpec(Sets.newHashSet(), dpt -> {});
    }

    public StringBuffer buildSpec(Consumer<Pair<String, String>> dptConsumer) {
        return this.buildSpec(Sets.newHashSet(), dptConsumer);
    }

    private StringBuffer buildSpec(Set<String> collected, Consumer<Pair<String, String>> dependency) {
        StringBuffer specs = new StringBuffer();
        for (DAGSessionSpec spec : this.dptNodes.values()) {
            specs.append(spec.buildSpec(collected, dependency)).append(" ");
        }
        if (StringUtils.equals((String)this.id, (String)KEY_ROOT)) {
            return specs;
        }
        if (!this.milestone && collected.add(this.id)) {
            specs.append(this.dptNodes.values().stream().map(n -> {
                dependency.accept(Pair.of((Object)n.id, (Object)this.id));
                return n.id;
            }).collect(Collectors.joining(","))).append("->").append(this.id);
            if (CollectionUtils.isNotEmpty(this.attains)) {
                specs.append("->").append(this.attains.stream().map(a -> {
                    dependency.accept(Pair.of((Object)this.id, (Object)a.id));
                    return a.id;
                }).collect(Collectors.joining(",")));
            }
        }
        return specs;
    }

    public IDAGSessionSpec getDpt(String id) {
        DAGSessionSpec spec = null;
        spec = this.dptNodes.get(id);
        if (spec == null) {
            spec = this.addDpt(id);
            if (this.milestone) {
                spec.attains.add(this);
            }
            return spec;
        }
        return spec;
    }

    private DAGSessionSpec addDpt(String id) {
        DAGSessionSpec spec = new DAGSessionSpec(id, this.taskMap);
        this.dptNodes.put(id, spec);
        return spec;
    }

    public DAGSessionSpec addDpt(DAGSessionSpec spec) {
        this.dptNodes.put(spec.id, spec);
        return this;
    }

    public void put(String taskName, TaskAndMilestone taskAndMilestone) {
        this.taskMap.put(taskName, taskAndMilestone);
    }
}

