/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.realtime.transfer.ruledriven;

import com.google.common.collect.Maps;
import java.util.Map;

public abstract class TypeCast<T> {
    public static final Map<String, TypeCast<?>> castToType = Maps.newHashMap();

    public abstract T cast(Object var1);

    public static TypeCast<?> getTypeCast(String type) {
        TypeCast<?> cast = castToType.get(type);
        if (cast == null) {
            throw new IllegalStateException("type:" + type + " relevant type case have not been defined");
        }
        return cast;
    }

    static {
        castToType.put("string", new TypeCast<String>(){

            @Override
            public String cast(Object val) {
                return val == null ? null : String.valueOf(val);
            }
        });
        castToType.put("int", new TypeCast<Integer>(){

            @Override
            public Integer cast(Object val) {
                if (val == null) {
                    return 0;
                }
                if (val instanceof Integer) {
                    return (Integer)val;
                }
                return Integer.parseInt(String.valueOf(val));
            }
        });
    }
}

