/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.realtime.transfer.ruledriven;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.qlangtech.tis.realtime.transfer.IRowValueGetter;
import com.qlangtech.tis.realtime.transfer.ruledriven.GroupValues;
import com.qlangtech.tis.realtime.transfer.ruledriven.TypeCast;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.json.JSONTokener;

public class FunctionUtils {
    private static final Comparator<Object> rowValueGetterComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };
    private static final Pattern jsonPropPattern = Pattern.compile("\\$\\.([^\\s]+?)");
    private static final LoadingCache<String, Pattern> patternCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Pattern>(){

        public Pattern load(String pattern) throws Exception {
            return Pattern.compile(pattern);
        }
    });

    public static String concat(String a, String b) {
        return StringUtils.join((Object[])new Object[]{a, b});
    }

    public static int instr(String str, String substr) {
        return StringUtils.indexOf((String)str, (String)substr);
    }

    public static int op_and(String val, int andVal) {
        return FunctionUtils.op_and(Integer.parseInt(val), andVal);
    }

    public static int op_and(int val, int andVal) {
        return val & andVal;
    }

    public static List<String> split(String val, String pattern) {
        ArrayList result = Lists.newArrayList();
        try {
            Pattern p = (Pattern)patternCache.get((Object)pattern);
            Matcher matcher = p.matcher(val);
            int current = 0;
            int start = 0;
            while (matcher.find()) {
                start = matcher.start();
                if (start > current) {
                    result.add(StringUtils.substring((String)val, (int)current, (int)start));
                }
                current = matcher.end();
            }
            if (current < val.length()) {
                result.add(StringUtils.substring((String)val, (int)current));
            }
            return result;
        }
        catch (ExecutionException e) {
            throw new RuntimeException("val:" + val + ",pattern:" + pattern, e);
        }
    }

    public static String getArrayIndexProp(List<String> array, int index) {
        if (index < 0 || index >= array.size()) {
            return "";
        }
        return array.get(index);
    }

    public static void main(String[] args) {
        List<String> split = FunctionUtils.split("20:32|\u5df2\u5a5a\u7537\u58eb|15253653555|8f931168c2b44f7bb05e77e27286ce0c", "\\|");
        System.out.println("xxxx:" + FunctionUtils.getArrayIndexProp(split, 3));
        Method method = FunctionUtils.getMethod("min", GroupValues.class, IValGetter.class);
        System.out.println(method);
        System.out.println(method.getReturnType());
        method = FunctionUtils.getMethod("concat_ws", String.class, Object[].class);
        System.out.println(method);
        method = FunctionUtils.getMethod("round", Double.TYPE, Integer.TYPE);
        System.out.println(method);
    }

    public static List<Object> collect_list(GroupValues groupValues, IValGetter valGetter) {
        return groupValues.vals.stream().map(d -> valGetter.getVal((IRowValueGetter)d)).collect(Collectors.toList());
    }

    public static Set<Object> collect_set(GroupValues groupValues, IValGetter valGetter) {
        return groupValues.vals.stream().map(r -> valGetter.getVal((IRowValueGetter)r)).collect(Collectors.toSet());
    }

    public static int count(GroupValues groupVales, IIntValGetter getter) {
        if (groupVales == null || groupVales.vals == null) {
            return 0;
        }
        return groupVales.vals.size();
    }

    public static Object min(GroupValues groupVales, IValGetter valGetter) {
        Optional<Object> min = groupVales.vals.stream().map(r -> valGetter.getVal((IRowValueGetter)r)).min(rowValueGetterComparator);
        if (!min.isPresent()) {
            throw new IllegalStateException("datas can not find minist elements");
        }
        return min.get();
    }

    public static Object max(GroupValues groupVales, IValGetter valGetter) {
        Optional<Object> max = groupVales.vals.stream().map(r -> valGetter.getVal((IRowValueGetter)r)).max(rowValueGetterComparator);
        if (!max.isPresent()) {
            throw new IllegalStateException("datas can not find maxist elements");
        }
        return max.get();
    }

    public static double round(double input, int scale) {
        if (Double.isNaN(input) || Double.isInfinite(input)) {
            return input;
        }
        return BigDecimal.valueOf(input).setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static double sum(GroupValues datas, IDoubleValGetter valGetter) {
        double sum = 0.0;
        for (IRowValueGetter g : datas.vals) {
            sum += valGetter.getVal(g);
        }
        return sum;
    }

    public static Object defaultVal(Object ... o) {
        for (int i = 0; i < o.length; ++i) {
            if (o[i] == null) continue;
            return o[i];
        }
        return null;
    }

    public static String get_json_object(String val, String pattern) {
        if (!StringUtils.startsWith((String)val, (String)"{")) {
            return null;
        }
        try {
            Matcher matcher = jsonPropPattern.matcher(pattern);
            if (!matcher.matches()) {
                throw new IllegalStateException("json prop pattern:" + pattern + " is not match pattern:" + jsonPropPattern);
            }
            JSONTokener tokener = new JSONTokener(val);
            JSONObject o = new JSONObject(tokener);
            String propKey = matcher.group(1);
            if (o.isNull(propKey)) {
                return null;
            }
            return o.getString(propKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static double defaultDoubleVal(Object ... o) {
        for (int i = 0; i < o.length; ++i) {
            if (o[i] == null) continue;
            if (o[i] instanceof String) {
                return Double.parseDouble((String)o[i]);
            }
            return (Double)o[i];
        }
        return 0.0;
    }

    public static String concat_ws(String separator, Set<Object> valList) {
        return FunctionUtils.concat_ws_collection(separator, valList);
    }

    public static String concat_ws(String separator, List<Object> valList) {
        return FunctionUtils.concat_ws_collection(separator, valList);
    }

    private static String concat_ws_collection(String separator, Collection<Object> valList) {
        return valList.stream().map(r -> String.valueOf(r)).collect(Collectors.joining(separator));
    }

    public static String concat_ws(String separator, Object ... objs) {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (Object o : objs) {
            if (o instanceof Collection) {
                vals.addAll((Collection)o);
                continue;
            }
            vals.add(o);
        }
        return FunctionUtils.concat_ws(separator, vals);
    }

    public static Object caseIfFunc(Object defaultVal, Case ... cases) {
        for (Case c : cases) {
            if (!c.matchIf()) continue;
            return c.dftVal;
        }
        return defaultVal;
    }

    public static <T> T typeCast(String type, Object val) {
        TypeCast<?> c = TypeCast.getTypeCast(type);
        if (c == null) {
            throw new IllegalStateException("type:" + type + " relevant TypeCast can not be null");
        }
        return (T)c.cast(val);
    }

    public static boolean rlike(String val, String pattern) {
        return FunctionUtils.regexp(val, pattern);
    }

    public static boolean regexp(String val, String pattern) {
        try {
            Pattern p = (Pattern)patternCache.get((Object)pattern);
            Matcher m = p.matcher(val);
            return m.find();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("val:" + val + ",pattern:" + pattern, e);
        }
    }

    public static Method getMethod(String name, Class<?> ... parameterTypes) {
        try {
            return FunctionUtils.class.getMethod(name, parameterTypes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class Case {
        private final Callable<Boolean> matchIf;
        private final Object dftVal;

        public Case(Callable<Boolean> matchIf, Object dftVal) {
            this.matchIf = matchIf;
            this.dftVal = dftVal;
        }

        public boolean matchIf() {
            try {
                return this.matchIf.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface IIntValGetter {
        public int getVal(IRowValueGetter var1);
    }

    public static interface IDoubleValGetter {
        public double getVal(IRowValueGetter var1);
    }

    public static interface IStrValGetter {
        public String getVal(IRowValueGetter var1);
    }

    public static interface IValGetter {
        public Object getVal(IRowValueGetter var1);
    }
}

