/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.powerjob;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.datax.CuratorDataXTaskMessage;
import com.qlangtech.tis.datax.DataXJobInfo;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.fullbuild.indexbuild.IRemoteTaskPostTrigger;
import com.qlangtech.tis.fullbuild.indexbuild.IRemoteTaskPreviousTrigger;
import com.qlangtech.tis.fullbuild.indexbuild.IRemoteTaskTrigger;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.powerjob.SelectedTabTriggersConfig;
import com.qlangtech.tis.trigger.util.JsonUtil;
import java.util.List;
import java.util.Objects;

public class SelectedTabTriggers {
    private static final String KEY_TABLE = "table";
    private static final String KEY_PRE = "pre";
    private static final String KEY_POST = "post";
    private static final String KEY_EXEC = "exec";
    private static final String KEY_RES_TYPE = "resType";
    private static final String KEY_JOB_INFO = "jobInfo";
    private IRemoteTaskPreviousTrigger preTrigger;
    private IRemoteTaskPostTrigger postTrigger;
    private List<IRemoteTaskTrigger> splitTabTriggers;
    private final ISelectedTab entry;
    private final IDataxProcessor appSource;
    private JSONObject mrParams = null;

    public SelectedTabTriggers(ISelectedTab entry, IDataxProcessor appSource) {
        this.entry = Objects.requireNonNull(entry, "selected tab can not be null");
        this.appSource = Objects.requireNonNull(appSource, "appSource can not be null");
    }

    public String getTabName() {
        return this.entry.getName();
    }

    public IRemoteTaskPreviousTrigger getPreTrigger() {
        return this.preTrigger;
    }

    public void setPreTrigger(IRemoteTaskPreviousTrigger preTrigger) {
        this.preTrigger = preTrigger;
    }

    public IRemoteTaskPostTrigger getPostTrigger() {
        return this.postTrigger;
    }

    public void setPostTrigger(IRemoteTaskPostTrigger postTrigger) {
        this.postTrigger = postTrigger;
    }

    public List<IRemoteTaskTrigger> getSplitTabTriggers() {
        return this.splitTabTriggers;
    }

    public void setSplitTabTriggers(List<IRemoteTaskTrigger> splitTabTriggers) {
        this.splitTabTriggers = splitTabTriggers;
    }

    public static SelectedTabTriggersConfig deserialize(JSONObject jobParams) {
        if (jobParams == null) {
            throw new IllegalArgumentException("param jobParams can not be null");
        }
        if (!jobParams.containsKey((Object)KEY_EXEC)) {
            throw new IllegalStateException("shall contain property with key:exec\n" + JsonUtil.toString((Object)jobParams));
        }
        JSONObject exec = jobParams.getJSONObject(KEY_EXEC);
        SelectedTabTriggersConfig triggersConfig = new SelectedTabTriggersConfig(StoreResourceType.valueOf((String)exec.getString(KEY_RES_TYPE)), jobParams.getString("dataxName"), jobParams.getString(KEY_TABLE));
        if (jobParams.containsKey((Object)KEY_PRE)) {
            triggersConfig.preTrigger = jobParams.getString(KEY_PRE);
        }
        if (jobParams.containsKey((Object)KEY_POST)) {
            triggersConfig.postTrigger = jobParams.getString(KEY_POST);
        }
        CuratorDataXTaskMessage taskMessage = null;
        JSONArray splitTabCfgs = exec.getJSONArray(KEY_JOB_INFO);
        List splits = splitTabCfgs.toJavaList(SplitTabInfo.class);
        for (SplitTabInfo s : splits) {
            taskMessage = (CuratorDataXTaskMessage)jobParams.getObject(KEY_EXEC, CuratorDataXTaskMessage.class);
            taskMessage.setJobName(s.getDataXInfo());
            taskMessage.setTaskSerializeNum(s.getTaskSerializeNum());
            triggersConfig.addSplitCfg(taskMessage);
        }
        return triggersConfig;
    }

    public JSONObject createMRParams() {
        if (this.mrParams == null) {
            JSONObject execCfg = null;
            JSONArray dataxJobInfo = null;
            PowerJobRemoteTaskTrigger splitTabTrigger = null;
            this.mrParams = this.appSource.createNode();
            this.mrParams.put(KEY_TABLE, (Object)this.entry.getName());
            if (this.getPreTrigger() != null) {
                this.mrParams.put(KEY_PRE, (Object)this.getPreTrigger().getTaskName());
            }
            if (this.getPostTrigger() != null) {
                this.mrParams.put(KEY_POST, (Object)this.getPostTrigger().getTaskName());
            }
            execCfg = null;
            for (IRemoteTaskTrigger splitTrigger : this.getSplitTabTriggers()) {
                splitTabTrigger = Objects.requireNonNull((PowerJobRemoteTaskTrigger)splitTrigger);
                if (execCfg == null) {
                    execCfg = JSONObject.parseObject((String)splitTabTrigger.getTskMsgSerialize());
                    this.mrParams.put(KEY_EXEC, (Object)execCfg);
                    dataxJobInfo = new JSONArray();
                    execCfg.put(KEY_JOB_INFO, (Object)dataxJobInfo);
                }
                dataxJobInfo.add((Object)new SplitTabInfo(splitTabTrigger.getTaskSerializeNum(), splitTabTrigger.getDataXJobInfo().serialize()));
            }
        }
        return this.mrParams;
    }

    public static class PowerJobRemoteTaskTrigger
    implements IRemoteTaskTrigger {
        private final DataXJobInfo dataXJobInfo;
        private final CuratorDataXTaskMessage tskMsg;

        public PowerJobRemoteTaskTrigger(DataXJobInfo dataXJobInfo, CuratorDataXTaskMessage tskMsg) {
            this.dataXJobInfo = dataXJobInfo;
            this.tskMsg = tskMsg;
        }

        public String getTaskName() {
            return this.dataXJobInfo.jobFileName;
        }

        public String getTskMsgSerialize() {
            this.tskMsg.setJobName(null);
            return CuratorDataXTaskMessage.serialize((CuratorDataXTaskMessage)this.tskMsg);
        }

        public int getTaskSerializeNum() {
            return this.tskMsg.getTaskSerializeNum();
        }

        public DataXJobInfo getDataXJobInfo() {
            return this.dataXJobInfo;
        }

        public void run() {
            throw new UnsupportedOperationException();
        }
    }

    public static class SplitTabInfo {
        private int taskSerializeNum;
        private String dataXInfo;

        public SplitTabInfo(int taskSerializeNum, String dataXInfo) {
            this.taskSerializeNum = taskSerializeNum;
            this.dataXInfo = dataXInfo;
        }

        public int getTaskSerializeNum() {
            return this.taskSerializeNum;
        }

        public String getDataXInfo() {
            return this.dataXInfo;
        }

        public void setTaskSerializeNum(int taskSerializeNum) {
            this.taskSerializeNum = taskSerializeNum;
        }

        public void setDataXInfo(String dataXInfo) {
            this.dataXInfo = dataXInfo;
        }
    }
}

