/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common.incr;

import com.qlangtech.tis.coredefine.module.action.TargetResName;
import com.qlangtech.tis.manage.common.incr.StreamContextConstant;
import com.qlangtech.tis.plugin.PluginAndCfgsSnapshot;
import java.io.File;
import java.io.OutputStream;
import java.util.Objects;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UberJarUtil {
    private static final Logger logger = LoggerFactory.getLogger(UberJarUtil.class);

    public static File createStreamUberJar(TargetResName collection, long timestamp) throws Exception {
        File streamUberJar = null;
        Manifest manifest = null;
        try {
            streamUberJar = UberJarUtil.getStreamUberJarFile(collection).getFile();
            manifest = PluginAndCfgsSnapshot.createFlinkIncrJobManifestCfgAttrs((TargetResName)collection, (long)timestamp);
        }
        catch (Exception e) {
            throw new RuntimeException("name:" + collection.getName() + ",timestamp:" + timestamp, e);
        }
        try (JarOutputStream jaroutput = new JarOutputStream((OutputStream)FileUtils.openOutputStream((File)streamUberJar, (boolean)false), Objects.requireNonNull(manifest, "manifest can not be null"));){
            jaroutput.flush();
            File file = streamUberJar;
            return file;
        }
    }

    public static StreamContextConstant.TISRes getStreamUberJarFile(TargetResName collection) {
        StreamContextConstant.TISRes streamScriptRootDir = StreamContextConstant.getStreamScriptRootDir(collection.getName(), false);
        long timestamp = 0L;
        String uberJarPath = streamScriptRootDir.getRelevantPath() + "/0/" + StreamContextConstant.getIncrStreamJarName(collection.getName());
        File streamUberJar = StreamContextConstant.getIncrStreamJarFile(collection.getName(), 0L);
        logger.info("streamUberJar path:{}", (Object)streamUberJar.getAbsolutePath());
        return new StreamContextConstant.TISRes(streamUberJar, uberJarPath);
    }
}

