/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common.incr;

import com.qlangtech.tis.manage.common.CenterResource;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.plugin.ds.DBConfig;
import com.qlangtech.tis.sql.parser.DBNode;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class StreamContextConstant {
    public static final String KEY_DIR_TRASH_NAME = ".trash";
    public static final String DIR_STREAMS_SCRIPT = "streamscript";
    public static final String DIR_META = "meta";
    public static final String DIR_DAO = "dao";
    public static final String FILE_DB_DEPENDENCY_CONFIG = "db_dependency_config.yaml";

    public static String getDbDependencyConfigFilePath(String collection, long timestamp) {
        return "streamscript/" + collection + "/" + timestamp + "/meta/db_dependency_config.yaml";
    }

    public static File getDAORootDir(String dbName, long timestamp) {
        return new File(Config.getMetaCfgDir(), StreamContextConstant.getDAORootPath(dbName, timestamp));
    }

    public static File getDAOJarFile(DBNode dbNode) {
        return new File(StreamContextConstant.getDAORootDir(dbNode.getDbName(), dbNode.getTimestampVer()), DBConfig.getDAOJarName((String)dbNode.getDbName()));
    }

    public static String getDAORootPath(String dbName, long timestamp) {
        if (timestamp < 1L) {
            throw new IllegalArgumentException("param timestamp:" + timestamp + " can not small than 1");
        }
        return "dao/" + DBConfig.getFormatDBName((String)dbName) + "/" + timestamp;
    }

    public static File getStreamScriptRootDir(String collectionName) {
        return StreamContextConstant.getStreamScriptRootDir((String)collectionName, (boolean)false).file;
    }

    public static TISRes getStreamScriptRootDir(String collectionName, boolean trash) {
        String relevantPath = DIR_STREAMS_SCRIPT + (trash ? "/.trash" : "") + "/" + collectionName;
        return new TISRes(new File(Config.getMetaCfgDir() + "/" + relevantPath), relevantPath);
    }

    public static File getStreamScriptRootDir(String collectionName, long timestamp) {
        return new File(StreamContextConstant.getStreamScriptRootDir(collectionName), String.valueOf(timestamp));
    }

    public static String getIncrStreamJarName(String collection) {
        return StringUtils.lowerCase((String)(collection + "-incr.jar"));
    }

    public static File getIncrStreamJarFile(String collection, long timestamp) {
        return new File(StreamContextConstant.getStreamScriptRootDir(collection, timestamp), StreamContextConstant.getIncrStreamJarName(collection));
    }

    public static File getDbDependencyConfigMetaFile(String collectionName, long incrScriptTimestamp) {
        return new File(StreamContextConstant.getStreamScriptRootDir(collectionName, incrScriptTimestamp), "meta/db_dependency_config.yaml");
    }

    public static class TISRes {
        private final File file;
        private final String relevantPath;

        public TISRes(File file, String relevantPath) {
            this.file = file;
            this.relevantPath = relevantPath;
        }

        public void sync2Local(boolean isConfig) {
            CenterResource.copyFromRemote2Local((String)this.relevantPath, (boolean)isConfig);
        }

        public File getFile() {
            return this.file;
        }

        public String getRelevantPath() {
            return this.relevantPath;
        }
    }
}

