/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import java.util.LinkedList;
import java.util.Optional;

public class TISStackableAstVisitor<R, C>
extends AstVisitor<R, StackableAstVisitorContext<C>> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R process(Node node, StackableAstVisitorContext<C> context) {
        context.push(node);
        try {
            Object object = node.accept((AstVisitor)this, context);
            return (R)object;
        }
        finally {
            context.pop();
        }
    }

    public static void main(String[] args) {
        LinkedList<Integer> stack = new LinkedList<Integer>();
        stack.push(1);
        stack.push(2);
        stack.push(3);
        for (int i = 0; i < 3; ++i) {
            System.out.println(stack.get(i));
        }
        System.out.println(stack.poll());
        System.out.println(stack.poll());
        System.out.println(stack.poll());
    }

    public static class StackableAstVisitorContext<C> {
        private final LinkedList<Node> stack = new LinkedList();
        private final C context;
        private int stackDeepth;
        public boolean processSelect = false;

        public StackableAstVisitorContext(C context) {
            this.context = context;
        }

        public C getContext() {
            return this.context;
        }

        private void pop() {
            --this.stackDeepth;
            this.stack.pop();
        }

        public int getStackDeepth() {
            return this.stackDeepth;
        }

        void push(Node node) {
            ++this.stackDeepth;
            this.stack.push(node);
        }

        public Optional<Node> getPreviousNode() {
            if (this.stack.size() > 1) {
                return Optional.of(this.stack.get(1));
            }
            return Optional.empty();
        }
    }
}

